/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.DatumShiftGridCompressed;
import org.apache.sis.referencing.operation.provider.DatumShiftGridFile;
import org.apache.sis.referencing.operation.provider.DatumShiftGridGroup;
import org.apache.sis.referencing.operation.provider.DatumShiftGridLoader;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlTransient
public final class NTv2
extends AbstractProvider {
    private static final long serialVersionUID = -4027618007780159180L;
    static final ParameterDescriptor<URI> FILE;
    private static final ParameterDescriptorGroup PARAMETERS;

    public NTv2() {
        super(Transformation.class, PARAMETERS, EllipsoidalCS.class, false, EllipsoidalCS.class, false);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
        return NTv2.createMathTransform(NTv2.class, factory, values, 2);
    }

    static MathTransform createMathTransform(Class<? extends AbstractProvider> provider, MathTransformFactory factory, ParameterValueGroup values, int version2) throws ParameterNotFoundException, FactoryException {
        DatumShiftGridFile<Angle, Angle> grid;
        Parameters pg = Parameters.castOrWrap(values);
        URI file = pg.getMandatoryValue(FILE);
        try {
            grid = NTv2.getOrLoad(provider, file, version2);
        }
        catch (Exception e2) {
            throw DatumShiftGridLoader.canNotLoad(provider.getSimpleName(), file, e2);
        }
        return DatumShiftGridFile.createGeodeticTransformation(provider, factory, grid);
    }

    static DatumShiftGridFile<Angle, Angle> getOrLoad(Class<? extends AbstractProvider> provider, URI file, int version2) throws Exception {
        URI resolved = Loader.toAbsolutePath(file);
        return DatumShiftGridFile.getOrLoad(resolved, null, () -> {
            DatumShiftGridFile<Angle, Angle> grid;
            try (ReadableByteChannel in = Loader.newByteChannel(resolved);){
                DatumShiftGridLoader.startLoading(provider, file);
                Loader loader = new Loader(in, file, version2);
                grid = loader.readAllGrids();
                loader.report(provider);
            }
            return grid.useSharedData();
        }).castTo(Angle.class, Angle.class);
    }

    static {
        ParameterBuilder builder = NTv2.builder();
        FILE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8656")).addName("Latitude and longitude difference file")).create(URI.class, null);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9615")).addName("NTv2")).createGroup(FILE);
    }

    private static final class Loader
    extends DatumShiftGridLoader {
        private static final int RECORD_LENGTH = 16;
        private static final int KEY_LENGTH = 8;
        private static final Map<String, DataType> TYPES;
        private final Map<String, Object> header = new LinkedHashMap<String, Object>();
        private final String[] overviewKeys;
        private final boolean isV2;
        private boolean hasUnrecognized;
        private final int numGrids;
        private String created;
        private String updated;

        Loader(ReadableByteChannel channel, URI file, int version2) throws IOException, FactoryException {
            super(channel, ByteBuffer.allocate(4096), file);
            this.ensureBufferContains(16);
            if (Loader.isLittleEndian(this.buffer.getInt(8))) {
                this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.readHeader(version2 >= 2 ? 11 : 12, "NUM_OREC");
            String vs = (String)this.get("VERSION", false);
            if (vs != null) {
                for (int i = 0; i < vs.length(); ++i) {
                    char c = vs.charAt(i);
                    if (c < '0' || c > '9') continue;
                    version2 = c - 48;
                    break;
                }
            }
            Integer n = (Integer)this.get("NUM_FILE", vs != null && version2 >= 2);
            boolean bl = this.isV2 = n != null;
            if (this.isV2) {
                this.numGrids = n;
                if (this.numGrids < 1) {
                    throw new FactoryException(Errors.format((short)144, "NUM_FILE", n));
                }
            } else {
                this.numGrids = 1;
            }
            this.overviewKeys = (String[])this.header.keySet().toArray(String[]::new);
        }

        private static boolean isLittleEndian(int n) {
            return Integer.compareUnsigned(n, Integer.reverseBytes(n)) > 0;
        }

        private String readString(int length) {
            byte[] array = this.buffer.array();
            int position = this.buffer.position();
            this.buffer.position(position + length);
            while (length > position && array[position + length - 1] <= 32) {
                --length;
            }
            return new String(array, position, length, StandardCharsets.US_ASCII).trim();
        }

        private void readHeader(int numRecords, String numkey) throws IOException, FactoryException {
            for (int i = 0; i < numRecords; ++i) {
                Object value;
                this.ensureBufferContains(16);
                String key = this.readString(8).toUpperCase(Locale.US).replace(' ', '_');
                DataType type = TYPES.get(key);
                if (type == null) {
                    value = null;
                    this.hasUnrecognized = true;
                } else {
                    switch (type) {
                        default: {
                            throw new AssertionError((Object)type);
                        }
                        case STRING: {
                            value = this.readString(8);
                            break;
                        }
                        case DOUBLE: {
                            value = this.buffer.getDouble();
                            break;
                        }
                        case INTEGER: {
                            int n = this.buffer.getInt();
                            this.buffer.position(this.buffer.position() + 4);
                            if (key.equals(numkey) || key.equals("HEADER")) {
                                numRecords = n;
                            }
                            value = n;
                            break;
                        }
                    }
                }
                Object old = this.header.put(key, value);
                if (old == null || old.equals(value)) continue;
                throw new FactoryException(Errors.format((short)75, key));
            }
            if (this.created == null) {
                this.created = Strings.trimOrNull((String)this.get("CREATED", false));
            }
            if (this.updated == null) {
                this.updated = Strings.trimOrNull((String)this.get("UPDATED", false));
            }
        }

        final DatumShiftGridFile<Angle, Angle> readAllGrids() throws IOException, FactoryException, NoninvertibleTransformException {
            HashMap<String, DatumShiftGridFile<Angle, Angle>> grids = new HashMap<String, DatumShiftGridFile<Angle, Angle>>(Containers.hashMapCapacity(this.numGrids));
            LinkedHashMap<String, List<DatumShiftGridFile<Angle, Angle>>> children = new LinkedHashMap<String, List<DatumShiftGridFile<Angle, Angle>>>();
            while (grids.size() < this.numGrids) {
                this.readGrid(grids, children);
            }
            ArrayList roots = new ArrayList();
            for (Map.Entry entry : children.entrySet()) {
                DatumShiftGridFile parent = (DatumShiftGridFile)grids.get(entry.getKey());
                List subgrids = (List)entry.getValue();
                if (parent != null) {
                    int i = subgrids.size();
                    while (--i >= 0) {
                        if (subgrids.get(i) != parent) continue;
                        subgrids.remove(i);
                        roots.add(parent);
                        break;
                    }
                    if (subgrids.isEmpty()) continue;
                    parent.setSubGrids(subgrids);
                    continue;
                }
                roots.addAll(subgrids);
            }
            switch (roots.size()) {
                case 0: {
                    throw new FactoryException(Errors.format((short)12, this.file));
                }
                case 1: {
                    return (DatumShiftGridFile)roots.get(0);
                }
            }
            return DatumShiftGridGroup.create(this.file, roots);
        }

        private void readGrid(Map<String, DatumShiftGridFile<Angle, Angle>> addTo, Map<String, List<DatumShiftGridFile<Angle, Angle>>> children) throws IOException, FactoryException, NoninvertibleTransformException {
            String name;
            DatumShiftGridFile grid;
            DatumShiftGridFile data;
            double precision;
            Unit<Angle> unit;
            String type;
            if (this.isV2) {
                this.readHeader((Integer)this.get("NUM_SREC", null, null), "NUM_SREC");
            }
            if ((type = (String)this.get("GS_TYPE", "TYPE", null)).equalsIgnoreCase("SECONDS")) {
                unit = Units.ARC_SECOND;
                precision = 1.0E-4;
            } else if (type.equalsIgnoreCase("MINUTES")) {
                unit = Units.ARC_MINUTE;
                precision = 1.6666666666666667E-6;
            } else if (type.equalsIgnoreCase("DEGREES")) {
                unit = Units.DEGREE;
                precision = 2.777777777777778E-8;
            } else {
                throw new FactoryException(Errors.format((short)144, "GS_TYPE", type));
            }
            double ymin = (Double)this.get("S_LAT", null, null);
            double ymax = (Double)this.get("N_LAT", null, null);
            double xmin = (Double)this.get("E_LONG", null, null);
            double xmax = (Double)this.get("W_LONG", null, null);
            double dy = (Double)this.get("LAT_INC", "N_GRID", null);
            double dx = (Double)this.get("LONG_INC", "W_GRID", null);
            Integer declared = (Integer)this.get("GS_COUNT", false);
            int width = Math.toIntExact(Math.round((xmax - xmin) / dx + 1.0));
            int height = Math.toIntExact(Math.round((ymax - ymin) / dy + 1.0));
            int count = Math.multiplyExact(width, height);
            if (declared != null && count != declared) {
                throw new FactoryException(Errors.format((short)144, "GS_COUNT", declared));
            }
            double size = Math.max(dx, dy);
            if (this.isV2) {
                data = new DatumShiftGridFile.Float<Angle, Angle>(2, unit, unit, true, -xmin, ymin, -dx, dy, width, height, PARAMETERS, this.file);
                float[] tx = data.offsets[0];
                float[] ty = data.offsets[1];
                data.accuracy = Double.NaN;
                for (int i = 0; i < count; ++i) {
                    this.ensureBufferContains(16);
                    ty[i] = (float)((double)this.buffer.getFloat() / dy);
                    tx[i] = (float)((double)this.buffer.getFloat() / dx);
                    double accuracy = Math.min((double)this.buffer.getFloat() / dy, (double)this.buffer.getFloat() / dx);
                    if (!(accuracy > 0.0) || accuracy >= data.accuracy) continue;
                    data.accuracy = accuracy;
                }
                grid = DatumShiftGridCompressed.compress(data, null, precision / size);
            } else {
                data = new DatumShiftGridFile.Double<Angle, Angle>(2, unit, unit, true, -xmin, ymin, -dx, dy, width, height, PARAMETERS, this.file);
                grid = data;
                double[] tx = ((DatumShiftGridFile.Double)data).offsets[0];
                double[] ty = ((DatumShiftGridFile.Double)data).offsets[1];
                for (int i = 0; i < count; ++i) {
                    this.ensureBufferContains(16);
                    ty[i] = this.buffer.getDouble() / dy;
                    tx[i] = this.buffer.getDouble() / dx;
                }
            }
            if (!(grid.accuracy > 0.0)) {
                grid.accuracy = Units.DEGREE.getConverterTo(unit).convert(8.999280057595393E-8) / size;
            }
            if (addTo.put(name = (String)this.get("SUB_NAME", this.numGrids > 1), grid) != null) {
                throw new FactoryException(Errors.format((short)25, name));
            }
            children.computeIfAbsent((String)this.get("PARENT", this.numGrids > 1), k -> new ArrayList()).add(grid);
            this.header.keySet().retainAll(Arrays.asList(this.overviewKeys));
        }

        private Object get(String key, boolean mandatory) throws FactoryException {
            Object value = this.header.get(key);
            if (value != null || !mandatory) {
                return value;
            }
            throw new FactoryException(Errors.format((short)120, this.file, key));
        }

        private Object get(String key, String alt2, String kv1) throws FactoryException {
            Object value = this.header.get(key);
            if (value == null && (value = this.header.get(alt2)) == null && (value = this.header.get(kv1)) == null) {
                throw new FactoryException(Errors.format((short)120, this.file, key));
            }
            return value;
        }

        void report(Class<? extends AbstractProvider> caller) {
            try {
                String source = (String)this.get("SYSTEM_F", "DATUM_F", "FROM");
                String target = (String)this.get("SYSTEM_T", "DATUM_T", "TO");
                Loader.log(caller, Resources.forLocale(null).getLogRecord(Level.FINE, (short)93, source, target, this.created != null ? this.created : "?", this.updated != null ? this.updated : "?"));
            }
            catch (FactoryException e2) {
                AbstractProvider.recoverableException(caller, e2);
            }
            if (this.hasUnrecognized) {
                StringBuilder keywords = new StringBuilder();
                for (Map.Entry<String, Object> entry : this.header.entrySet()) {
                    if (entry.getValue() != null) continue;
                    if (keywords.length() != 0) {
                        keywords.append(", ");
                    }
                    keywords.append(entry.getKey());
                }
                Loader.log(caller, Messages.getResources(null).getLogRecord(Level.WARNING, (short)30, this.file, keywords.toString()));
            }
        }

        static {
            HashMap<String, DataType> types = new HashMap<String, DataType>(38);
            types.put("HEADER", DataType.INTEGER);
            types.put("NUM_OREC", DataType.INTEGER);
            types.put("NUM_SREC", DataType.INTEGER);
            types.put("NUM_FILE", DataType.INTEGER);
            types.put("TYPE", DataType.STRING);
            types.put("GS_TYPE", DataType.STRING);
            types.put("VERSION", DataType.STRING);
            types.put("FROM", DataType.STRING);
            types.put("TO", DataType.STRING);
            types.put("SYSTEM_F", DataType.STRING);
            types.put("SYSTEM_T", DataType.STRING);
            types.put("DATUM_F", DataType.STRING);
            types.put("DATUM_T", DataType.STRING);
            types.put("MAJOR_F", DataType.DOUBLE);
            types.put("MINOR_F", DataType.DOUBLE);
            types.put("MAJOR_T", DataType.DOUBLE);
            types.put("MINOR_T", DataType.DOUBLE);
            types.put("SUB_NAME", DataType.STRING);
            types.put("PARENT", DataType.STRING);
            types.put("CREATED", DataType.STRING);
            types.put("UPDATED", DataType.STRING);
            types.put("S_LAT", DataType.DOUBLE);
            types.put("N_LAT", DataType.DOUBLE);
            types.put("E_LONG", DataType.DOUBLE);
            types.put("W_LONG", DataType.DOUBLE);
            types.put("N_GRID", DataType.DOUBLE);
            types.put("W_GRID", DataType.DOUBLE);
            types.put("LAT_INC", DataType.DOUBLE);
            types.put("LONG_INC", DataType.DOUBLE);
            types.put("GS_COUNT", DataType.INTEGER);
            TYPES = types;
        }

        private static enum DataType {
            STRING,
            INTEGER,
            DOUBLE;

        }
    }
}

