/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.commons.lang.Flag;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.html.AsideFloat;
import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlWriter;

public class BasicHtmlDocTemplate
implements HtmlDocTemplate {
    private static boolean exists(String s) {
        return Utils.nn(s) && !"NONE".equals(s);
    }

    private static boolean isEmptyObject(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof Collection) {
            Collection o2 = (Collection)o;
            return o2.isEmpty();
        }
        if (o instanceof Map) {
            Map o2 = (Map)o;
            return o2.isEmpty();
        }
        if (Utils.isArray(o)) {
            return Array.getLength(o) == 0;
        }
        return o.toString().isEmpty();
    }

    @Override
    public void writeTo(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        w.sTag("html").nl(0);
        w.sTag(1, "head").nl(1);
        this.head(session, w, o);
        w.eTag(1, "head").nl(1);
        w.sTag(1, "body").nl(1);
        this.body(session, w, o);
        w.eTag(1, "body").nl(1);
        w.eTag("html").nl(0);
    }

    protected void article(final HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        w.oTag(4, "div").attr("class", "outerdata").append('>').nl(4);
        w.oTag(5, "div").attr("class", "data").attr("id", "data").append('>').nl(5);
        if (o == null) {
            w.append(6, "<null/>").nl(6);
        } else if (BasicHtmlDocTemplate.isEmptyObject(o)) {
            String m = session.getNoResultsMessage();
            if (BasicHtmlDocTemplate.exists(m)) {
                w.append(6, session.resolve(m)).nl(6);
            }
        } else {
            session.indent = 6;
            w.flush();
            if (session.isResolveBodyVars()) {
                w = new HtmlWriter(w){

                    @Override
                    public HtmlWriter text(Object value, boolean preserveWhitespace) {
                        return super.text(session.resolve(Utils.s(value)), preserveWhitespace);
                    }
                };
            }
            session.parentSerialize(w, o);
        }
        w.ie(5).eTag("div").nl(5);
        w.ie(4).eTag("div").nl(4);
    }

    protected void aside(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        String[] aside = session.getAside();
        for (int i = 0; i < aside.length; ++i) {
            w.sIf(i > 0).appendln(4, session.resolve(aside[i]));
        }
    }

    protected void body(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        AsideFloat asideFloat = session.getAsideFloat();
        boolean hasAside = this.hasAside(session);
        if (this.hasHeader(session)) {
            w.sTag(2, "header").nl(2);
            this.header(session, w, o);
            w.ie(2).eTag("header").nl(2);
        }
        if (this.hasNav(session)) {
            w.sTag(2, "nav").nl(2);
            this.nav(session, w, o);
            w.ie(2).eTag("nav").nl(2);
        }
        if (hasAside && asideFloat.is(AsideFloat.TOP)) {
            w.sTag(2, "section").nl(2);
            w.sTag(3, "aside").nl(3);
            this.aside(session, w, o);
            w.ie(3).eTag("aside").nl(3);
            w.ie(2).eTag("section").nl(2);
        }
        w.sTag(2, "section").nl(2);
        if (hasAside && asideFloat.is(AsideFloat.LEFT)) {
            w.sTag(3, "aside").nl(3);
            this.aside(session, w, o);
            w.ie(3).eTag("aside").nl(3);
        }
        w.sTag(3, "article").nl(3);
        this.article(session, w, o);
        w.ie(3).eTag("article").nl(3);
        if (hasAside && asideFloat.isAny(AsideFloat.RIGHT, AsideFloat.DEFAULT)) {
            w.sTag(3, "aside").nl(3);
            this.aside(session, w, o);
            w.ie(3).eTag("aside").nl(3);
        }
        w.ie(2).eTag("section").nl(2);
        if (hasAside && asideFloat.is(AsideFloat.BOTTOM)) {
            w.sTag(2, "section").nl(2);
            w.sTag(3, "aside").nl(3);
            this.aside(session, w, o);
            w.ie(3).eTag("aside").nl(3);
            w.ie(2).eTag("section").nl(2);
        }
        if (this.hasFooter(session)) {
            w.sTag(2, "footer").nl(2);
            this.footer(session, w, o);
            w.ie(2).eTag("footer").nl(2);
        }
    }

    protected void footer(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        String[] footer = session.getFooter();
        for (int i = 0; i < footer.length; ++i) {
            w.sIf(i > 0).appendln(3, session.resolve(footer[i]));
        }
    }

    protected boolean hasAside(HtmlDocSerializerSession session) {
        return session.getAside().length > 0;
    }

    protected boolean hasFooter(HtmlDocSerializerSession session) {
        return session.getFooter().length > 0;
    }

    protected boolean hasHeader(HtmlDocSerializerSession session) {
        return session.getHeader().length > 0;
    }

    protected boolean hasNav(HtmlDocSerializerSession session) {
        return session.getNav().length > 0 || session.getNavLinks().length > 0;
    }

    protected boolean hasScript(HtmlDocSerializerSession session) {
        return true;
    }

    protected boolean hasStyle(HtmlDocSerializerSession session) {
        return true;
    }

    protected void head(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        String[] head = session.getHead();
        for (int i = 0; i < head.length; ++i) {
            w.sIf(i > 0).appendln(2, session.resolve(head[i]));
        }
        if (this.hasStyle(session)) {
            w.sTag(2, "style").nl(2);
            this.style(session, w, o);
            w.ie(2).eTag("style").nl(2);
        }
        if (this.hasScript(session)) {
            w.sTag(2, "script").nl(2);
            this.script(session, w, o);
            w.ie(2).eTag("script").nl(2);
        }
    }

    protected void header(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        String[] header = session.getHeader();
        for (int i = 0; i < header.length; ++i) {
            w.sIf(i > 0).appendln(3, session.resolve(header[i]));
        }
    }

    protected void nav(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        String[] nav;
        String[] links = session.getNavLinks();
        if (links.length > 0 && !CollectionUtils.contains("NONE", links)) {
            w.sTag(3, "ol").nl(3);
            for (String l : links) {
                w.sTag(4, "li");
                l = session.resolve(l);
                if (l.matches("(?s)\\S+\\:.*")) {
                    int i = l.indexOf(58);
                    String key = l.substring(0, i);
                    String val = l.substring(i + 1).trim();
                    if (val.startsWith("<")) {
                        w.nl(4).appendln(5, val);
                    } else {
                        w.oTag("a").attr("href", (Object)session.resolveUri(val), true).cTag().text(key, true).eTag("a");
                    }
                    w.eTag("li").nl(4);
                    continue;
                }
                w.nl(4).appendln(5, l);
                w.eTag(4, "li").nl(4);
            }
            w.eTag(3, "ol").nl(3);
        }
        if ((nav = session.getNav()).length > 0) {
            for (int i = 0; i < nav.length; ++i) {
                w.sIf(i > 0).appendln(3, session.resolve(nav[i]));
            }
        }
    }

    protected void script(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        Flag addSpace = Flag.create();
        for (String s : session.getScript()) {
            w.sIf(addSpace.getAndSet()).append(3, session.resolve(s)).append('\n');
        }
        session.forEachWidget(x -> w.sIf(addSpace.getAndSet()).append(3, session.resolve(x.getScript(session.getVarResolver()))).w('\n'));
    }

    protected void style(HtmlDocSerializerSession session, HtmlWriter w, Object o) throws Exception {
        Flag addSpace = Flag.create();
        for (String s : session.getStylesheet()) {
            w.sIf(addSpace.getAndSet()).append(3, "@import ").q().append(session.resolveUri(session.resolve(s))).q().appendln(";");
        }
        if (session.isNowrap()) {
            w.appendln(3, "div.data * {white-space:nowrap;} ");
        }
        for (String s : session.getStyle()) {
            w.sIf(addSpace.getAndSet()).appendln(3, session.resolve(s));
        }
        session.forEachWidget(x -> w.sIf(addSpace.getAndSet()).appendln(3, session.resolve(x.getStyle(session.getVarResolver()))));
    }
}

