/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

public class MockLogger
extends Logger {
    private static final String FORMAT_PROPERTY = "java.util.logging.SimpleFormatter.format";
    private final List<LogRecord> logRecords = CollectionUtils.list(new LogRecord[0]);
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private volatile Formatter formatter;
    private volatile String format = "%4$s: %5$s%6$s%n";

    public static MockLogger create() {
        return new MockLogger();
    }

    public MockLogger() {
        super("Mock", null);
    }

    public synchronized FluentStringAssertion<MockLogger> assertContents() {
        return new FluentStringAssertion<MockLogger>(this.baos.toString(), this);
    }

    public synchronized MockLogger assertLastLevel(Level level) {
        this.assertLogged();
        if (this.last().getLevel() != level) {
            throw new AssertionError((Object)("Message logged at [" + String.valueOf(this.last().getLevel()) + "] instead of [" + String.valueOf(level) + "]"));
        }
        return this;
    }

    public synchronized FluentStringAssertion<MockLogger> assertLastMessage() {
        this.assertLogged();
        return new FluentStringAssertion<MockLogger>(this.last().getMessage(), this);
    }

    public synchronized MockLogger assertLogged() {
        if (this.logRecords.isEmpty()) {
            throw new AssertionError((Object)"Message not logged");
        }
        return this;
    }

    public synchronized FluentIntegerAssertion<MockLogger> assertRecordCount() {
        return new FluentIntegerAssertion<MockLogger>(this.logRecords.size(), this);
    }

    public synchronized MockLogger format(String format) {
        this.format = format;
        return this;
    }

    public synchronized MockLogger formatter(Formatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public synchronized MockLogger level(Level level) {
        super.setLevel(level);
        return this;
    }

    @Override
    public synchronized void log(LogRecord record) {
        this.logRecords.add(record);
        try {
            this.baos.write(this.getFormatter().format(record).getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    public synchronized MockLogger reset() {
        this.logRecords.clear();
        this.baos.reset();
        return this;
    }

    public String toString() {
        return this.baos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Formatter getFormatter() {
        if (this.formatter == null) {
            MockLogger mockLogger = this;
            synchronized (mockLogger) {
                String oldFormat = System.getProperty(FORMAT_PROPERTY);
                System.setProperty(FORMAT_PROPERTY, this.format);
                this.formatter = new SimpleFormatter();
                if (oldFormat == null) {
                    System.clearProperty(FORMAT_PROPERTY);
                } else {
                    System.setProperty(FORMAT_PROPERTY, oldFormat);
                }
            }
        }
        return this.formatter;
    }

    private LogRecord last() {
        if (this.logRecords.isEmpty()) {
            throw new AssertionError((Object)"Message not logged");
        }
        return this.logRecords.get(this.logRecords.size() - 1);
    }
}

