/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.juneau.commons.utils.AssertionUtils;

public class FileWriterBuilder {
    private File file;
    private Charset cs = Charset.defaultCharset();
    private boolean append;
    private boolean buffered;

    public static FileWriterBuilder create() {
        return new FileWriterBuilder();
    }

    public static FileWriterBuilder create(File file) {
        return new FileWriterBuilder().file(file);
    }

    public static FileWriterBuilder create(String path) {
        return new FileWriterBuilder().file(path);
    }

    public FileWriterBuilder append() {
        this.append = true;
        return this;
    }

    public FileWriterBuilder buffered() {
        this.buffered = true;
        return this;
    }

    public Writer build() throws FileNotFoundException {
        AssertionUtils.assertArgNotNull("file", this.file);
        OutputStream os = new FileOutputStream(this.file, this.append);
        if (this.buffered) {
            os = new BufferedOutputStream(os);
        }
        return new OutputStreamWriter(os, this.cs != null ? this.cs : Charset.defaultCharset());
    }

    public FileWriterBuilder charset(Charset cs) {
        this.cs = cs;
        return this;
    }

    public FileWriterBuilder charset(String cs) {
        this.cs = Charset.forName(AssertionUtils.assertArgNotNull("cs", cs));
        return this;
    }

    public FileWriterBuilder file(File value) {
        this.file = value;
        return this;
    }

    public FileWriterBuilder file(String path) {
        this.file = new File(path);
        return this;
    }
}

