/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;

public class LogConfig {
    String logFile;
    String logDir;
    Boolean append;
    Integer limit;
    Integer count;
    Level fileLevel;
    Level consoleLevel;
    Map<String, Level> levels = new LinkedHashMap<String, Level>();
    Formatter formatter;

    public static LogConfig create() {
        return new LogConfig();
    }

    protected LogConfig(LogConfig copyFrom) {
        this.logFile = copyFrom.logFile;
        this.logDir = copyFrom.logDir;
        this.append = copyFrom.append;
        this.limit = copyFrom.limit;
        this.count = copyFrom.count;
        this.fileLevel = copyFrom.fileLevel;
        this.consoleLevel = copyFrom.consoleLevel;
        this.levels = new LinkedHashMap<String, Level>(copyFrom.levels);
        this.formatter = copyFrom.formatter;
    }

    LogConfig() {
    }

    public LogConfig append() {
        this.append = true;
        return this;
    }

    public LogConfig consoleLevel(Level consoleLevel) {
        this.consoleLevel = consoleLevel;
        return this;
    }

    public LogConfig copy() {
        return new LogConfig(this);
    }

    public LogConfig count(int count) {
        this.count = count;
        return this;
    }

    public LogConfig fileLevel(Level fileLevel) {
        this.fileLevel = fileLevel;
        return this;
    }

    public LogConfig formatter(Formatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public LogConfig level(String logger, Level level) {
        this.levels.put(logger, level);
        return this;
    }

    public LogConfig levels(Map<String, Level> levels) {
        this.levels.putAll(levels);
        return this;
    }

    public LogConfig limit(int limit) {
        this.limit = limit;
        return this;
    }

    public LogConfig logDir(String logDir) {
        this.logDir = logDir;
        return this;
    }

    public LogConfig logFile(String logFile) {
        this.logFile = logFile;
        return this;
    }
}

