/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.gen;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.aries.proxy.FinalModifierException;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.gen.ProxyClassBytecodeGenerationException;
import org.apache.aries.proxy.impl.gen.ProxyClassDefinitionException;
import org.apache.aries.proxy.impl.gen.ProxyClassInstantiationException;
import org.apache.aries.proxy.impl.gen.ProxySubclassAdapter;
import org.apache.aries.proxy.impl.gen.UnableToLoadProxyException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.ReflectionFactory;

public class ProxySubclassGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxySubclassGenerator.class);
    private static final Map<ClassLoader, ConcurrentMap<String, String>> proxyClassesByClassLoader;
    private static final ClassLoader defaultClassLoader;
    private static final char FINAL_MODIFIER = '!';
    private static final char UNABLE_TO_PROXY = '#';

    public static Class<?> getProxySubclass(Class<?> aClass) throws UnableToProxyException {
        return ProxySubclassGenerator.getProxySubclass(aClass, aClass.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getProxySubclass(Class<?> aClass, ClassLoader loader) throws UnableToProxyException {
        ConcurrentMap<String, String> proxyMap;
        LOGGER.debug("Method entry: {}, args {}", (Object)"getProxySubclass", (Object)new Object[]{aClass});
        if (loader == null) {
            loader = defaultClassLoader;
        }
        ClassLoader classLoader = loader;
        synchronized (classLoader) {
            proxyMap = proxyClassesByClassLoader.get(loader);
            if (proxyMap == null) {
                proxyMap = new ConcurrentHashMap<String, String>();
                proxyClassesByClassLoader.put(loader, proxyMap);
            }
        }
        Class<?> classToReturn = null;
        Class<?> clazz = aClass;
        synchronized (clazz) {
            String key = aClass.getName();
            String className = (String)proxyMap.get(key);
            if (className != null) {
                LOGGER.debug("Found proxy subclass with key {} and name {}.", (Object)key, (Object)className);
                if (className.charAt(0) == '!') {
                    String[] exceptionParts = className.substring(1).split(":");
                    if (exceptionParts.length == 1) {
                        throw new FinalModifierException(aClass);
                    }
                    throw new FinalModifierException(aClass, exceptionParts[1]);
                }
                if (className.charAt(0) == '#') {
                    throw new UnableToProxyException(aClass);
                }
                try {
                    classToReturn = loader.loadClass(className);
                }
                catch (ClassNotFoundException cnfe) {
                    LOGGER.debug("Caught exception", (Throwable)cnfe);
                    throw new UnableToLoadProxyException(className, cnfe);
                }
            }
            LOGGER.debug("Need to generate subclass. Using key {}.", (Object)key);
            try {
                ProxySubclassGenerator.scanForFinalModifiers(aClass);
                classToReturn = ProxySubclassGenerator.generateAndLoadSubclass(aClass, loader);
                if (classToReturn == null) {
                    proxyMap.put(key, '#' + aClass.getName());
                    throw new UnableToProxyException(aClass);
                }
                proxyMap.put(key, classToReturn.getName());
            }
            catch (FinalModifierException e) {
                if (e.isFinalClass()) {
                    proxyMap.put(key, '!' + e.getClassName());
                    throw e;
                }
                proxyMap.put(key, '!' + e.getClassName() + ':' + e.getFinalMethods());
                throw e;
            }
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getProxySubclass", classToReturn);
        return classToReturn;
    }

    public static Object newProxySubclassInstance(Class<?> classToProxy, InvocationHandler ih) throws UnableToProxyException {
        return ProxySubclassGenerator.newProxySubclassInstance(classToProxy, classToProxy.getClassLoader(), ih);
    }

    public static Object newProxySubclassInstance(Class<?> classToProxy, ClassLoader loader, InvocationHandler ih) throws UnableToProxyException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"newProxySubclassInstance", (Object)new Object[]{classToProxy, loader, ih});
        Object proxySubclassInstance = null;
        try {
            Class<?> generatedProxySubclass = ProxySubclassGenerator.getProxySubclass(classToProxy, loader);
            LOGGER.debug("Getting the proxy subclass constructor");
            ReflectionFactory factory = ReflectionFactory.getReflectionFactory();
            Constructor constr = Object.class.getConstructor(new Class[0]);
            Constructor<?> subclassConstructor = factory.newConstructorForSerialization(generatedProxySubclass, constr);
            proxySubclassInstance = subclassConstructor.newInstance(new Object[0]);
            Method setIHMethod = proxySubclassInstance.getClass().getMethod("setInvocationHandler", InvocationHandler.class);
            setIHMethod.invoke(proxySubclassInstance, ih);
            LOGGER.debug("Invoked proxy subclass constructor");
        }
        catch (NoSuchMethodException nsme) {
            LOGGER.debug("Caught exception", (Throwable)nsme);
            throw new ProxyClassInstantiationException(classToProxy, (Throwable)nsme);
        }
        catch (InvocationTargetException ite) {
            LOGGER.debug("Caught exception", (Throwable)ite);
            throw new ProxyClassInstantiationException(classToProxy, (Throwable)ite);
        }
        catch (InstantiationException ie) {
            LOGGER.debug("Caught exception", (Throwable)ie);
            throw new ProxyClassInstantiationException(classToProxy, (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            LOGGER.debug("Caught exception", (Throwable)iae);
            throw new ProxyClassInstantiationException(classToProxy, (Throwable)iae);
        }
        catch (VerifyError ve) {
            LOGGER.info(String.format("The no-argument constructor of class %s is private and therefore it may not be possible to generate a valid proxy.", classToProxy));
            LOGGER.debug("Caught exception", (Throwable)ve);
            throw new ProxyClassInstantiationException(classToProxy, (Throwable)ve);
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"newProxySubclassInstance", proxySubclassInstance);
        return proxySubclassInstance;
    }

    private static Class<?> generateAndLoadSubclass(Class<?> aClass, ClassLoader loader) throws UnableToProxyException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"generateAndLoadSubclass", (Object)new Object[]{aClass, loader});
        String newClassName = "$" + aClass.getSimpleName() + aClass.hashCode();
        String packageName = aClass.getPackage().getName();
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            packageName = "org.apache.aries.blueprint.proxy." + packageName;
        }
        String fullNewClassName = (packageName + "." + newClassName).replaceAll("\\.", "/");
        LOGGER.debug("New class name: {}", (Object)newClassName);
        LOGGER.debug("Full new class name: {}", (Object)fullNewClassName);
        Class<?> clazz = null;
        try {
            ClassReader cReader = new ClassReader(loader.getResourceAsStream(aClass.getName().replaceAll("\\.", "/") + ".class"));
            ClassWriter cWriter = new ClassWriter(1);
            ProxySubclassAdapter dynamicSubclassAdapter = new ProxySubclassAdapter((ClassVisitor)cWriter, fullNewClassName, loader);
            byte[] byteClassData = ProxySubclassGenerator.processClass(cReader, cWriter, dynamicSubclassAdapter);
            clazz = ProxySubclassGenerator.loadClassFromBytes(loader, ProxySubclassGenerator.getBinaryName(fullNewClassName), byteClassData, aClass.getName());
        }
        catch (IOException ioe) {
            LOGGER.debug("Caught exception", (Throwable)ioe);
            throw new ProxyClassBytecodeGenerationException(aClass.getName(), (Throwable)ioe);
        }
        catch (TypeNotPresentException tnpe) {
            LOGGER.debug("Caught exception", (Throwable)tnpe);
            throw new ProxyClassBytecodeGenerationException(tnpe.typeName(), tnpe.getCause());
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"generateAndLoadSubclass", clazz);
        return clazz;
    }

    private static byte[] processClass(ClassReader cReader, ClassWriter cWriter, ClassVisitor cVisitor) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"processClass", (Object)new Object[]{cReader, cWriter, cVisitor});
        cReader.accept(cVisitor, 2);
        byte[] byteClassData = cWriter.toByteArray();
        LOGGER.debug("Method exit: {}, returning {}", (Object)"processClass", (Object)byteClassData);
        return byteClassData;
    }

    private static String getBinaryName(String name) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getBinaryName", (Object)name);
        String binaryName = name.replaceAll("/", "\\.");
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getBinaryName", (Object)binaryName);
        return binaryName;
    }

    private static Class<?> loadClassFromBytes(ClassLoader loader, String name, byte[] classData, String classToProxyName) throws UnableToProxyException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"loadClassFromBytes", (Object)new Object[]{loader, name, classData});
        Class clazz = null;
        try {
            Method defineClassMethod = Class.forName("java.lang.ClassLoader").getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            defineClassMethod.setAccessible(true);
            clazz = (Class)defineClassMethod.invoke((Object)loader, name, classData, 0, classData.length, ProxySubclassGenerator.class.getProtectionDomain());
            defineClassMethod.setAccessible(false);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.debug("Caught exception", (Throwable)cnfe);
            throw new ProxyClassDefinitionException(classToProxyName, cnfe);
        }
        catch (NoSuchMethodException nsme) {
            LOGGER.debug("Caught exception", (Throwable)nsme);
            throw new ProxyClassDefinitionException(classToProxyName, nsme);
        }
        catch (InvocationTargetException ite) {
            LOGGER.debug("Caught exception", (Throwable)ite);
            throw new ProxyClassDefinitionException(classToProxyName, ite);
        }
        catch (IllegalAccessException iae) {
            LOGGER.debug("Caught exception", (Throwable)iae);
            throw new ProxyClassDefinitionException(classToProxyName, iae);
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"loadClassFromBytes", (Object)clazz);
        return clazz;
    }

    public static boolean isProxySubclass(Class<?> aClass) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"isProxySubclass", (Object)new Object[]{aClass});
        Map proxies = proxyClassesByClassLoader.get(aClass.getClassLoader());
        boolean isProxySubclass = proxies != null && proxies.containsValue(aClass.getName());
        LOGGER.debug("Method exit: {}, returning {}", (Object)"isProxySubclass", (Object)isProxySubclass);
        return isProxySubclass;
    }

    private static void scanForFinalModifiers(Class<?> clazz) throws FinalModifierException {
        LOGGER.debug("Method entry: {}, args {}", (Object)"scanForFinalModifiers", (Object)new Object[]{clazz});
        if (Modifier.isFinal(clazz.getModifiers())) {
            throw new FinalModifierException(clazz);
        }
        ArrayList<String> finalMethods = new ArrayList<String>();
        while (!clazz.getName().startsWith("java.") && !clazz.getName().startsWith("javax.")) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!Modifier.isFinal(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) continue;
                finalMethods.add(m.toGenericString());
            }
            clazz = clazz.getSuperclass();
        }
        if (!finalMethods.isEmpty()) {
            String methodList = ((Object)finalMethods).toString();
            methodList = methodList.substring(1, methodList.length() - 1);
            throw new FinalModifierException(clazz, methodList);
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"scanForFinalModifiers");
    }

    public static InvocationHandler getInvocationHandler(Object o) {
        LOGGER.debug("Method entry: {}, args {}", (Object)"getInvoationHandler", (Object)new Object[]{o});
        InvocationHandler ih = null;
        if (ProxySubclassGenerator.isProxySubclass(o.getClass())) {
            try {
                ih = (InvocationHandler)o.getClass().getDeclaredMethod("getInvocationHandler", new Class[0]).invoke(o, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Caught exception", (Throwable)e);
            }
            catch (SecurityException e) {
                LOGGER.debug("Caught exception", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.debug("Caught exception", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.debug("Caught exception", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.debug("Caught exception", (Throwable)e);
            }
        }
        LOGGER.debug("Method exit: {}, returning {}", (Object)"getInvoationHandler", ih);
        return ih;
    }

    static {
        defaultClassLoader = new ClassLoader(){};
        proxyClassesByClassLoader = Collections.synchronizedMap(new WeakHashMap());
    }
}

