/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.karaf.log.core.Level;
import org.apache.karaf.log.core.LogService;
import org.apache.karaf.log.core.internal.CircularBuffer;
import org.apache.karaf.log.core.internal.KarafLogEvent;
import org.apache.karaf.log.core.internal.LogServiceInternal;
import org.apache.karaf.log.core.internal.LogServiceLog4j1Impl;
import org.apache.karaf.log.core.internal.LogServiceLog4j2Impl;
import org.apache.karaf.log.core.internal.LogServiceLog4j2XmlImpl;
import org.apache.karaf.log.core.internal.LogServiceLogbackXmlImpl;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class LogServiceImpl
implements LogService,
PaxAppender {
    static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    private final ConfigurationAdmin configAdmin;
    private volatile CircularBuffer buffer;
    private List<PaxAppender> appenders;

    public LogServiceImpl(ConfigurationAdmin configAdmin, int size) {
        this.configAdmin = configAdmin;
        this.appenders = new CopyOnWriteArrayList<PaxAppender>();
        this.buffer = new CircularBuffer(size);
    }

    private LogServiceInternal getDelegate(Dictionary<String, Object> config) {
        if (config.get("log4j.rootLogger") != null) {
            return new LogServiceLog4j1Impl(config);
        }
        if (config.get("log4j2.rootLogger.level") != null) {
            return new LogServiceLog4j2Impl(config);
        }
        if (config.get("org.ops4j.pax.logging.log4j2.config.file") != null) {
            String file = config.get("org.ops4j.pax.logging.log4j2.config.file").toString();
            if (file.endsWith(".xml")) {
                return new LogServiceLog4j2XmlImpl(file);
            }
            throw new IllegalStateException("Unsupported Log4j2 configuration type: " + file);
        }
        if (config.get("org.ops4j.pax.logging.logback.config.file") != null) {
            String file = config.get("org.ops4j.pax.logging.logback.config.file").toString();
            if (file.endsWith(".xml")) {
                return new LogServiceLogbackXmlImpl(file);
            }
            throw new IllegalStateException("Unsupported Logback configuration type: " + file);
        }
        throw new IllegalStateException("Unrecognized configuration");
    }

    @Override
    public String getLevel() {
        return this.getLevel("ROOT").get("ROOT");
    }

    @Override
    public Map<String, String> getLevel(String logger) {
        Configuration cfg;
        try {
            cfg = this.configAdmin.getConfiguration(CONFIGURATION_PID, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving Log information from config admin", e);
        }
        if (logger == null) {
            logger = "ROOT";
        }
        return this.getDelegate(cfg.getProcessedProperties(null)).getLevel(logger);
    }

    @Override
    public void setLevel(String level) {
        this.setLevel("ROOT", level);
    }

    @Override
    public void setLevel(String logger, String level) {
        level = level.toUpperCase();
        Level lvl = Level.valueOf(level);
        if (logger == null) {
            logger = "ROOT";
        }
        if (lvl == Level.DEFAULT && "ROOT".equals(logger)) {
            throw new IllegalStateException("Can not unset the ROOT logger");
        }
        Configuration cfg = this.getConfiguration();
        Dictionary props = cfg.getProcessedProperties(null);
        this.getDelegate(props).setLevel(logger, level);
        try {
            cfg.update(props);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing log config to config admin", e);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private boolean checkIfFromRequestedLog(PaxLoggingEvent event, String logger) {
        return event.getLoggerName().lastIndexOf(logger) >= 0;
    }

    private Configuration getConfiguration() {
        try {
            return this.configAdmin.getConfiguration(CONFIGURATION_PID, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Error retrieving Log information from config admin", e);
        }
    }

    @Override
    public Iterable<PaxLoggingEvent> getEvents() {
        return this.buffer.getElements(this.buffer.maxSize());
    }

    @Override
    public Iterable<PaxLoggingEvent> getEvents(int maxNum) {
        return this.buffer.getElements(maxNum);
    }

    @Override
    public void clearEvents() {
        int size = this.buffer.maxSize();
        this.buffer = new CircularBuffer(size);
    }

    @Override
    public PaxLoggingEvent getLastException(String logger) {
        PaxLoggingEvent throwableEvent = null;
        Iterable<PaxLoggingEvent> le = this.getEvents();
        for (PaxLoggingEvent event : le) {
            if (event.getThrowableStrRep() != null && logger != null && this.checkIfFromRequestedLog(event, logger)) {
                throwableEvent = event;
                continue;
            }
            if (event.getThrowableStrRep() == null || logger != null) continue;
            throwableEvent = event;
        }
        return throwableEvent;
    }

    @Override
    public void addAppender(PaxAppender appender) {
        this.appenders.add(appender);
    }

    @Override
    public void removeAppender(PaxAppender appender) {
        this.appenders.remove(appender);
    }

    public void doAppend(PaxLoggingEvent event) {
        event.getProperties();
        KarafLogEvent eventCopy = new KarafLogEvent(event);
        this.buffer.add(eventCopy);
        for (PaxAppender appender : this.appenders) {
            try {
                appender.doAppend((PaxLoggingEvent)eventCopy);
            }
            catch (Throwable throwable) {}
        }
    }
}

