/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.tests.search.AssertingBulkScorer;
import org.apache.lucene.tests.search.AssertingMatches;
import org.apache.lucene.tests.search.AssertingScorer;
import org.apache.lucene.tests.util.LuceneTestCase;

class AssertingWeight
extends FilterWeight {
    final Random random;
    final ScoreMode scoreMode;

    AssertingWeight(Random random, Weight in, ScoreMode scoreMode) {
        super(in);
        this.random = random;
        this.scoreMode = scoreMode;
    }

    public int count(LeafReaderContext context) throws IOException {
        int count = this.in.count(context);
        if (count < -1 || count > context.reader().numDocs()) {
            throw new AssertionError((Object)("count=" + count + ", numDocs=" + context.reader().numDocs()));
        }
        return count;
    }

    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        Matches matches = this.in.matches(context, doc);
        if (matches == null) {
            return null;
        }
        return new AssertingMatches(matches);
    }

    public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
        final ScorerSupplier inScorerSupplier = this.in.scorerSupplier(context);
        if (inScorerSupplier == null) {
            return null;
        }
        return new ScorerSupplier(){
            private boolean getCalled = false;
            private boolean topLevelScoringClause = false;

            public Scorer get(long leadCost) throws IOException {
                assert (!this.getCalled);
                this.getCalled = true;
                assert (leadCost >= 0L) : leadCost;
                return AssertingScorer.wrap(new Random(AssertingWeight.this.random.nextLong()), inScorerSupplier.get(leadCost), AssertingWeight.this.scoreMode, this.topLevelScoringClause);
            }

            public BulkScorer bulkScorer() throws IOException {
                BulkScorer inScorer;
                assert (!this.getCalled);
                if (LuceneTestCase.usually(AssertingWeight.this.random)) {
                    this.getCalled = true;
                    inScorer = inScorerSupplier.bulkScorer();
                } else {
                    inScorer = super.bulkScorer();
                    assert (this.getCalled);
                }
                return AssertingBulkScorer.wrap(new Random(AssertingWeight.this.random.nextLong()), inScorer, context.reader().maxDoc());
            }

            public long cost() {
                long cost = inScorerSupplier.cost();
                assert (cost >= 0L);
                return cost;
            }

            public void setTopLevelScoringClause() throws IOException {
                assert (!this.getCalled);
                this.topLevelScoringClause = true;
                inScorerSupplier.setTopLevelScoringClause();
            }
        };
    }
}

