/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.monitor.CustomQueryHandler;
import org.apache.lucene.monitor.QueryTree;
import org.apache.lucene.monitor.TermFilteredPresearcher;
import org.apache.lucene.monitor.TermWeightor;
import org.apache.lucene.monitor.TermsEnumTokenStream;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

public class MultipassTermFilteredPresearcher
extends TermFilteredPresearcher {
    private final int passes;
    private final float minWeight;

    public MultipassTermFilteredPresearcher(int passes, float minWeight, TermWeightor weightor, List<CustomQueryHandler> queryHandlers, Set<String> filterFields) {
        super(weightor, queryHandlers, filterFields);
        this.passes = passes;
        this.minWeight = minWeight;
    }

    public MultipassTermFilteredPresearcher(int passes) {
        this(passes, 0.0f, DEFAULT_WEIGHTOR, Collections.emptyList(), Collections.emptySet());
    }

    @Override
    protected TermFilteredPresearcher.DocumentQueryBuilder getQueryBuilder() {
        return new MultipassDocumentQueryBuilder();
    }

    private static String field(String field, int pass) {
        return field + "_" + pass;
    }

    @Override
    public Document buildQueryDocument(QueryTree querytree) {
        Document doc = new Document();
        for (int i = 0; i < this.passes; ++i) {
            Map<String, BytesRefHash> fieldTerms = this.collectTerms(querytree);
            for (Map.Entry<String, BytesRefHash> entry : fieldTerms.entrySet()) {
                doc.add((IndexableField)new Field(MultipassTermFilteredPresearcher.field(entry.getKey(), i), (TokenStream)new TermsEnumTokenStream(new TermFilteredPresearcher.BytesRefHashIterator(this, entry.getValue())), (IndexableFieldType)QUERYFIELDTYPE));
                doc.add((IndexableField)new Field(entry.getKey(), (TokenStream)new TermsEnumTokenStream(new TermFilteredPresearcher.BytesRefHashIterator(this, entry.getValue())), (IndexableFieldType)QUERYFIELDTYPE));
            }
            querytree.advancePhase(this.minWeight);
        }
        return doc;
    }

    private static BytesRef[] convertHash(BytesRefHash hash) {
        BytesRef[] terms = new BytesRef[hash.size()];
        for (int i = 0; i < terms.length; ++i) {
            BytesRef t = new BytesRef();
            terms[i] = hash.get(i, t);
        }
        return terms;
    }

    private class MultipassDocumentQueryBuilder
    implements TermFilteredPresearcher.DocumentQueryBuilder {
        BooleanQuery.Builder[] queries;
        Map<String, BytesRefHash> terms;

        MultipassDocumentQueryBuilder() {
            this.queries = new BooleanQuery.Builder[MultipassTermFilteredPresearcher.this.passes];
            this.terms = new HashMap<String, BytesRefHash>();
            for (int i = 0; i < this.queries.length; ++i) {
                this.queries[i] = new BooleanQuery.Builder();
            }
        }

        @Override
        public void addTerm(String field, BytesRef term) {
            BytesRefHash t = this.terms.computeIfAbsent(field, f -> new BytesRefHash());
            t.add(term);
        }

        @Override
        public Query build() {
            HashMap<String, BytesRef[]> collectedTerms = new HashMap<String, BytesRef[]>();
            for (Map.Entry<String, BytesRefHash> entry : this.terms.entrySet()) {
                collectedTerms.put(entry.getKey(), MultipassTermFilteredPresearcher.convertHash(entry.getValue()));
            }
            BooleanQuery.Builder parent = new BooleanQuery.Builder();
            for (int i = 0; i < MultipassTermFilteredPresearcher.this.passes; ++i) {
                BooleanQuery.Builder child = new BooleanQuery.Builder();
                for (String field : this.terms.keySet()) {
                    child.add((Query)new TermInSetQuery(MultipassTermFilteredPresearcher.field(field, i), Arrays.asList((BytesRef[])collectedTerms.get(field))), BooleanClause.Occur.SHOULD);
                }
                parent.add((Query)child.build(), BooleanClause.Occur.MUST);
            }
            return parent.build();
        }
    }
}

