/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;

public final class HelpDialogFactory
implements DialogOpener.DialogFactory {
    private static HelpDialogFactory instance;
    private final Preferences prefs = PreferencesFactory.getInstance();
    private JDialog dialog;
    private String desc;
    private JComponent helpContent;

    public static synchronized HelpDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new HelpDialogFactory();
        }
        return instance;
    }

    private HelpDialogFactory() throws IOException {
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setContent(JComponent helpContent) {
        this.helpContent = helpContent;
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel header = new JPanel(new FlowLayout(3));
        header.setOpaque(false);
        header.add(new JLabel(this.desc));
        panel.add((Component)header, "First");
        JPanel center = new JPanel(new GridLayout(1, 1));
        center.setOpaque(false);
        center.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        center.add(this.helpContent);
        panel.add((Component)center, "Center");
        JPanel footer = new JPanel(new FlowLayout(4));
        footer.setOpaque(false);
        JButton closeBtn = new JButton(MessageUtils.getLocalizedMessage("button.close"));
        closeBtn.addActionListener(e -> this.dialog.dispose());
        footer.add(closeBtn);
        panel.add((Component)footer, "Last");
        return panel;
    }
}

