/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.documents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.models.documents.DocValues;
import org.apache.lucene.luke.util.BytesRefUtils;
import org.apache.lucene.util.NumericUtils;

public final class DocValuesDialogFactory
implements DialogOpener.DialogFactory {
    private static DocValuesDialogFactory instance;
    private final Preferences prefs;
    private final JComboBox<String> decodersCombo = new JComboBox();
    private final JList<String> valueList = new JList();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private JDialog dialog;
    private String field;
    private DocValues docValues;

    public static synchronized DocValuesDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new DocValuesDialogFactory();
        }
        return instance;
    }

    private DocValuesDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
    }

    public void setValue(String field, DocValues docValues) {
        this.field = field;
        this.docValues = docValues;
        DefaultListModel values = new DefaultListModel();
        if (docValues.getValues().size() > 0) {
            this.decodersCombo.setEnabled(false);
            docValues.getValues().stream().map(BytesRefUtils::decode).forEach(values::addElement);
        } else if (docValues.getNumericValues().size() > 0) {
            this.decodersCombo.setEnabled(true);
            docValues.getNumericValues().stream().map(String::valueOf).forEach(values::addElement);
        }
        this.valueList.setModel(values);
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        if (Objects.isNull(this.field) || Objects.isNull(this.docValues)) {
            throw new IllegalStateException("field name and/or doc values is not set.");
        }
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        panel.add((Component)this.headerPanel(), "First");
        JScrollPane scrollPane = new JScrollPane(this.valueList());
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        panel.add((Component)scrollPane, "Center");
        panel.add((Component)this.footerPanel(), "Last");
        return panel;
    }

    private JPanel headerPanel() {
        JPanel header = new JPanel();
        header.setOpaque(false);
        header.setLayout(new BoxLayout(header, 3));
        JPanel fieldHeader = new JPanel(new FlowLayout(3, 3, 3));
        fieldHeader.setOpaque(false);
        fieldHeader.add(new JLabel(MessageUtils.getLocalizedMessage("documents.docvalues.label.doc_values")));
        fieldHeader.add(new JLabel(this.field));
        header.add(fieldHeader);
        JPanel typeHeader = new JPanel(new FlowLayout(3, 3, 3));
        typeHeader.setOpaque(false);
        typeHeader.add(new JLabel(MessageUtils.getLocalizedMessage("documents.docvalues.label.type")));
        typeHeader.add(new JLabel(this.docValues.getDvType().toString()));
        header.add(typeHeader);
        JPanel decodeHeader = new JPanel(new FlowLayout(4, 3, 3));
        decodeHeader.setOpaque(false);
        decodeHeader.add(new JLabel("decoded as"));
        String[] decoders = (String[])Arrays.stream(Decoder.values()).map(Decoder::toString).toArray(String[]::new);
        this.decodersCombo.setModel(new DefaultComboBoxModel<String>(decoders));
        this.decodersCombo.setSelectedItem(Decoder.LONG.toString());
        this.decodersCombo.addActionListener(this.listeners::selectDecoder);
        decodeHeader.add(this.decodersCombo);
        if (this.docValues.getValues().size() > 0) {
            decodeHeader.setEnabled(false);
        }
        header.add(decodeHeader);
        return header;
    }

    private JList<String> valueList() {
        this.valueList.setVisibleRowCount(5);
        this.valueList.setSelectionMode(2);
        this.valueList.setLayoutOrientation(0);
        DefaultListModel values = new DefaultListModel();
        if (this.docValues.getValues().size() > 0) {
            this.docValues.getValues().stream().map(BytesRefUtils::decode).forEach(values::addElement);
        } else {
            this.docValues.getNumericValues().stream().map(String::valueOf).forEach(values::addElement);
        }
        this.valueList.setModel(values);
        return this.valueList;
    }

    private JPanel footerPanel() {
        JPanel footer = new JPanel(new FlowLayout(4, 5, 5));
        footer.setOpaque(false);
        JButton copyBtn = new JButton(FontUtils.elegantIconHtml("&#xe0e6;", MessageUtils.getLocalizedMessage("button.copy")));
        copyBtn.setMargin(new Insets(3, 0, 3, 0));
        copyBtn.addActionListener(this.listeners::copyValues);
        footer.add(copyBtn);
        JButton closeBtn = new JButton(MessageUtils.getLocalizedMessage("button.close"));
        closeBtn.setMargin(new Insets(3, 0, 3, 0));
        closeBtn.addActionListener(e -> this.dialog.dispose());
        footer.add(closeBtn);
        return footer;
    }

    private void selectDecoder() {
        String decoderLabel = (String)this.decodersCombo.getSelectedItem();
        Decoder decoder = Decoder.fromLabel(decoderLabel);
        if (this.docValues.getNumericValues().isEmpty()) {
            return;
        }
        DefaultListModel values = new DefaultListModel();
        switch (decoder.ordinal()) {
            case 0: {
                this.docValues.getNumericValues().stream().map(String::valueOf).forEach(values::addElement);
                break;
            }
            case 1: {
                this.docValues.getNumericValues().stream().mapToInt(Long::intValue).mapToObj(NumericUtils::sortableIntToFloat).map(String::valueOf).forEach(values::addElement);
                break;
            }
            case 2: {
                this.docValues.getNumericValues().stream().map(NumericUtils::sortableLongToDouble).map(String::valueOf).forEach(values::addElement);
            }
        }
        this.valueList.setModel(values);
    }

    private void copyValues() {
        List<String> values = this.valueList.getSelectedValuesList();
        if (values.isEmpty()) {
            values = this.getAllVlues();
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection selection = new StringSelection(String.join((CharSequence)"\n", values));
        clipboard.setContents(selection, null);
    }

    private List<String> getAllVlues() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < this.valueList.getModel().getSize(); ++i) {
            values.add(this.valueList.getModel().getElementAt(i));
        }
        return values;
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void selectDecoder(ActionEvent e) {
            DocValuesDialogFactory.this.selectDecoder();
        }

        void copyValues(ActionEvent e) {
            DocValuesDialogFactory.this.copyValues();
        }
    }

    public static enum Decoder {
        LONG("long"),
        FLOAT("float"),
        DOUBLE("double");

        private final String label;

        private Decoder(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public static Decoder fromLabel(String label) {
            for (Decoder d : Decoder.values()) {
                if (!d.label.equalsIgnoreCase(label)) continue;
                return d;
            }
            throw new IllegalArgumentException("No such decoder: " + label);
        }
    }
}

