/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.documents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;

public final class StoredValueDialogFactory
implements DialogOpener.DialogFactory {
    private static StoredValueDialogFactory instance;
    private final Preferences prefs = PreferencesFactory.getInstance();
    private JDialog dialog;
    private String field;
    private String value;

    public static synchronized StoredValueDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new StoredValueDialogFactory();
        }
        return instance;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private StoredValueDialogFactory() throws IOException {
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        if (Objects.isNull(this.field) || Objects.isNull(this.value)) {
            throw new IllegalStateException("field name and/or stored value is not set.");
        }
        this.dialog = new JDialog(owner, "Term Vector", Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel header = new JPanel(new FlowLayout(3, 5, 5));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("documents.stored.label.stored_value")));
        header.add(new JLabel(this.field));
        panel.add((Component)header, "First");
        JTextArea valueTA = new JTextArea(this.value);
        valueTA.setLineWrap(true);
        valueTA.setEditable(false);
        valueTA.setBackground(Color.white);
        JScrollPane scrollPane = new JScrollPane(valueTA);
        panel.add((Component)scrollPane, "Center");
        JPanel footer = new JPanel(new FlowLayout(4, 5, 5));
        footer.setOpaque(false);
        JButton copyBtn = new JButton(FontUtils.elegantIconHtml("&#xe0e6;", MessageUtils.getLocalizedMessage("button.copy")));
        copyBtn.setMargin(new Insets(3, 3, 3, 3));
        copyBtn.addActionListener(e -> {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection selection = new StringSelection(this.value);
            clipboard.setContents(selection, null);
        });
        footer.add(copyBtn);
        JButton closeBtn = new JButton(MessageUtils.getLocalizedMessage("button.close"));
        closeBtn.setMargin(new Insets(3, 3, 3, 3));
        closeBtn.addActionListener(e -> this.dialog.dispose());
        footer.add(closeBtn);
        panel.add((Component)footer, "Last");
        return panel;
    }
}

