/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.tools;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.LukeModel;
import org.apache.lucene.luke.models.tools.IndexTools;
import org.apache.lucene.luke.models.util.IndexUtils;
import org.apache.lucene.luke.models.util.twentynewsgroups.Message;
import org.apache.lucene.luke.models.util.twentynewsgroups.MessageFilesParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;

public final class IndexToolsImpl
extends LukeModel
implements IndexTools {
    private final boolean useCompound;
    private final boolean keepAllCommits;

    public IndexToolsImpl(Directory dir, boolean useCompound, boolean keepAllCommits) {
        super(dir);
        this.useCompound = useCompound;
        this.keepAllCommits = keepAllCommits;
    }

    public IndexToolsImpl(IndexReader reader, boolean useCompound, boolean keepAllCommits) {
        super(reader);
        this.useCompound = useCompound;
        this.keepAllCommits = keepAllCommits;
    }

    @Override
    public void optimize(boolean expunge, int maxNumSegments, PrintStream ps) {
        block9: {
            if (this.reader instanceof DirectoryReader) {
                Directory dir = ((DirectoryReader)this.reader).directory();
                try (IndexWriter writer = IndexUtils.createWriter(dir, null, this.useCompound, this.keepAllCommits, ps);){
                    IndexUtils.optimizeIndex(writer, expunge, maxNumSegments);
                    break block9;
                }
                catch (IOException e) {
                    throw new LukeException("Failed to optimize index", e);
                }
            }
            throw new LukeException("Current reader is not a DirectoryReader.");
        }
    }

    @Override
    public CheckIndex.Status checkIndex(PrintStream ps) {
        try {
            if (this.dir != null) {
                return IndexUtils.checkIndex(this.dir, ps);
            }
            if (this.reader instanceof DirectoryReader) {
                Directory dir = ((DirectoryReader)this.reader).directory();
                return IndexUtils.checkIndex(dir, ps);
            }
            throw new IllegalStateException("Directory is not set.");
        }
        catch (Exception e) {
            throw new LukeException("Failed to check index.", e);
        }
    }

    @Override
    public void repairIndex(CheckIndex.Status st, PrintStream ps) {
        try {
            if (this.dir == null) {
                throw new IllegalStateException("Directory is not set.");
            }
            IndexUtils.tryRepairIndex(this.dir, st, ps);
        }
        catch (Exception e) {
            throw new LukeException("Failed to repair index.", e);
        }
    }

    @Override
    public void addDocument(Document doc, Analyzer analyzer) {
        block9: {
            Objects.requireNonNull(analyzer);
            if (this.reader instanceof DirectoryReader) {
                Directory dir = ((DirectoryReader)this.reader).directory();
                try (IndexWriter writer = IndexUtils.createWriter(dir, analyzer, this.useCompound, this.keepAllCommits);){
                    writer.addDocument((Iterable)doc);
                    writer.commit();
                    break block9;
                }
                catch (IOException e) {
                    throw new LukeException("Failed to add document", e);
                }
            }
            throw new LukeException("Current reader is not an instance of DirectoryReader.");
        }
    }

    @Override
    public void deleteDocuments(Query query) {
        block9: {
            Objects.requireNonNull(query);
            if (this.reader instanceof DirectoryReader) {
                Directory dir = ((DirectoryReader)this.reader).directory();
                try (IndexWriter writer = IndexUtils.createWriter(dir, null, this.useCompound, this.keepAllCommits);){
                    writer.deleteDocuments(new Query[]{query});
                    writer.commit();
                    break block9;
                }
                catch (IOException e) {
                    throw new LukeException("Failed to add document", e);
                }
            }
            throw new LukeException("Current reader is not an instance of DirectoryReader.");
        }
    }

    @Override
    public void createNewIndex() {
        this.createNewIndex(null);
    }

    @Override
    public void createNewIndex(String dataDir) {
        IndexWriter writer = null;
        try {
            if (this.dir == null || this.dir.listAll().length > 0) {
                throw new IllegalStateException();
            }
            writer = IndexUtils.createWriter(this.dir, Message.createLuceneAnalyzer(), this.useCompound, this.keepAllCommits);
            if (Objects.nonNull(dataDir)) {
                Path path = Paths.get(dataDir, new String[0]);
                MessageFilesParser parser = new MessageFilesParser(path);
                List<Message> messages = parser.parseAll();
                for (Message message : messages) {
                    writer.addDocument((Iterable)message.toLuceneDoc());
                }
            }
            writer.commit();
        }
        catch (IOException e) {
            throw new LukeException("Cannot create new index.", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String exportTerms(String destDir, String field, String delimiter) {
        String string;
        block10: {
            String filename = "terms_" + field + "_" + System.currentTimeMillis() + ".out";
            Path path = Paths.get(destDir, filename);
            Terms terms = MultiTerms.getTerms((IndexReader)this.reader, (String)field);
            if (terms == null) {
                throw new LukeException(String.format(Locale.US, "Field %s does not contain any terms to be exported", field));
            }
            BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            try {
                BytesRef term;
                TermsEnum termsEnum = terms.iterator();
                while (!Thread.currentThread().isInterrupted() && (term = termsEnum.next()) != null) {
                    writer.write(String.format(Locale.US, "%s%s%d\n", term.utf8ToString(), delimiter, termsEnum.docFreq()));
                }
                string = path.toString();
                if (writer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new LukeException("Terms file export for field [" + field + "] to file [" + filename + "] has failed.", e);
                }
            }
            writer.close();
        }
        return string;
    }
}

