/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import com.ibm.icu.text.RuleBasedNumberFormat;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;

public class LongToEnglishContentSource
extends ContentSource {
    private long counter = 0L;
    private final RuleBasedNumberFormat rnbf = new RuleBasedNumberFormat(Locale.ROOT, 1);

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        long curCounter;
        docData.clear();
        LongToEnglishContentSource longToEnglishContentSource = this;
        synchronized (longToEnglishContentSource) {
            curCounter = this.counter;
            this.counter = this.counter == Long.MAX_VALUE ? Long.MIN_VALUE : ++this.counter;
        }
        docData.setBody(this.rnbf.format(curCounter));
        docData.setName("doc_" + String.valueOf(curCounter));
        docData.setTitle("title_" + String.valueOf(curCounter));
        docData.setDate(new Date());
        return docData;
    }

    @Override
    public void resetInputs() throws IOException {
        this.counter = -9223372036854775798L;
    }
}

