/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.lucene.benchmark.byTask.feeds.AbstractQueryMaker;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.LineDocSource;
import org.apache.lucene.benchmark.byTask.feeds.SpatialDocMaker;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.queries.function.FunctionScoreQuery;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.spatial4j.shape.Shape;

public class SpatialFileQueryMaker
extends AbstractQueryMaker {
    protected SpatialStrategy strategy;
    protected double distErrPct;
    protected SpatialOperation operation;
    protected boolean score;
    protected SpatialDocMaker.ShapeConverter shapeConverter;

    @Override
    public void setConfig(Config config) throws Exception {
        this.strategy = SpatialDocMaker.getSpatialStrategy(config.getRoundNumber());
        this.shapeConverter = SpatialDocMaker.makeShapeConverter(this.strategy, config, "query.spatial.");
        this.distErrPct = config.get("query.spatial.distErrPct", Double.NaN);
        this.operation = SpatialOperation.get((String)config.get("query.spatial.predicate", "Intersects"));
        this.score = config.get("query.spatial.score", false);
        super.setConfig(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Query[] prepareQueries() throws Exception {
        int maxQueries = this.config.get("query.file.maxQueries", 1000);
        Config srcConfig = new Config(new Properties());
        srcConfig.set("docs.file", this.config.get("query.file", null));
        srcConfig.set("line.parser", this.config.get("query.file.line.parser", null));
        srcConfig.set("content.source.forever", "false");
        ArrayList<Query> queries = new ArrayList<Query>();
        try (LineDocSource src = new LineDocSource();){
            src.setConfig(srcConfig);
            src.resetInputs();
            DocData docData = new DocData();
            for (int i = 0; i < maxQueries; ++i) {
                Shape shape = SpatialDocMaker.makeShapeFromString(this.strategy, (docData = src.getNextDocData(docData)).getName(), docData.getBody());
                if (shape != null) {
                    shape = this.shapeConverter.convert(shape);
                    queries.add(this.makeQueryFromShape(shape));
                    continue;
                }
                --i;
            }
        }
        return queries.toArray(new Query[queries.size()]);
    }

    protected Query makeQueryFromShape(Shape shape) {
        SpatialArgs args = new SpatialArgs(this.operation, shape);
        if (!Double.isNaN(this.distErrPct)) {
            args.setDistErrPct(Double.valueOf(this.distErrPct));
        }
        Query filterQuery = this.strategy.makeQuery(args);
        if (this.score) {
            DoubleValuesSource valueSource = this.strategy.makeDistanceValueSource(shape.getCenter());
            return new FunctionScoreQuery(filterQuery, valueSource);
        }
        return filterQuery;
    }
}

