/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.knn;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.demo.knn.KnnVectorDict;
import org.apache.lucene.demo.knn.KnnVectorDictFilter;

public class DemoEmbeddings {
    private final Analyzer analyzer;

    public DemoEmbeddings(final KnnVectorDict vectorDict) {
        this.analyzer = new Analyzer(this){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer tokenizer = new StandardTokenizer();
                KnnVectorDictFilter output = new KnnVectorDictFilter((TokenStream)new LowerCaseFilter((TokenStream)tokenizer), vectorDict);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)output);
            }
        };
    }

    public float[] computeEmbedding(String input) throws IOException {
        return this.computeEmbedding(new StringReader(input));
    }

    public float[] computeEmbedding(Reader input) throws IOException {
        try (TokenStream tokens = this.analyzer.tokenStream("dummyField", input);){
            tokens.reset();
            while (tokens.incrementToken()) {
            }
            tokens.end();
            float[] fArray = ((KnnVectorDictFilter)tokens).getResult();
            return fArray;
        }
    }
}

