/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.VectorUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=4, time=1)
@Measurement(iterations=5, time=1)
@Fork(value=3, jvmArgsAppend={"-Xmx2g", "-Xms2g", "-XX:+AlwaysPreTouch"})
public class VectorUtilBenchmark {
    private byte[] bytesA;
    private byte[] bytesB;
    private byte[] halfBytesA;
    private byte[] halfBytesB;
    private byte[] halfBytesBPacked;
    private float[] floatsA;
    private float[] floatsB;
    private int expectedhalfByteDotProduct;
    @Param(value={"1", "128", "207", "256", "300", "512", "702", "1024"})
    int size;

    static void compressBytes(byte[] raw, byte[] compressed) {
        for (int i = 0; i < compressed.length; ++i) {
            int v = raw[i] << 4 | raw[compressed.length + i];
            compressed[i] = (byte)v;
        }
    }

    @Setup(value=Level.Iteration)
    public void init() {
        int i;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.bytesA = new byte[this.size];
        this.bytesB = new byte[this.size];
        random.nextBytes(this.bytesA);
        random.nextBytes(this.bytesB);
        this.expectedhalfByteDotProduct = 0;
        this.halfBytesA = new byte[this.size];
        this.halfBytesB = new byte[this.size];
        for (i = 0; i < this.size; ++i) {
            this.halfBytesA[i] = (byte)random.nextInt(16);
            this.halfBytesB[i] = (byte)random.nextInt(16);
            this.expectedhalfByteDotProduct += this.halfBytesA[i] * this.halfBytesB[i];
        }
        if (this.size % 2 == 0) {
            this.halfBytesBPacked = new byte[this.size + 1 >> 1];
            VectorUtilBenchmark.compressBytes(this.halfBytesB, this.halfBytesBPacked);
        }
        this.floatsA = new float[this.size];
        this.floatsB = new float[this.size];
        for (i = 0; i < this.size; ++i) {
            this.floatsA[i] = random.nextFloat();
            this.floatsB[i] = random.nextFloat();
        }
    }

    @Benchmark
    public float binaryCosineScalar() {
        return VectorUtil.cosine((byte[])this.bytesA, (byte[])this.bytesB);
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
    public float binaryCosineVector() {
        return VectorUtil.cosine((byte[])this.bytesA, (byte[])this.bytesB);
    }

    @Benchmark
    public int binaryDotProductScalar() {
        return VectorUtil.dotProduct((byte[])this.bytesA, (byte[])this.bytesB);
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
    public int binaryDotProductVector() {
        return VectorUtil.dotProduct((byte[])this.bytesA, (byte[])this.bytesB);
    }

    @Benchmark
    public int binarySquareScalar() {
        return VectorUtil.squareDistance((byte[])this.bytesA, (byte[])this.bytesB);
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
    public int binarySquareVector() {
        return VectorUtil.squareDistance((byte[])this.bytesA, (byte[])this.bytesB);
    }

    @Benchmark
    public int binaryHalfByteScalar() {
        return VectorUtil.int4DotProduct((byte[])this.halfBytesA, (byte[])this.halfBytesB);
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
    public int binaryHalfByteVector() {
        return VectorUtil.int4DotProduct((byte[])this.halfBytesA, (byte[])this.halfBytesB);
    }

    @Benchmark
    public int binaryHalfByteScalarPacked() {
        if (this.size % 2 != 0) {
            throw new RuntimeException("Size must be even for this benchmark");
        }
        int v = VectorUtil.int4DotProductPacked((byte[])this.halfBytesA, (byte[])this.halfBytesBPacked);
        if (v != this.expectedhalfByteDotProduct) {
            throw new RuntimeException("Expected " + this.expectedhalfByteDotProduct + " but got " + v);
        }
        return v;
    }

    @Benchmark
    @Fork(jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
    public int binaryHalfByteVectorPacked() {
        if (this.size % 2 != 0) {
            throw new RuntimeException("Size must be even for this benchmark");
        }
        int v = VectorUtil.int4DotProductPacked((byte[])this.halfBytesA, (byte[])this.halfBytesBPacked);
        if (v != this.expectedhalfByteDotProduct) {
            throw new RuntimeException("Expected " + this.expectedhalfByteDotProduct + " but got " + v);
        }
        return v;
    }

    @Benchmark
    public float floatCosineScalar() {
        return VectorUtil.cosine((float[])this.floatsA, (float[])this.floatsB);
    }

    @Benchmark
    @Fork(value=15, jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
    public float floatCosineVector() {
        return VectorUtil.cosine((float[])this.floatsA, (float[])this.floatsB);
    }

    @Benchmark
    public float floatDotProductScalar() {
        return VectorUtil.dotProduct((float[])this.floatsA, (float[])this.floatsB);
    }

    @Benchmark
    @Fork(value=15, jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
    public float floatDotProductVector() {
        return VectorUtil.dotProduct((float[])this.floatsA, (float[])this.floatsB);
    }

    @Benchmark
    public float floatSquareScalar() {
        return VectorUtil.squareDistance((float[])this.floatsA, (float[])this.floatsB);
    }

    @Benchmark
    @Fork(value=15, jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
    public float floatSquareVector() {
        return VectorUtil.squareDistance((float[])this.floatsA, (float[])this.floatsB);
    }
}

