/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.opennlp.OpenNLPLemmatizerFilter;
import org.apache.lucene.analysis.opennlp.tools.NLPLemmatizerOp;
import org.apache.lucene.analysis.opennlp.tools.OpenNLPOpsFactory;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;

public class OpenNLPLemmatizerFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "openNlpLemmatizer";
    public static final String DICTIONARY = "dictionary";
    public static final String LEMMATIZER_MODEL = "lemmatizerModel";
    private final String dictionaryFile;
    private final String lemmatizerModelFile;

    public OpenNLPLemmatizerFilterFactory(Map<String, String> args) {
        super(args);
        this.dictionaryFile = this.get(args, DICTIONARY);
        this.lemmatizerModelFile = this.get(args, LEMMATIZER_MODEL);
        if (this.dictionaryFile == null && this.lemmatizerModelFile == null) {
            throw new IllegalArgumentException("Configuration Error: missing parameter: at least one of 'dictionary' and 'lemmatizerModel' must be provided.");
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public OpenNLPLemmatizerFilterFactory() {
        throw OpenNLPLemmatizerFilterFactory.defaultCtorException();
    }

    public OpenNLPLemmatizerFilter create(TokenStream in) {
        try {
            NLPLemmatizerOp lemmatizerOp = OpenNLPOpsFactory.getLemmatizer(this.dictionaryFile, this.lemmatizerModelFile);
            return new OpenNLPLemmatizerFilter(in, lemmatizerOp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void inform(ResourceLoader loader) throws IOException {
        if (this.dictionaryFile != null) {
            OpenNLPOpsFactory.getLemmatizerDictionary(this.dictionaryFile, loader);
        }
        if (this.lemmatizerModelFile != null) {
            OpenNLPOpsFactory.getLemmatizerModel(this.lemmatizerModelFile, loader);
        }
    }
}

