/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.analysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.EditParamsMode;
import org.apache.lucene.luke.app.desktop.components.fragments.analysis.CustomAnalyzerPanelOperator;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.app.desktop.util.lang.Callable;

public final class EditParamsDialogFactory
implements DialogOpener.DialogFactory {
    private static EditParamsDialogFactory instance;
    private final Preferences prefs;
    private final ComponentOperatorRegistry operatorRegistry;
    private final JTable paramsTable = new JTable();
    private JDialog dialog;
    private EditParamsMode mode;
    private String target;
    private int targetIndex;
    private Map<String, String> params = new HashMap<String, String>();
    private Callable callback;

    public static synchronized EditParamsDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new EditParamsDialogFactory();
        }
        return instance;
    }

    private EditParamsDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
    }

    public void setMode(EditParamsMode mode) {
        this.mode = mode;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setTargetIndex(int targetIndex) {
        this.targetIndex = targetIndex;
    }

    public void setParams(Map<String, String> params) {
        this.params.putAll(params);
    }

    public void setCallback(Callable callback) {
        this.callback = callback;
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel header = new JPanel(new FlowLayout(3, 10, 10));
        header.setOpaque(false);
        header.add(new JLabel("Parameters for:"));
        String[] tmp = this.target.split("\\.");
        JLabel targetLbl = new JLabel(tmp[tmp.length - 1]);
        header.add(targetLbl);
        panel.add((Component)header, "First");
        TableUtils.setupTable(this.paramsTable, 0, new ParamsTableModel(this.params), null, ParamsTableModel.Column.DELETE.getColumnWidth(), ParamsTableModel.Column.NAME.getColumnWidth());
        this.paramsTable.setShowGrid(true);
        panel.add((Component)new JScrollPane(this.paramsTable), "Center");
        JPanel footer = new JPanel(new FlowLayout(4, 10, 5));
        footer.setOpaque(false);
        JButton okBtn = new JButton(MessageUtils.getLocalizedMessage("button.ok"));
        okBtn.addActionListener(e -> {
            HashMap<String, String> params = new HashMap<String, String>();
            for (int i = 0; i < this.paramsTable.getRowCount(); ++i) {
                boolean deleted = (Boolean)this.paramsTable.getValueAt(i, ParamsTableModel.Column.DELETE.getIndex());
                String name = (String)this.paramsTable.getValueAt(i, ParamsTableModel.Column.NAME.getIndex());
                String value = (String)this.paramsTable.getValueAt(i, ParamsTableModel.Column.VALUE.getIndex());
                if (deleted || Objects.isNull(name) || name.isEmpty() || Objects.isNull(value) || value.isEmpty()) continue;
                params.put(name, value);
            }
            this.updateTargetParams(params);
            this.callback.call();
            this.params.clear();
            this.dialog.dispose();
        });
        footer.add(okBtn);
        JButton cancelBtn = new JButton(MessageUtils.getLocalizedMessage("button.cancel"));
        cancelBtn.addActionListener(e -> {
            this.params.clear();
            this.dialog.dispose();
        });
        footer.add(cancelBtn);
        panel.add((Component)footer, "Last");
        return panel;
    }

    private void updateTargetParams(Map<String, String> params) {
        this.operatorRegistry.get(CustomAnalyzerPanelOperator.class).ifPresent(operator -> {
            switch (this.mode) {
                case CHARFILTER: {
                    operator.updateCharFilterParams(this.targetIndex, params);
                    break;
                }
                case TOKENIZER: {
                    operator.updateTokenizerParams(params);
                    break;
                }
                case TOKENFILTER: {
                    operator.updateTokenFilterParams(this.targetIndex, params);
                }
            }
        });
    }

    static final class ParamsTableModel
    extends TableModelBase<Column> {
        private static final int PARAM_SIZE = 20;

        ParamsTableModel(Map<String, String> params) {
            super(20);
            int i;
            ArrayList<String> keys = new ArrayList<String>(params.keySet());
            for (i = 0; i < keys.size(); ++i) {
                this.data[i][Column.NAME.getIndex()] = keys.get(i);
                this.data[i][Column.VALUE.getIndex()] = params.get(keys.get(i));
            }
            for (i = 0; i < this.data.length; ++i) {
                this.data[i][Column.DELETE.getIndex()] = false;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = value;
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            DELETE("Delete", 0, Boolean.class, 50),
            NAME("Name", 1, String.class, 150),
            VALUE("Value", 2, String.class, Integer.MAX_VALUE);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }
}

