/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.analysis.Analysis;
import org.apache.lucene.luke.models.analysis.CustomAnalyzerConfig;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.IOUtils;

public final class AnalysisImpl
implements Analysis {
    private Analyzer analyzer = this.defaultAnalyzer();

    @Override
    public void addExternalJars(List<String> jarFiles) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String jarFile : jarFiles) {
            Path path = FileSystems.getDefault().getPath(jarFile, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) || !jarFile.endsWith(".jar")) {
                throw new LukeException(String.format(Locale.ENGLISH, "Invalid jar file path: %s", jarFile));
            }
            try {
                URL url = path.toUri().toURL();
                urls.add(url);
            }
            catch (IOException e) {
                throw new LukeException(e.getMessage(), e);
            }
        }
        URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), this.getClass().getClassLoader());
        CharFilterFactory.reloadCharFilters((ClassLoader)classLoader);
        TokenizerFactory.reloadTokenizers((ClassLoader)classLoader);
        TokenFilterFactory.reloadTokenFilters((ClassLoader)classLoader);
    }

    @Override
    public Collection<String> getAvailableCharFilters() {
        return CharFilterFactory.availableCharFilters().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAvailableTokenizers() {
        return TokenizerFactory.availableTokenizers().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAvailableTokenFilters() {
        return TokenFilterFactory.availableTokenFilters().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public List<Analysis.Token> analyze(String text) {
        Objects.requireNonNull(text);
        if (this.analyzer == null) {
            throw new LukeException("Analyzer is not set.");
        }
        try {
            ArrayList<Analysis.Token> result = new ArrayList<Analysis.Token>();
            TokenStream stream = this.analyzer.tokenStream("", text);
            stream.reset();
            CharTermAttribute charAtt = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
            while (stream.incrementToken()) {
                List<Analysis.TokenAttribute> attributes = this.copyAttributes(stream, charAtt);
                result.add(new Analysis.Token(charAtt.toString(), attributes));
            }
            stream.close();
            return result;
        }
        catch (IOException e) {
            throw new LukeException(e.getMessage(), e);
        }
    }

    private List<Analysis.TokenAttribute> copyAttributes(TokenStream tokenStream, CharTermAttribute charAtt) {
        ArrayList<Analysis.TokenAttribute> attributes = new ArrayList<Analysis.TokenAttribute>();
        Iterator itr = tokenStream.getAttributeImplsIterator();
        while (itr.hasNext()) {
            AttributeImpl att = (AttributeImpl)itr.next();
            LinkedHashMap<String, String> attValues = new LinkedHashMap<String, String>();
            att.reflectWith((attClass, key, value) -> {
                if (value != null) {
                    attValues.put(key, value.toString());
                }
            });
            attributes.add(new Analysis.TokenAttribute(att.getClass().getSimpleName(), attValues));
        }
        return attributes;
    }

    @Override
    public Analyzer createAnalyzerFromClassName(String analyzerType) {
        Objects.requireNonNull(analyzerType);
        try {
            Class<Analyzer> clazz = Class.forName(analyzerType).asSubclass(Analyzer.class);
            this.analyzer = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return this.analyzer;
        }
        catch (ReflectiveOperationException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Failed to instantiate class: %s", analyzerType), e);
        }
    }

    private Analyzer defaultAnalyzer() {
        return new StandardAnalyzer();
    }

    @Override
    public Analyzer buildCustomAnalyzer(CustomAnalyzerConfig config) {
        Objects.requireNonNull(config);
        try {
            CustomAnalyzer.Builder builder = config.getConfigDir().map(path -> CustomAnalyzer.builder((Path)FileSystems.getDefault().getPath((String)path, new String[0]))).orElseGet(CustomAnalyzer::builder);
            builder.withTokenizer(config.getTokenizerConfig().getName(), config.getTokenizerConfig().getParams());
            for (CustomAnalyzerConfig.ComponentConfig cfConf : config.getCharFilterConfigs()) {
                builder.addCharFilter(cfConf.getName(), cfConf.getParams());
            }
            for (CustomAnalyzerConfig.ComponentConfig tfConf : config.getTokenFilterConfigs()) {
                builder.addTokenFilter(tfConf.getName(), tfConf.getParams());
            }
            this.analyzer = builder.build();
            return this.analyzer;
        }
        catch (Exception e) {
            throw new LukeException("Failed to build custom analyzer.", e);
        }
    }

    @Override
    public Analyzer currentAnalyzer() {
        if (this.analyzer == null) {
            throw new LukeException("Analyzer is not set.");
        }
        return this.analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Analysis.StepByStepResult analyzeStepByStep(String text) {
        Objects.requireNonNull(text);
        if (this.analyzer == null) {
            throw new LukeException("Analyzer is not set.");
        }
        if (!(this.analyzer instanceof CustomAnalyzer)) {
            throw new LukeException("Analyzer is not CustomAnalyzer.");
        }
        ArrayList<Analysis.NamedTokens> namedTokens = new ArrayList<Analysis.NamedTokens>();
        ArrayList<Analysis.CharfilteredText> charfilteredTexts = new ArrayList<Analysis.CharfilteredText>();
        try {
            CustomAnalyzer customAnalyzer = (CustomAnalyzer)this.analyzer;
            List charFilterFactories = customAnalyzer.getCharFilterFactories();
            StringReader reader = new StringReader(text);
            String charFilteredSource = text;
            if (charFilterFactories.size() > 0) {
                Reader cs = reader;
                for (CharFilterFactory charFilterFactory : charFilterFactories) {
                    cs = charFilterFactory.create((Reader)reader);
                    Reader readerForWriteOut = new StringReader(charFilteredSource);
                    readerForWriteOut = charFilterFactory.create(readerForWriteOut);
                    charFilteredSource = AnalysisImpl.writeCharStream(readerForWriteOut);
                    charfilteredTexts.add(new Analysis.CharfilteredText(CharFilterFactory.findSPIName(charFilterFactory.getClass()), charFilteredSource));
                }
                reader = cs;
            }
            TokenizerFactory tokenizerFactory = customAnalyzer.getTokenizerFactory();
            List tokenFilterFactories = customAnalyzer.getTokenFilterFactories();
            Tokenizer tokenStream = tokenizerFactory.create();
            tokenStream.setReader((Reader)reader);
            ArrayList<Analysis.Token> tokens = new ArrayList<Analysis.Token>();
            List<AttributeSource> attributeSources = this.analyzeTokenStream((TokenStream)tokenStream, tokens);
            namedTokens.add(new Analysis.NamedTokens(TokenizerFactory.findSPIName(tokenizerFactory.getClass()), tokens));
            ListBasedTokenStream listBasedTokenStream = new ListBasedTokenStream((AttributeSource)tokenStream, attributeSources);
            for (TokenFilterFactory tokenFilterFactory : tokenFilterFactories) {
                tokenStream = tokenFilterFactory.create((TokenStream)listBasedTokenStream);
                tokens = new ArrayList();
                attributeSources = this.analyzeTokenStream((TokenStream)tokenStream, tokens);
                namedTokens.add(new Analysis.NamedTokens(TokenFilterFactory.findSPIName(tokenFilterFactory.getClass()), tokens));
                try {
                    listBasedTokenStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                listBasedTokenStream = new ListBasedTokenStream((AttributeSource)listBasedTokenStream, attributeSources);
            }
            try {
                listBasedTokenStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                ((Reader)reader).close();
            }
            return new Analysis.StepByStepResult(charfilteredTexts, namedTokens);
        }
        catch (Exception e) {
            throw new LukeException(e.getMessage(), e);
        }
    }

    private List<AttributeSource> analyzeTokenStream(TokenStream tokenStream, List<Analysis.Token> result) {
        ArrayList<AttributeSource> tokens = new ArrayList<AttributeSource>();
        try {
            tokenStream.reset();
            CharTermAttribute charAtt = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
            while (tokenStream.incrementToken()) {
                tokens.add(tokenStream.cloneAttributes());
                List<Analysis.TokenAttribute> attributes = this.copyAttributes(tokenStream, charAtt);
                result.add(new Analysis.Token(charAtt.toString(), attributes));
            }
            tokenStream.end();
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException("Error occurred while iterating over TokenStream", ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{tokenStream});
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{tokenStream});
        return tokens;
    }

    private static String writeCharStream(Reader input) {
        int BUFFER_SIZE = 1024;
        char[] buf = new char[1024];
        int len = 0;
        StringBuilder sb = new StringBuilder();
        do {
            try {
                len = input.read(buf, 0, 1024);
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred while iterating over charfiltering", e);
            }
            if (len <= 0) continue;
            sb.append(buf, 0, len);
        } while (len == 1024);
        return sb.toString();
    }

    protected static final class ListBasedTokenStream
    extends TokenStream {
        private final List<AttributeSource> tokens;
        private Iterator<AttributeSource> tokenIterator;

        ListBasedTokenStream(AttributeSource attributeSource, List<AttributeSource> tokens) {
            super(attributeSource.getAttributeFactory());
            this.tokens = tokens;
            this.addAttributes(attributeSource);
        }

        public void reset() throws IOException {
            super.reset();
            this.tokenIterator = this.tokens.iterator();
        }

        public boolean incrementToken() {
            if (this.tokenIterator.hasNext()) {
                this.clearAttributes();
                AttributeSource next = this.tokenIterator.next();
                this.addAttributes(next);
                next.copyTo((AttributeSource)this);
                return true;
            }
            return false;
        }

        void addAttributes(AttributeSource attributeSource) {
            Iterator atts = attributeSource.getAttributeImplsIterator();
            while (atts.hasNext()) {
                this.addAttributeImpl((AttributeImpl)atts.next());
            }
        }
    }
}

