/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;

final class SuffixingNGramTokenFilter
extends TokenFilter {
    private final String suffix;
    private final int maxTokenLength;
    private final String anyToken;
    private char[] curTermBuffer;
    private int curTermLength;
    private int curCodePointCount;
    private int curGramSize;
    private int curPos;
    private int curPosInc;
    private int curPosLen;
    private int tokStart;
    private int tokEnd;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAtt;
    private final PositionLengthAttribute posLenAtt;
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    private final CharArraySet seenSuffixes = new CharArraySet(1024, false);
    private final CharArraySet seenInfixes = new CharArraySet(1024, false);

    public SuffixingNGramTokenFilter(TokenStream input, String suffix, String wildcardToken, int maxTokenLength) {
        super(input);
        this.suffix = suffix;
        this.anyToken = wildcardToken;
        this.maxTokenLength = maxTokenLength;
        this.posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        while (true) {
            if (this.curTermBuffer == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                if (this.keywordAtt.isKeyword()) {
                    return true;
                }
                this.curTermBuffer = (char[])this.termAtt.buffer().clone();
                this.curTermLength = this.termAtt.length();
                this.curCodePointCount = Character.codePointCount((CharSequence)this.termAtt, 0, this.termAtt.length());
                this.curGramSize = this.curTermLength;
                this.curPos = 0;
                this.curPosInc = this.posIncAtt.getPositionIncrement();
                this.curPosLen = this.posLenAtt.getPositionLength();
                this.tokStart = this.offsetAtt.startOffset();
                this.tokEnd = this.offsetAtt.endOffset();
                return true;
            }
            if (this.curTermLength > this.maxTokenLength) {
                this.clearAttributes();
                this.termAtt.append(this.anyToken);
                this.curTermBuffer = null;
                return true;
            }
            if (this.curGramSize == 0) {
                ++this.curPos;
                this.curGramSize = this.curTermLength - this.curPos;
            }
            if (this.curGramSize >= 0 && this.curPos + this.curGramSize <= this.curCodePointCount) {
                this.clearAttributes();
                int start = Character.offsetByCodePoints(this.curTermBuffer, 0, this.curTermLength, 0, this.curPos);
                int end = Character.offsetByCodePoints(this.curTermBuffer, 0, this.curTermLength, start, this.curGramSize);
                this.termAtt.copyBuffer(this.curTermBuffer, start, end - start);
                this.termAtt.append(this.suffix);
                if (this.curGramSize == this.curTermLength - this.curPos && !this.seenSuffixes.add(this.termAtt.subSequence(0, this.termAtt.length()))) {
                    this.curTermBuffer = null;
                    continue;
                }
                if (!this.seenInfixes.add(this.termAtt.subSequence(0, this.termAtt.length()))) {
                    this.curGramSize = 0;
                    continue;
                }
                this.posIncAtt.setPositionIncrement(this.curPosInc);
                this.curPosInc = 0;
                this.posLenAtt.setPositionLength(this.curPosLen);
                this.offsetAtt.setOffset(this.tokStart, this.tokEnd);
                --this.curGramSize;
                return true;
            }
            this.curTermBuffer = null;
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.curTermBuffer = null;
        this.seenInfixes.clear();
        this.seenSuffixes.clear();
    }
}

