/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BSONBinaryWriter;
import com.mongodb.BSONBinaryWriterSettings;
import com.mongodb.BSONWriterSettings;
import com.mongodb.DBEncoder;
import com.mongodb.MessageSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.RequestMessage;
import com.mongodb.WriteConcern;
import org.bson.io.OutputBuffer;

abstract class BaseWriteCommandMessage
extends RequestMessage {
    private static final int HEADROOM = 16384;
    private final MongoNamespace writeNamespace;
    private final WriteConcern writeConcern;
    private final Boolean bypassDocumentValidation;
    private final DBEncoder commandEncoder;

    public BaseWriteCommandMessage(MongoNamespace writeNamespace, WriteConcern writeConcern, Boolean bypassDocumentValidation, DBEncoder commandEncoder, MessageSettings settings) {
        super(new MongoNamespace(writeNamespace.getDatabaseName(), "$cmd").getFullName(), RequestMessage.OpCode.OP_QUERY, settings);
        this.writeNamespace = writeNamespace;
        this.writeConcern = writeConcern;
        this.bypassDocumentValidation = bypassDocumentValidation;
        this.commandEncoder = commandEncoder;
    }

    public MongoNamespace getWriteNamespace() {
        return this.writeNamespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public DBEncoder getCommandEncoder() {
        return this.commandEncoder;
    }

    public BaseWriteCommandMessage encode(OutputBuffer buffer) {
        return (BaseWriteCommandMessage)super.encode(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseWriteCommandMessage encodeMessageBody(OutputBuffer buffer, int messageStartPosition) {
        BaseWriteCommandMessage nextMessage = null;
        this.writeCommandHeader(buffer);
        int commandStartPosition = buffer.getPosition();
        BSONBinaryWriter writer = new BSONBinaryWriter(new BSONWriterSettings(), new BSONBinaryWriterSettings(this.getSettings().getMaxDocumentSize() + 16384), buffer);
        try {
            writer.writeStartDocument();
            this.writeCommandPrologue(writer);
            nextMessage = this.writeTheWrites(buffer, commandStartPosition, writer);
            writer.writeEndDocument();
        }
        finally {
            writer.close();
        }
        return nextMessage;
    }

    private void writeCommandHeader(OutputBuffer buffer) {
        buffer.writeInt(0);
        buffer.writeCString(this.getCollectionName());
        buffer.writeInt(0);
        buffer.writeInt(-1);
    }

    protected abstract String getCommandName();

    protected Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    protected abstract BaseWriteCommandMessage writeTheWrites(OutputBuffer var1, int var2, BSONBinaryWriter var3);

    protected boolean exceedsLimits(int batchLength, int batchItemCount) {
        return this.exceedsBatchLengthLimit(batchLength, batchItemCount) || this.exceedsBatchItemCountLimit(batchItemCount);
    }

    private boolean exceedsBatchLengthLimit(int batchLength, int batchItemCount) {
        return batchLength > this.getSettings().getMaxDocumentSize() && batchItemCount > 1;
    }

    private boolean exceedsBatchItemCountLimit(int batchItemCount) {
        return batchItemCount > this.getSettings().getMaxWriteBatchSize();
    }

    public abstract int getItemCount();

    private void writeCommandPrologue(BSONBinaryWriter writer) {
        writer.writeString(this.getCommandName(), this.getWriteNamespace().getCollectionName());
        writer.writeBoolean("ordered", !this.getWriteConcern().getContinueOnError());
        if (!this.getWriteConcern().useServerDefault()) {
            writer.writeName("writeConcern");
            writer.encodeDocument(this.getCommandEncoder(), this.getWriteConcern().asDBObject());
        }
        if (this.bypassDocumentValidation != null) {
            writer.writeBoolean("bypassDocumentValidation", this.bypassDocumentValidation);
        }
    }
}

