/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import org.apache.sis.geometry.Envelopes;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.builder.LinearTransformBuilder;
import org.apache.sis.referencing.operation.builder.ResidualGrid;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class Linearizer {
    private Linearizer() {
    }

    /*
     * Unable to fully structure code
     */
    static MathTransform approximate(MathTransform var0, Envelope var1_1) throws TransformException, FactoryException {
        if (var1_1.getDimension() != 2) {
            return Linearizer.compute(var0, var1_1, null);
        }
        var2_2 = null;
        var3_3 = MathTransforms.getSteps(var0).iterator();
        while (var3_3.hasNext()) {
            block7: {
                var4_4 = var3_3.next();
                if (var4_4 instanceof LinearTransform) {
                    var2_2 = var2_2 != null ? MathTransforms.concatenate(var2_2, var4_4) : var4_4;
                    continue;
                }
                if (!(var4_4 instanceof InterpolatedTransform)) break block7;
                var5_5 = ((InterpolatedTransform)var4_4).getShiftGrid();
                var6_6 = var5_5.getCoordinateToGrid();
                if (var2_2 != null) {
                    var6_6 = MathTransforms.concatenate(var2_2, var6_6);
                }
                var7_7 = Envelopes.transform(var6_6, var1_1);
                if (!(var5_5 instanceof ResidualGrid)) ** GOTO lbl20
                for (var8_8 = 0; var8_8 < 2; ++var8_8) {
                    if (!(var7_7.getMinimum(var8_8) >= 0.5) && !(var7_7.getMaximum(var8_8) <= (double)var5_5.getGridSize(var8_8) - 1.5)) {
                        continue;
                    }
lbl20:
                    // 4 sources

                    while (var3_3.hasNext()) {
                        var4_4 = MathTransforms.concatenate(var4_4, var3_3.next());
                    }
                    return MathTransforms.concatenate(var6_6, Linearizer.compute(var4_4, var7_7, var5_5));
                }
                continue;
            }
            return Linearizer.compute(var0, var1_1, null);
        }
        return var2_2;
    }

    private static MathTransform compute(MathTransform mathTransform, Envelope envelope, DatumShiftGrid<?, ?> datumShiftGrid) throws TransformException, FactoryException {
        int[] nArray = new int[envelope.getDimension()];
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            double d;
            double d2 = Math.rint(envelope.getMinimum(i));
            double d3 = Math.rint(envelope.getMaximum(i));
            if (datumShiftGrid != null) {
                d = datumShiftGrid.getGridSize(i);
                if (d3 > d) {
                    d3 = d;
                }
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
            }
            if (!((d = d3 - d2) <= 2.147483647E9)) {
                throw new ArithmeticException(Errors.format((short)10, 32));
            }
            dArray[i] = d2;
            nArray[i] = (int)d;
        }
        LinearTransformBuilder linearTransformBuilder = new LinearTransformBuilder(nArray);
        LinearTransform linearTransform = MathTransforms.translation(dArray);
        linearTransformBuilder.setControlPoints(MathTransforms.concatenate(linearTransform, mathTransform));
        return MathTransforms.concatenate(linearTransform.inverse(), linearTransformBuilder.create(null));
    }
}

