/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.testng.ClassMethodMap;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IInvoker;
import org.testng.internal.IMethodWorker;
import org.testng.internal.MethodInstance;
import org.testng.internal.Utils;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMethodWorker
implements IMethodWorker {
    protected MethodInstance[] m_testMethods;
    protected IInvoker m_invoker = null;
    protected Map<String, String> m_parameters = null;
    protected XmlSuite m_suite = null;
    protected Map<ITestClass, ITestClass> m_invokedBeforeClassMethods = null;
    protected Map<ITestClass, ITestClass> m_invokedAfterClassMethods = null;
    protected ITestNGMethod[] m_allTestMethods;
    protected List<ITestResult> m_testResults = new ArrayList<ITestResult>();
    protected ConfigurationGroupMethods m_groupMethods = null;
    protected ClassMethodMap m_classMethodMap = null;
    private ITestContext m_testContext = null;

    public TestMethodWorker(IInvoker invoker, MethodInstance[] testMethods, XmlSuite suite, Map<String, String> parameters, Map<ITestClass, ITestClass> invokedBeforeClassMethods, Map<ITestClass, ITestClass> invokedAfterClassMethods, ITestNGMethod[] allTestMethods, ConfigurationGroupMethods groupMethods, ClassMethodMap classMethodMap, ITestContext testContext) {
        this.m_invoker = invoker;
        this.m_testMethods = testMethods;
        this.m_suite = suite;
        this.m_parameters = parameters;
        this.m_invokedBeforeClassMethods = invokedBeforeClassMethods;
        this.m_invokedAfterClassMethods = invokedAfterClassMethods;
        this.m_allTestMethods = allTestMethods;
        this.m_groupMethods = groupMethods;
        this.m_classMethodMap = classMethodMap;
        this.m_testContext = testContext;
    }

    @Override
    public long getMaxTimeOut() {
        long result = 0L;
        for (MethodInstance mi : this.m_testMethods) {
            ITestNGMethod tm = mi.getMethod();
            if (tm.getTimeOut() <= result) continue;
            result = tm.getTimeOut();
        }
        return result;
    }

    public String toString() {
        return new StringBuffer().append("[Worker on thread:").append(Thread.currentThread().getId()).append(" ").append(this.m_testMethods[0].getMethod()).append("]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int indexMethod = 0; indexMethod < this.m_testMethods.length; ++indexMethod) {
            ITestNGMethod tm = this.m_testMethods[indexMethod].getMethod();
            ITestClass testClass = tm.getTestClass();
            this.invokeBeforeClassMethods(testClass);
            try {
                this.invokeTestMethods(tm, this.m_testMethods[indexMethod].getInstances(), this.m_testContext);
                continue;
            }
            finally {
                this.invokeAfterClassMethods(testClass, tm);
            }
        }
    }

    protected void invokeTestMethods(ITestNGMethod tm, Object[] instances, ITestContext testContext) {
        List<ITestResult> testResults = this.m_invoker.invokeTestMethods(tm, this.m_allTestMethods, this.indexOf(tm, this.m_allTestMethods), this.m_suite, this.m_parameters, this.m_groupMethods, instances, testContext);
        if (testResults != null) {
            this.m_testResults.addAll(testResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeBeforeClassMethods(ITestClass testClass) {
        if (null == this.m_invokedBeforeClassMethods) {
            return;
        }
        ITestNGMethod[] classMethods = testClass.getBeforeClassMethods();
        if (null == classMethods || classMethods.length == 0) {
            return;
        }
        Map<ITestClass, ITestClass> map = this.m_invokedBeforeClassMethods;
        synchronized (map) {
            if (!this.m_invokedBeforeClassMethods.containsKey(testClass)) {
                this.m_invokedBeforeClassMethods.put(testClass, testClass);
                this.m_invoker.invokeConfigurations(testClass, testClass.getBeforeClassMethods(), this.m_suite, this.m_parameters, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeAfterClassMethods(ITestClass testClass, ITestNGMethod tm) {
        if (null == this.m_invokedAfterClassMethods || null == this.m_classMethodMap) {
            return;
        }
        ITestNGMethod[] afterClassMethods = testClass.getAfterClassMethods();
        if (null == afterClassMethods || afterClassMethods.length == 0) {
            return;
        }
        if (this.m_classMethodMap.removeAndCheckIfLast(tm)) {
            boolean invokeAfter = false;
            Map<ITestClass, ITestClass> map = this.m_invokedAfterClassMethods;
            synchronized (map) {
                if (!this.m_invokedAfterClassMethods.containsKey(testClass)) {
                    this.m_invokedAfterClassMethods.put(testClass, testClass);
                    invokeAfter = true;
                }
            }
            if (invokeAfter) {
                this.m_invoker.invokeConfigurations(testClass, afterClassMethods, this.m_suite, this.m_parameters, null);
            }
        }
    }

    protected int indexOf(ITestNGMethod tm, ITestNGMethod[] allTestMethods) {
        for (int i = 0; i < allTestMethods.length; ++i) {
            if (allTestMethods[i] != tm) continue;
            return i;
        }
        return -1;
    }

    public List<ITestResult> getTestResults() {
        return this.m_testResults;
    }

    private boolean isLastTestMethodForClass(ITestNGMethod tm, ITestNGMethod[] testMethods) {
        for (int i = testMethods.length - 1; i >= 0; --i) {
            ITestNGMethod thisMethod = testMethods[i];
            ITestClass testClass = tm.getTestClass();
            if (!thisMethod.getTestClass().equals(testClass)) continue;
            return thisMethod.equals(tm);
        }
        return false;
    }

    private void ppp(String s) {
        Utils.log("TestMethodWorker", 2, new StringBuffer().append(ThreadUtil.currentThreadInfo()).append(":").append(s).toString());
    }

    public void setAllTestMethods(ITestNGMethod[] allTestMethods) {
        this.m_allTestMethods = allTestMethods;
    }
}

