/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.contrib.server.session.proxyprotocolv2.data;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.contrib.server.session.proxyprotocolv2.data.FamilyAndTransport;
import org.apache.sshd.contrib.server.session.proxyprotocolv2.utils.ProxyUtils;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;

public final class AddressData {
    private final String srcAddress;
    private final String dstAddress;
    private final int srcPort;
    private final int dstPort;

    private AddressData(String srcAddress, String dstAddress, int srcPort, int dstPort) {
        this.srcAddress = srcAddress;
        this.dstAddress = dstAddress;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
    }

    public static AddressData extractAddressData(Logger logger, ServerSession session, Buffer buffer, FamilyAndTransport familyAndTransport, int dataLength) throws IOException {
        String srcAddress = AddressData.extractAddresses(buffer, familyAndTransport);
        String dstAddress = AddressData.extractAddresses(buffer, familyAndTransport);
        int srcPort = AddressData.extractPort(buffer, familyAndTransport);
        int dstPort = AddressData.extractPort(buffer, familyAndTransport);
        AddressData.skipUnprocessedData(logger, session, buffer, familyAndTransport, dataLength);
        return new AddressData(srcAddress, dstAddress, srcPort, dstPort);
    }

    public static void skipUnprocessedData(Logger logger, ServerSession session, Buffer buffer, FamilyAndTransport familyAndTransport, int dataLength) {
        int remaining = dataLength - familyAndTransport.getDataLength();
        if (remaining > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("extractAddressData({}) skipping additional datas [{}]", (Object)session, (Object)ProxyUtils.toHexString(buffer, buffer.rpos()));
            }
            buffer.ensureAvailable(remaining);
            buffer.rpos(buffer.rpos() + remaining);
        }
    }

    private static String extractAddresses(Buffer buffer, FamilyAndTransport familyAndTransport) throws IOException {
        byte[] datas = new byte[familyAndTransport.getAddressLength()];
        buffer.getRawBytes(datas);
        if (familyAndTransport.hasInetAddress()) {
            return InetAddress.getByAddress(datas).getHostAddress();
        }
        return "";
    }

    private static int extractPort(Buffer buffer, FamilyAndTransport familyAndTransport) {
        if (familyAndTransport.hasPort()) {
            return buffer.getUShort();
        }
        return 0;
    }

    public String toString() {
        return String.join((CharSequence)" ", this.srcAddress, this.dstAddress, Integer.toString(this.srcPort), Integer.toString(this.dstPort));
    }
}

