/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import org.apache.sshd.common.util.security.SecurityUtils;

public class OpenSSHECDSAPrivateKeyEntryDecoder
extends AbstractPrivateKeyEntryDecoder {
    public static final OpenSSHECDSAPrivateKeyEntryDecoder INSTANCE = new OpenSSHECDSAPrivateKeyEntryDecoder();

    public OpenSSHECDSAPrivateKeyEntryDecoder() {
        super(ECCurves.KEY_TYPES);
    }

    @Override
    public PrivateKey decodePrivateKey(SessionContext session, String keyType, FilePasswordProvider passwordProvider, InputStream keyData) throws IOException, GeneralSecurityException {
        String encCurveName;
        ECCurves curve = ECCurves.fromKeyType(keyType);
        if (curve == null) {
            throw new InvalidKeySpecException("Not an EC curve name: " + keyType);
        }
        String keyCurveName = curve.getName();
        if (!keyCurveName.equals(encCurveName = KeyEntryResolver.decodeString(keyData, 1024))) {
            throw new InvalidKeySpecException("Mismatched key curve name (" + keyCurveName + ") vs. encoded one (" + encCurveName + ")");
        }
        byte[] pubKey = KeyEntryResolver.readRLEBytes(keyData, Short.MAX_VALUE);
        Objects.requireNonNull(pubKey, "No public point");
        BigInteger s = KeyEntryResolver.decodeBigInt(keyData);
        ECParameterSpec params = curve.getParameters();
        return this.generatePrivateKey(new ECPrivateKeySpec(s, params));
    }

    @Override
    public String encodePrivateKey(SecureByteArrayOutputStream s, PrivateKey k, PublicKey pk) throws IOException {
        ECPrivateKey key = ValidateUtils.checkInstanceOf(k, ECPrivateKey.class, "Key must be an ECPrivateKey");
        ECPublicKey pubKey = ValidateUtils.checkInstanceOf(pk, ECPublicKey.class, "Key must be an ECPublicKey");
        ECCurves curve = ECCurves.fromECKey(key);
        if (curve == null) {
            return null;
        }
        String curveName = curve.getName();
        KeyEntryResolver.encodeString(s, curveName);
        ECCurves.ECPointCompression.UNCOMPRESSED.writeECPoint(s, curveName, pubKey.getW());
        KeyEntryResolver.encodeBigInt(s, key.getS());
        return curve.getKeyType();
    }

    @Override
    public PublicKey recoverPublicKey(PrivateKey key) throws GeneralSecurityException {
        ECPrivateKey prvKey = ValidateUtils.checkInstanceOf(key, ECPrivateKey.class, "Key must be an ECPrivateKey");
        ECCurves curve = ECCurves.fromECKey(prvKey);
        if (curve == null) {
            throw new InvalidKeyException("Unknown curve");
        }
        return super.recoverPublicKey(prvKey);
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("EC");
    }

    @Override
    public KeyPair generateKeyPair(int keySize) throws GeneralSecurityException {
        ECCurves curve = ECCurves.fromCurveSize(keySize);
        if (curve == null) {
            throw new InvalidKeySpecException("Unknown curve for key size=" + keySize);
        }
        KeyPairGenerator gen = this.getKeyPairGenerator();
        gen.initialize(curve.getParameters());
        return gen.generateKeyPair();
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("EC");
    }
}

