/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.filters.kex;

import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.util.buffer.BufferUtils;

class MessageCodingSettings {
    private final Cipher cipher;
    private final Mac mac;
    private final Compression compression;
    private final Cipher.Mode mode;
    private byte[] key;
    private byte[] iv;

    MessageCodingSettings(Cipher cipher, Mac mac, Compression compression, Cipher.Mode mode, byte[] key, byte[] iv) {
        this.cipher = cipher;
        this.mac = mac;
        this.compression = compression;
        this.mode = mode;
        this.key = (byte[])key.clone();
        this.iv = (byte[])iv.clone();
    }

    private void initCipher(long packetSequenceNumber) throws Exception {
        if (this.key != null) {
            if (this.cipher.getAlgorithm().startsWith("ChaCha")) {
                BufferUtils.putLong(packetSequenceNumber, this.iv, 0, this.iv.length);
            }
            this.cipher.init(this.mode, this.key, this.iv);
            this.key = null;
        }
    }

    Cipher getCipher(long packetSequenceNumber) throws Exception {
        this.initCipher(packetSequenceNumber);
        return this.cipher;
    }

    Mac getMac() {
        return this.mac;
    }

    Compression getCompression() {
        return this.compression;
    }
}

