/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import jakarta.faces.FacesException;
import jakarta.servlet.ServletContext;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.FacesInitializerImpl;

public class FacesInitializerFactory {
    public static FacesInitializer getFacesInitializer(ServletContext context) {
        FacesInitializer initializer = FacesInitializerFactory.getFacesInitializerFromInitParam(context);
        if (initializer == null) {
            initializer = new FacesInitializerImpl();
        }
        return initializer;
    }

    private static FacesInitializer getFacesInitializerFromInitParam(ServletContext context) {
        String initializerClassName = context.getInitParameter("org.apache.myfaces.FACES_INITIALIZER");
        if (initializerClassName != null) {
            try {
                Class clazz = ClassUtils.classForName(initializerClassName);
                if (!FacesInitializer.class.isAssignableFrom(clazz)) {
                    throw new FacesException("Class " + String.valueOf(clazz) + " does not implement FacesInitializer");
                }
                return (FacesInitializer)ClassUtils.newInstance(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                throw new FacesException("Could not find class of specified FacesInitializer", cnfe);
            }
        }
        return null;
    }
}

