/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUICollapsiblePanel;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class CollapsiblePanelRendererBase<T extends AbstractUICollapsiblePanel>
extends RendererBase<T> {
    private static final String SUFFIX_COLLAPSE = "collapse";

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        String newValue;
        super.decodeInternal(facesContext, component);
        String clientId = component.getClientId(facesContext);
        String hiddenId = clientId + "::collapse";
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(hiddenId) && StringUtils.isNotBlank(newValue = (String)requestParameterMap.get(hiddenId))) {
            ((AbstractUICollapsiblePanel)component).setSubmittedCollapsed(Boolean.valueOf(newValue));
        }
    }

    protected void encodeHidden(TobagoResponseWriter writer, String clientId, boolean collapsed) throws IOException {
        String hiddenId = clientId + "::collapse";
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeNameAttribute(hiddenId);
        writer.writeIdAttribute(hiddenId);
        writer.writeAttribute(HtmlAttributes.VALUE, Boolean.toString(collapsed), false);
        writer.endElement(HtmlElements.INPUT);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildrenInternal(FacesContext facesContext, T component) throws IOException {
        if (((AbstractUICollapsiblePanel)component).isNormalLifecycle()) {
            super.encodeChildrenInternal(facesContext, component);
        }
    }
}

