"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const sinon = __importStar(require("sinon"));
const AjaxImpl_1 = require("../../impl/AjaxImpl");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
var defaultMyFaces = StandardInits_1.StandardInits.defaultMyFaces;
const mona_dish_1 = require("mona-dish");
const chai_1 = require("chai");
(0, mocha_1.describe)('Tests for the MyFaces specifig oam submit', function () {
    let oldFlatMap = null;
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = defaultMyFaces();
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.jsfAjaxResponse = sinon.spy(global.faces.ajax, "response");
                oldFlatMap = Array.prototype["flatMap"];
                window["Es2019Array"] = mona_dish_1._Es2019Array;
                delete Array.prototype["flatMap"];
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    this.jsfAjaxResponse.restore();
                    AjaxImpl_1.Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
        if (oldFlatMap) {
            Array.prototype["flatMap"] = oldFlatMap;
            oldFlatMap = null;
        }
    });
    it(("must handle oam submit correctly, tuples"), (done) => {
        let options = [["booga1", "value1"], ["booga2", "value2"]];
        mona_dish_1.DQ.byId("blarg")
            .getAsElem(0).value.onsubmit = (evt) => {
            (0, chai_1.expect)((0, mona_dish_1.DQ$)("#blarg #booga1").inputValue.value).to.eq("value1");
            (0, chai_1.expect)((0, mona_dish_1.DQ$)("#blarg #booga2").inputValue.value).to.eq("value2");
            done();
            return false;
        };
        myfaces.oam.submitForm("blarg", null, null, options);
    });
    it(("must handle oam submit correctly, associative array"), (done) => {
        let options = { "booga1": "value1", "booga2": "value2" };
        mona_dish_1.DQ.byId("blarg")
            .getAsElem(0).value.onsubmit = (evt) => {
            (0, chai_1.expect)((0, mona_dish_1.DQ$)("#blarg #booga1").inputValue.value).to.eq("value1");
            (0, chai_1.expect)((0, mona_dish_1.DQ$)("#blarg #booga2").inputValue.value).to.eq("value2");
            done();
            return false;
        };
        myfaces.oam.submitForm("blarg", null, null, options);
    });
    it(("all hidden inputs must be cleared post submit"), (done) => {
        let options = { "booga1": "value1", "booga2": "value2" };
        mona_dish_1.DQ.byId("blarg")
            .getAsElem(0).value.onsubmit = (evt) => {
            (0, chai_1.expect)((0, mona_dish_1.DQ$)("#blarg #booga1").length).to.eq(1);
            (0, chai_1.expect)((0, mona_dish_1.DQ$)("#blarg #booga2").length).to.eq(1);
            return false;
        };
        myfaces.oam.submitForm("blarg", null, null, options);
        (0, chai_1.expect)((0, mona_dish_1.DQ$)("#blarg #booga1").length).to.eq(0);
        (0, chai_1.expect)((0, mona_dish_1.DQ$)("#blarg #booga2").length).to.eq(0);
        done();
    });
    it(("must handle linkid correctly, associative array"), (done) => {
        let options = { "booga1": "value1", "booga2": "value2" };
        mona_dish_1.DQ.byId("blarg")
            .getAsElem(0).value.onsubmit = (evt) => {
            (0, chai_1.expect)(mona_dish_1.DQ.byId(`blarg:_idcl`).inputValue.value).to.eq("bla");
            done();
            return false;
        };
        myfaces.oam.submitForm("blarg", "bla", null, options);
    });
    it(("must handle target correctly, associative array"), (done) => {
        let options = { "booga1": "value1", "booga2": "value2" };
        mona_dish_1.DQ.byId("blarg")
            .getAsElem(0).value.onsubmit = (evt) => {
            (0, chai_1.expect)((0, mona_dish_1.DQ$)(`#blarg`).attr("target").value).to.eq("target1");
            done();
            return false;
        };
        myfaces.oam.submitForm("blarg", "bla", "target1", options);
    });
    it(("must handle limited parameters"), (done) => {
        mona_dish_1.DQ.byId("blarg")
            .getAsElem(0).value.onsubmit = (evt) => {
            (0, chai_1.expect)(mona_dish_1.DQ.byId(`blarg:_idcl`).inputValue.value).to.eq("bla");
            done();
            return false;
        };
        try {
            myfaces.oam.submitForm("blarg", "bla");
        }
        catch (e) {
            done(e);
        }
    });
    it(("must handle limited parameters 2"), (done) => {
        mona_dish_1.DQ.byId("blarg")
            .getAsElem(0).value.onsubmit = (evt) => {
            (0, chai_1.expect)(mona_dish_1.DQ.byId(`blarg:_idcl`).inputValue.value).to.eq("bla");
            done();
            return false;
        };
        try {
            myfaces.oam.submitForm("blarg", "bla", null);
        }
        catch (e) {
            done(e);
        }
    });
    it(("must handle limited parameters 3"), (done) => {
        mona_dish_1.DQ.byId("blarg")
            .getAsElem(0).value.onsubmit = (evt) => {
            (0, chai_1.expect)(mona_dish_1.DQ.byId(`blarg:_idcl`).inputValue.value).to.eq("bla");
            done();
            return false;
        };
        try {
            myfaces.oam.submitForm("blarg", "bla", null, null);
        }
        catch (e) {
            done(e);
        }
    });
});
//# sourceMappingURL=OamSubmitTest.spec.js.map