/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.bundle;

public class BundleVersionFilterParams {
    private static final BundleVersionFilterParams EMPTY_PARAMS = new Builder().build();
    private final String groupId;
    private final String artifactId;
    private final String version;

    private BundleVersionFilterParams(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public static BundleVersionFilterParams of(String groupId, String artifactId, String version) {
        return new Builder().group(groupId).artifact(artifactId).version(version).build();
    }

    public static BundleVersionFilterParams empty() {
        return EMPTY_PARAMS;
    }

    public static class Builder {
        private String groupId;
        private String artifactId;
        private String version;

        public Builder group(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder artifact(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public BundleVersionFilterParams build() {
            return new BundleVersionFilterParams(this);
        }
    }
}

