/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import java.time.Instant;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public record TaskExecutionOutcome(@Nullable Instant executionTime, Status status, @Nullable Throwable throwable) {
    TaskExecutionOutcome start(Instant executionTime) {
        return new TaskExecutionOutcome(executionTime, Status.STARTED, null);
    }

    TaskExecutionOutcome success() {
        Assert.state((this.executionTime != null ? 1 : 0) != 0, (String)"Task has not been started yet");
        return new TaskExecutionOutcome(this.executionTime, Status.SUCCESS, null);
    }

    TaskExecutionOutcome failure(Throwable throwable) {
        Assert.state((this.executionTime != null ? 1 : 0) != 0, (String)"Task has not been started yet");
        return new TaskExecutionOutcome(this.executionTime, Status.ERROR, throwable);
    }

    static TaskExecutionOutcome create() {
        return new TaskExecutionOutcome(null, Status.NONE, null);
    }

    public static enum Status {
        NONE,
        STARTED,
        SUCCESS,
        ERROR;

    }
}

