/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.geoip;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.WebServiceClient;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.indexer.geoip.GeoIPDocumentCreator;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIPIndexingFilter
implements IndexingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Configuration conf;
    private String usage = null;
    WebServiceClient client = null;
    DatabaseReader reader = null;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.usage = conf.get("index.geoip.usage", "insightsService");
        LOG.debug("GeoIP usage medium set to: {}", (Object)this.usage);
        if (this.usage.equalsIgnoreCase("insightsService")) {
            this.client = new WebServiceClient.Builder(conf.getInt("index.geoip.userid", 12345), conf.get("index.geoip.licensekey")).build();
        } else {
            String[] dbPrefixes;
            String dbSuffix = null;
            if (this.usage.equalsIgnoreCase("cityDatabase")) {
                dbSuffix = "-City.mmdb";
            } else if (this.usage.equalsIgnoreCase("connectionTypeDatabase")) {
                dbSuffix = "-Connection-Type.mmdb";
            } else if (this.usage.equalsIgnoreCase("domainDatabase")) {
                dbSuffix = "-Domain.mmdb";
            } else if (this.usage.equalsIgnoreCase("ispDatabase")) {
                dbSuffix = "-ISP.mmdb";
            }
            for (String dbPrefix : dbPrefixes = new String[]{"GeoIP2", "GeoLite2"}) {
                String db = dbPrefix + dbSuffix;
                URL dbFileUrl = conf.getResource(db);
                if (dbFileUrl == null) {
                    LOG.error("GeoDb file {} not found on classpath", (Object)db);
                    continue;
                }
                try {
                    LOG.info("Reading GeoDb file {}", (Object)db);
                    this.buildDb(new File(dbFileUrl.getFile()));
                }
                catch (Exception e) {
                    LOG.error("Failed to read geoDb file {}: ", (Object)db, (Object)e);
                }
            }
        }
        if (!conf.getBoolean("store.ip.address", false)) {
            LOG.warn("Plugin index-geoip is active but IP address is not stored(store.ip.address == false)");
        }
    }

    private void buildDb(File geoDb) {
        try {
            this.reader = new DatabaseReader.Builder(geoDb).build();
        }
        catch (IOException e) {
            LOG.error("Failed to build geoDb:", (Throwable)e);
        }
    }

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        return this.addServerGeo(doc, parse.getData(), url.toString());
    }

    private NutchDocument addServerGeo(NutchDocument doc, ParseData data, String url) {
        String serverIp = data.getContentMeta().get("_ip_");
        if (serverIp != null && this.reader != null) {
            try {
                if (this.usage.equalsIgnoreCase("cityDatabase")) {
                    doc = GeoIPDocumentCreator.createDocFromCityDb(serverIp, doc, this.reader);
                } else if (this.usage.equalsIgnoreCase("connectionTypeDatabase")) {
                    doc = GeoIPDocumentCreator.createDocFromConnectionDb(serverIp, doc, this.reader);
                } else if (this.usage.equalsIgnoreCase("domainDatabase")) {
                    doc = GeoIPDocumentCreator.createDocFromDomainDb(serverIp, doc, this.reader);
                } else if (this.usage.equalsIgnoreCase("ispDatabase")) {
                    doc = GeoIPDocumentCreator.createDocFromIspDb(serverIp, doc, this.reader);
                } else if (this.usage.equalsIgnoreCase("insightsService")) {
                    doc = GeoIPDocumentCreator.createDocFromInsightsService(serverIp, doc, this.client);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to determine geoip:", (Throwable)e);
            }
        }
        return doc;
    }
}

