/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opensearch.common.Nullable;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.search.lookup.SourceLookup;

public abstract class SourceValueFetcher
implements ValueFetcher {
    private final Set<String> sourcePaths;
    @Nullable
    private final Object nullValue;

    public SourceValueFetcher(String fieldName, MapperService mapperService) {
        this(fieldName, mapperService, null);
    }

    public SourceValueFetcher(String fieldName, MapperService mapperService, Object nullValue) {
        this.sourcePaths = mapperService.sourcePath(fieldName);
        this.nullValue = nullValue;
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String path : this.sourcePaths) {
            Object sourceValue = lookup.extractValue(path, this.nullValue);
            if (sourceValue == null) {
                return org.opensearch.common.collect.List.of();
            }
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            queue.add(sourceValue);
            while (!queue.isEmpty()) {
                Object value = queue.poll();
                if (value instanceof List) {
                    queue.addAll((List)value);
                    continue;
                }
                Object parsedValue = this.parseSourceValue(value);
                if (parsedValue == null) continue;
                values.add(parsedValue);
            }
        }
        return values;
    }

    protected abstract Object parseSourceValue(Object var1);

    public static SourceValueFetcher identity(String fieldName, MapperService mapperService, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + fieldName + "] doesn't support formats.");
        }
        return new SourceValueFetcher(fieldName, mapperService){

            @Override
            protected Object parseSourceValue(Object value) {
                return value;
            }
        };
    }

    public static SourceValueFetcher toString(String fieldName, MapperService mapperService, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + fieldName + "] doesn't support formats.");
        }
        return new SourceValueFetcher(fieldName, mapperService){

            @Override
            protected Object parseSourceValue(Object value) {
                return value.toString();
            }
        };
    }
}

