/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.tools.ConsoleProducer$;
import kafka.tools.ConsoleProducer$LineMessageReader$;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.api.RecordReader;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\rMv!B;w\u0011\u0003Yh!B?w\u0011\u0003q\bbBA\f\u0003\u0011\u0005\u0011\u0011\u0004\u0005\t\u00037\tA\u0011\u0001<\u0002\u001e!A\u0011QM\u0001\u0005\u0002Y\f9\u0007C\u0004\u0002,\u0006!\t!!,\t\u000f\u0005U\u0016\u0001\"\u0003\u00028\"9\u0011qY\u0001\u0005\u0002\u0005%\u0007b\u0002B]\u0003\u0011\u0005!1\u0018\u0004\u0007\u0003'\f\u0001!!6\t\u0015\u0005E\u0016B!A!\u0002\u0013\t\u0019\fC\u0004\u0002\u0018%!\t!!:\t\u0013\u0005%\u0018B1A\u0005\u0002\u0005-\b\u0002CA}\u0013\u0001\u0006I!!<\t\u0013\u0005m\u0018B1A\u0005\u0002\u0005-\b\u0002CA\u007f\u0013\u0001\u0006I!!<\t\u0013\u0005}\u0018B1A\u0005\u0002\u0005-\b\u0002\u0003B\u0001\u0013\u0001\u0006I!!<\t\u0013\t\r\u0011B1A\u0005\u0002\t\u0015\u0001\u0002\u0003B\u0007\u0013\u0001\u0006IAa\u0002\t\u0013\t=\u0011B1A\u0005\u0002\u0005-\b\u0002\u0003B\t\u0013\u0001\u0006I!!<\t\u0013\tM\u0011B1A\u0005\u0002\tU\u0001\u0002\u0003B\u0013\u0013\u0001\u0006IAa\u0006\t\u0013\t\u001d\u0012B1A\u0005\u0002\tU\u0001\u0002\u0003B\u0015\u0013\u0001\u0006IAa\u0006\t\u0013\t-\u0012B1A\u0005\u0002\t5\u0002\u0002\u0003B\u001c\u0013\u0001\u0006IAa\f\t\u0013\te\u0012B1A\u0005\u0002\t5\u0002\u0002\u0003B\u001e\u0013\u0001\u0006IAa\f\t\u0013\tu\u0012B1A\u0005\u0002\t}\u0002\u0002\u0003B$\u0013\u0001\u0006IA!\u0011\t\u0013\t%\u0013B1A\u0005\u0002\tU\u0001\u0002\u0003B&\u0013\u0001\u0006IAa\u0006\t\u0013\t5\u0013B1A\u0005\u0002\t5\u0002\u0002\u0003B(\u0013\u0001\u0006IAa\f\t\u0013\tE\u0013B1A\u0005\u0002\t5\u0002\u0002\u0003B*\u0013\u0001\u0006IAa\f\t\u0013\tU\u0013B1A\u0005\u0002\t5\u0002\u0002\u0003B,\u0013\u0001\u0006IAa\f\t\u0013\te\u0013B1A\u0005\u0002\tU\u0001\u0002\u0003B.\u0013\u0001\u0006IAa\u0006\t\u0013\tu\u0013B1A\u0005\u0002\t}\u0002\u0002\u0003B0\u0013\u0001\u0006IA!\u0011\t\u0013\t\u0005\u0014B1A\u0005\u0002\tU\u0001\u0002\u0003B2\u0013\u0001\u0006IAa\u0006\t\u0013\t\u0015\u0014B1A\u0005\u0002\u0005-\b\u0002\u0003B4\u0013\u0001\u0006I!!<\t\u0013\t%\u0014B1A\u0005\u0002\u0005-\b\u0002\u0003B6\u0013\u0001\u0006I!!<\t\u0013\t5\u0014B1A\u0005\u0002\u0005-\b\u0002\u0003B8\u0013\u0001\u0006I!!<\t\u0013\tE\u0014B1A\u0005\u0002\u0005-\b\u0002\u0003B:\u0013\u0001\u0006I!!<\t\u0013\tU\u0014B1A\u0005\u0002\t]\u0004\u0002\u0003B=\u0013\u0001\u0006I!a\u000f\t\u0013\tm\u0014B1A\u0005\u0002\t]\u0004\u0002\u0003B?\u0013\u0001\u0006I!a\u000f\t\u0013\t}\u0014B1A\u0005\u0002\t]\u0004\u0002\u0003BA\u0013\u0001\u0006I!a\u000f\t\u0013\t\r\u0015B1A\u0005\u0002\t]\u0004\u0002\u0003BC\u0013\u0001\u0006I!a\u000f\t\u0013\u0005\r\u0016B1A\u0005\u0002\t\u001d\u0005\u0002\u0003BE\u0013\u0001\u0006I!!*\t\u0013\t-\u0015B1A\u0005\u0002\t]\u0004\u0002\u0003BG\u0013\u0001\u0006I!a\u000f\t\u0013\t=\u0015B1A\u0005\u0002\tE\u0005\u0002\u0003BJ\u0013\u0001\u0006IAa\u0011\t\u0013\tU\u0015B1A\u0005\u0002\tE\u0005\u0002\u0003BL\u0013\u0001\u0006IAa\u0011\t\u0013\te\u0015B1A\u0005\u0002\tm\u0005\u0002\u0003BO\u0013\u0001\u0006I!!\u0016\t\u0013\t}\u0015B1A\u0005\u0002\tm\u0005\u0002\u0003BQ\u0013\u0001\u0006I!!\u0016\t\u000f\t\r\u0016\u0002\"\u0001\u0003&\u001a1!qX\u0001\u0001\u0005\u0003Dq!a\u0006L\t\u0003\u0011I\rC\u0006\u0003v-\u0003\r\u00111A\u0005\u0002\t]\u0004b\u0003Bg\u0017\u0002\u0007\t\u0019!C\u0001\u0005\u001fD1B!\u001fL\u0001\u0004\u0005\t\u0015)\u0003\u0002<!I!Q[&A\u0002\u0013\u0005!q\u0011\u0005\n\u0005/\\\u0005\u0019!C\u0001\u00053D\u0001B!8LA\u0003&\u0011Q\u0015\u0005\n\u0005?\\\u0005\u0019!C\u0001\u0005#C\u0011B!9L\u0001\u0004%\tAa9\t\u0011\t\u001d8\n)Q\u0005\u0005\u0007B\u0011B!;L\u0001\u0004%\tAa\"\t\u0013\t-8\n1A\u0005\u0002\t5\b\u0002\u0003By\u0017\u0002\u0006K!!*\t\u0013\tM8\n1A\u0005\u0002\tE\u0005\"\u0003B{\u0017\u0002\u0007I\u0011\u0001B|\u0011!\u0011Yp\u0013Q!\n\t\r\u0003\"\u0003B\u007f\u0017\u0002\u0007I\u0011\u0001BI\u0011%\u0011yp\u0013a\u0001\n\u0003\u0019\t\u0001\u0003\u0005\u0004\u0006-\u0003\u000b\u0015\u0002B\"\u0011%\u00199a\u0013a\u0001\n\u0003\u0011\t\nC\u0005\u0004\n-\u0003\r\u0011\"\u0001\u0004\f!A1qB&!B\u0013\u0011\u0019\u0005C\u0005\u0004\u0012-\u0003\r\u0011\"\u0001\u0003\b\"I11C&A\u0002\u0013\u00051Q\u0003\u0005\t\u00073Y\u0005\u0015)\u0003\u0002&\"I11D&A\u0002\u0013\u00051Q\u0004\u0005\n\u0007KY\u0005\u0019!C\u0001\u0007OA\u0001ba\u000bLA\u0003&1q\u0004\u0005\n\u0007[Y\u0005\u0019!C\u0001\u0005\u000fC\u0011ba\fL\u0001\u0004%\ta!\r\t\u0011\rU2\n)Q\u0005\u0003KC1ba\u000eL\u0001\u0004\u0005\r\u0011\"\u0001\u0004:!Y1qI&A\u0002\u0003\u0007I\u0011AB%\u0011-\u0019ie\u0013a\u0001\u0002\u0003\u0006Kaa\u000f\t\u0017\r=3\n1AA\u0002\u0013\u0005!q\u000f\u0005\f\u0007#Z\u0005\u0019!a\u0001\n\u0003\u0019\u0019\u0006C\u0006\u0004X-\u0003\r\u0011!Q!\n\u0005m\u0002bBB-\u0017\u0012\u000531\f\u0005\b\u0007\u007fZE\u0011IBA\u0011\u001d\u0019Yi\u0013C\u0005\u0007\u001bCqaa)L\t\u0013\u0019)+A\bD_:\u001cx\u000e\\3Qe>$WoY3s\u0015\t9\b0A\u0003u_>d7OC\u0001z\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001`\u0001\u000e\u0003Y\u0014qbQ8og>dW\r\u0015:pIV\u001cWM]\n\u0005\u0003}\fY\u0001\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\t\t)!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\n\u0005\r!AB!osJ+g\r\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002_\u0001\u0006kRLGn]\u0005\u0005\u0003+\tyAA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Y\u0018!\u00038foJ+\u0017\rZ3s)\u0019\ty\"a\u000e\u0002RA!\u0011\u0011EA\u001a\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012aA1qS*\u0019q/!\u000b\u000b\u0007e\fYC\u0003\u0003\u0002.\u0005=\u0012AB1qC\u000eDWM\u0003\u0002\u00022\u0005\u0019qN]4\n\t\u0005U\u00121\u0005\u0002\r%\u0016\u001cwN\u001d3SK\u0006$WM\u001d\u0005\b\u0003s\u0019\u0001\u0019AA\u001e\u0003%\u0019G.Y:t\u001d\u0006lW\r\u0005\u0003\u0002>\u0005-c\u0002BA \u0003\u000f\u0002B!!\u0011\u0002\u00045\u0011\u00111\t\u0006\u0004\u0003\u000bR\u0018A\u0002\u001fs_>$h(\u0003\u0003\u0002J\u0005\r\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002N\u0005=#AB*ue&twM\u0003\u0003\u0002J\u0005\r\u0001bBA*\u0007\u0001\u0007\u0011QK\u0001\u0005aJ|\u0007\u000f\u0005\u0003\u0002X\u0005\u0005TBAA-\u0015\u0011\tY&!\u0018\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003?\nAA[1wC&!\u00111MA-\u0005)\u0001&o\u001c9feRLWm]\u0001\u000bY>|\u0007OU3bI\u0016\u0014HCCA5\u0003_\ni)!%\u0002\"B!\u0011\u0011AA6\u0013\u0011\ti'a\u0001\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003c\"\u0001\u0019AA:\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003CA;\u0003{\n\t)!!\u000e\u0005\u0005]$\u0002BA9\u0003sRA!a\u001f\u0002*\u000591\r\\5f]R\u001c\u0018\u0002BA@\u0003o\u0012\u0001\u0002\u0015:pIV\u001cWM\u001d\t\u0007\u0003\u0003\t\u0019)a\"\n\t\u0005\u0015\u00151\u0001\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u0003\tI)\u0003\u0003\u0002\f\u0006\r!\u0001\u0002\"zi\u0016Dq!a$\u0005\u0001\u0004\ty\"\u0001\u0004sK\u0006$WM\u001d\u0005\b\u0003'#\u0001\u0019AAK\u0003-Ig\u000e];u'R\u0014X-Y7\u0011\t\u0005]\u0015QT\u0007\u0003\u00033SA!a'\u0002^\u0005\u0011\u0011n\\\u0005\u0005\u0003?\u000bIJA\u0006J]B,Ho\u0015;sK\u0006l\u0007bBAR\t\u0001\u0007\u0011QU\u0001\u0005gft7\r\u0005\u0003\u0002\u0002\u0005\u001d\u0016\u0002BAU\u0003\u0007\u0011qAQ8pY\u0016\fg.\u0001\u0003nC&tG\u0003BA5\u0003_Cq!!-\u0006\u0001\u0004\t\u0019,\u0001\u0003be\u001e\u001c\bCBA\u0001\u0003\u0007\u000bY$\u0001\u0003tK:$G\u0003CA5\u0003s\u000bY,!2\t\u000f\u0005Ed\u00011\u0001\u0002t!9\u0011Q\u0018\u0004A\u0002\u0005}\u0016A\u0002:fG>\u0014H\r\u0005\u0005\u0002v\u0005\u0005\u0017\u0011QAA\u0013\u0011\t\u0019-a\u001e\u0003\u001dA\u0013x\u000eZ;dKJ\u0014VmY8sI\"9\u00111\u0015\u0004A\u0002\u0005\u0015\u0016AD4fiJ+\u0017\rZ3s!J|\u0007o\u001d\u000b\u0005\u0003+\nY\rC\u0004\u0002N\u001e\u0001\r!a4\u0002\r\r|gNZ5h!\r\t\t.C\u0007\u0002\u0003\tq\u0001K]8ek\u000e,'oQ8oM&<7cA\u0005\u0002XB!\u0011\u0011\\Aq\u001b\t\tYN\u0003\u0003\u0002\\\u0005u'\u0002BAp\u0003S\taa]3sm\u0016\u0014\u0018\u0002BAr\u00037\u0014QcQ8n[\u0006tG\rR3gCVdGo\u00149uS>t7\u000f\u0006\u0003\u0002P\u0006\u001d\bbBAY\u0017\u0001\u0007\u00111W\u0001\ti>\u0004\u0018nY(qiV\u0011\u0011Q\u001e\t\u0007\u0003_\f)0a\u000f\u000e\u0005\u0005E(BAAz\u0003)Qw\u000e\u001d;tS6\u0004H.Z\u0005\u0005\u0003o\f\tPA\u000eBe\u001e,X.\u001a8u\u0003\u000e\u001cW\r\u001d;j]\u001e|\u0005\u000f^5p]N\u0003XmY\u0001\ni>\u0004\u0018nY(qi\u0002\nQB\u0019:pW\u0016\u0014H*[:u\u001fB$\u0018A\u00042s_.,'\u000fT5ti>\u0003H\u000fI\u0001\u0013E>|Go\u001d;sCB\u001cVM\u001d<fe>\u0003H/A\nc_>$8\u000f\u001e:baN+'O^3s\u001fB$\b%A\u0004ts:\u001cw\n\u001d;\u0016\u0005\t\u001d\u0001\u0003BAx\u0005\u0013IAAa\u0003\u0002r\n\tr\n\u001d;j_:\u001c\u0006/Z2Ck&dG-\u001a:\u0002\u0011MLhnY(qi\u0002\n1cY8naJ,7o]5p]\u000e{G-Z2PaR\fAcY8naJ,7o]5p]\u000e{G-Z2PaR\u0004\u0013\u0001\u00042bi\u000eD7+\u001b>f\u001fB$XC\u0001B\f!\u0019\ty/!>\u0003\u001aA!!1\u0004B\u0011\u001b\t\u0011iB\u0003\u0003\u0003 \u0005u\u0013\u0001\u00027b]\u001eLAAa\t\u0003\u001e\t9\u0011J\u001c;fO\u0016\u0014\u0018!\u00042bi\u000eD7+\u001b>f\u001fB$\b%\u0001\rnKN\u001c\u0018mZ3TK:$W*\u0019=SKR\u0014\u0018.Z:PaR\f\u0011$\\3tg\u0006<WmU3oI6\u000b\u0007PU3ue&,7o\u00149uA\u0005\t\"/\u001a;ss\n\u000b7m[8gM6\u001bx\n\u001d;\u0016\u0005\t=\u0002CBAx\u0003k\u0014\t\u0004\u0005\u0003\u0003\u001c\tM\u0012\u0002\u0002B\u001b\u0005;\u0011A\u0001T8oO\u0006\u0011\"/\u001a;ss\n\u000b7m[8gM6\u001bx\n\u001d;!\u00039\u0019XM\u001c3US6,w.\u001e;PaR\fqb]3oIRKW.Z8vi>\u0003H\u000fI\u0001\u0017e\u0016\fX/Z:u%\u0016\fX/\u001b:fI\u0006\u001b7n](qiV\u0011!\u0011\t\t\u0007\u0003_\f)Pa\u0011\u0011\t\tm!QI\u0005\u0005\u0003\u001b\u0012i\"A\fsKF,Xm\u001d;SKF,\u0018N]3e\u0003\u000e\\7o\u00149uA\u0005\u0019\"/Z9vKN$H+[7f_V$Xj](qi\u0006!\"/Z9vKN$H+[7f_V$Xj](qi\u0002\n1#\\3uC\u0012\fG/Y#ya&\u0014\u00180T:PaR\fA#\\3uC\u0012\fG/Y#ya&\u0014\u00180T:PaR\u0004\u0013!D7bq\ncwnY6Ng>\u0003H/\u0001\bnCb\u0014En\\2l\u001bN|\u0005\u000f\u001e\u0011\u0002#5\f\u00070T3n_JL()\u001f;fg>\u0003H/\u0001\nnCblU-\\8ss\nKH/Z:PaR\u0004\u0013AG7bqB\u000b'\u000f^5uS>tW*Z7pef\u0014\u0015\u0010^3t\u001fB$\u0018aG7bqB\u000b'\u000f^5uS>tW*Z7pef\u0014\u0015\u0010^3t\u001fB$\b%\u0001\tnKN\u001c\u0018mZ3SK\u0006$WM](qi\u0006\tR.Z:tC\u001e,'+Z1eKJ|\u0005\u000f\u001e\u0011\u0002'M|7m[3u\u0005V4g-\u001a:TSj,w\n\u001d;\u0002)M|7m[3u\u0005V4g-\u001a:TSj,w\n\u001d;!\u0003-\u0001(o\u001c9feRLx\n\u001d;\u0002\u0019A\u0014x\u000e]3sif|\u0005\u000f\u001e\u0011\u0002\u001fI,\u0017\rZ3s\u0007>tg-[4PaR\f\u0001C]3bI\u0016\u00148i\u001c8gS\u001e|\u0005\u000f\u001e\u0011\u0002'A\u0014x\u000eZ;dKJ\u0004&o\u001c9feRLx\n\u001d;\u0002)A\u0014x\u000eZ;dKJ\u0004&o\u001c9feRLx\n\u001d;!\u0003E\u0001(o\u001c3vG\u0016\u00148i\u001c8gS\u001e|\u0005\u000f^\u0001\u0013aJ|G-^2fe\u000e{gNZ5h\u001fB$\b%A\u0003u_BL7-\u0006\u0002\u0002<\u00051Ao\u001c9jG\u0002\nqBY8piN$(/\u00199TKJ4XM]\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<fe\u0002\n!B\u0019:pW\u0016\u0014H*[:u\u0003-\u0011'o\\6fe2K7\u000f\u001e\u0011\u0002'\t\u0014xn[3s\u0011>\u001cHo]!oIB{'\u000f^:\u0002)\t\u0014xn[3s\u0011>\u001cHo]!oIB{'\u000f^:!+\t\t)+A\u0003ts:\u001c\u0007%A\u000ed_6\u0004(/Z:tS>t7i\u001c3fG>\u0003H/[8o-\u0006dW/Z\u0001\u001dG>l\u0007O]3tg&|gnQ8eK\u000e|\u0005\u000f^5p]Z\u000bG.^3!\u0003A\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7-\u0006\u0002\u0003D\u0005\t2m\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0011\u0002\u0017I,\u0017\rZ3s\u00072\f7o]\u0001\re\u0016\fG-\u001a:DY\u0006\u001c8\u000fI\u0001\rG6$G*\u001b8f!J|\u0007o]\u000b\u0003\u0003+\nQbY7e\u0019&tW\r\u0015:paN\u0004\u0013AE3yiJ\f\u0007K]8ek\u000e,'\u000f\u0015:paN\f1#\u001a=ue\u0006\u0004&o\u001c3vG\u0016\u0014\bK]8qg\u0002\n\u0001\u0002\u001e:z!\u0006\u00148/\u001a\u000b\u0007\u0005O\u0013iKa.\u0011\t\u0005=(\u0011V\u0005\u0005\u0005W\u000b\tPA\u0005PaRLwN\\*fi\"9!q\u0016&A\u0002\tE\u0016A\u00029beN,'\u000f\u0005\u0003\u0002p\nM\u0016\u0002\u0002B[\u0003c\u0014Ab\u00149uS>t\u0007+\u0019:tKJDq!!-K\u0001\u0004\t\u0019,A\u0007qe>$WoY3s!J|\u0007o\u001d\u000b\u0005\u0003+\u0012i\fC\u0004\u0002N\"\u0001\r!a4\u0003#1Kg.Z'fgN\fw-\u001a*fC\u0012,'oE\u0003L\u0005\u0007\fy\u0002\u0005\u0003\u0003\u001c\t\u0015\u0017\u0002\u0002Bd\u0005;\u0011aa\u00142kK\u000e$HC\u0001Bf!\r\t\tnS\u0001\ni>\u0004\u0018nY0%KF$B!!\u001b\u0003R\"I!1\u001b(\u0002\u0002\u0003\u0007\u00111H\u0001\u0004q\u0012\n\u0014\u0001\u00039beN,7*Z=\u0002\u0019A\f'o]3LKf|F%Z9\u0015\t\u0005%$1\u001c\u0005\n\u0005'\f\u0016\u0011!a\u0001\u0003K\u000b\u0011\u0002]1sg\u0016\\U-\u001f\u0011\u0002\u0019-,\u0017pU3qCJ\fGo\u001c:\u0002!-,\u0017pU3qCJ\fGo\u001c:`I\u0015\fH\u0003BA5\u0005KD\u0011Ba5U\u0003\u0003\u0005\rAa\u0011\u0002\u001b-,\u0017pU3qCJ\fGo\u001c:!\u00031\u0001\u0018M]:f\u0011\u0016\fG-\u001a:t\u0003A\u0001\u0018M]:f\u0011\u0016\fG-\u001a:t?\u0012*\u0017\u000f\u0006\u0003\u0002j\t=\b\"\u0003Bj/\u0006\u0005\t\u0019AAS\u00035\u0001\u0018M]:f\u0011\u0016\fG-\u001a:tA\u0005\u0001\u0002.Z1eKJ\u001cH)\u001a7j[&$XM]\u0001\u0015Q\u0016\fG-\u001a:t\t\u0016d\u0017.\\5uKJ|F%Z9\u0015\t\u0005%$\u0011 \u0005\n\u0005'T\u0016\u0011!a\u0001\u0005\u0007\n\u0011\u0003[3bI\u0016\u00148\u000fR3mS6LG/\u001a:!\u0003AAW-\u00193feN\u001cV\r]1sCR|'/\u0001\u000biK\u0006$WM]:TKB\f'/\u0019;pe~#S-\u001d\u000b\u0005\u0003S\u001a\u0019\u0001C\u0005\u0003Tv\u000b\t\u00111\u0001\u0003D\u0005\t\u0002.Z1eKJ\u001c8+\u001a9be\u0006$xN\u001d\u0011\u0002'!,\u0017\rZ3sg.+\u0017pU3qCJ\fGo\u001c:\u0002/!,\u0017\rZ3sg.+\u0017pU3qCJ\fGo\u001c:`I\u0015\fH\u0003BA5\u0007\u001bA\u0011Ba5a\u0003\u0003\u0005\rAa\u0011\u0002)!,\u0017\rZ3sg.+\u0017pU3qCJ\fGo\u001c:!\u0003-IwM\\8sK\u0016\u0013(o\u001c:\u0002\u001f%<gn\u001c:f\u000bJ\u0014xN]0%KF$B!!\u001b\u0004\u0018!I!1[2\u0002\u0002\u0003\u0007\u0011QU\u0001\rS\u001etwN]3FeJ|'\u000fI\u0001\u000bY&tWMT;nE\u0016\u0014XCAB\u0010!\u0011\t\ta!\t\n\t\r\r\u00121\u0001\u0002\u0004\u0013:$\u0018A\u00047j]\u0016tU/\u001c2fe~#S-\u001d\u000b\u0005\u0003S\u001aI\u0003C\u0005\u0003T\u001a\f\t\u00111\u0001\u0004 \u0005YA.\u001b8f\u001dVl'-\u001a:!\u0003-\u0001(/\u001b8u!J|W\u000e\u001d;\u0002\u001fA\u0014\u0018N\u001c;Qe>l\u0007\u000f^0%KF$B!!\u001b\u00044!I!1[5\u0002\u0002\u0003\u0007\u0011QU\u0001\raJLg\u000e\u001e)s_6\u0004H\u000fI\u0001\u0018Q\u0016\fG-\u001a:t'\u0016\u0004\u0018M]1u_J\u0004\u0016\r\u001e;fe:,\"aa\u000f\u0011\t\ru21I\u0007\u0003\u0007\u007fQAa!\u0011\u0002Z\u0005)!/Z4fq&!1QIB \u0005\u001d\u0001\u0016\r\u001e;fe:\f1\u0004[3bI\u0016\u00148oU3qCJ\fGo\u001c:QCR$XM\u001d8`I\u0015\fH\u0003BA5\u0007\u0017B\u0011Ba5m\u0003\u0003\u0005\raa\u000f\u00021!,\u0017\rZ3sgN+\u0007/\u0019:bi>\u0014\b+\u0019;uKJt\u0007%\u0001\u0006ok2dW*\u0019:lKJ\faB\\;mY6\u000b'o[3s?\u0012*\u0017\u000f\u0006\u0003\u0002j\rU\u0003\"\u0003Bj_\u0006\u0005\t\u0019AA\u001e\u0003-qW\u000f\u001c7NCJ\\WM\u001d\u0011\u0002\u0013\r|gNZ5hkJ,G\u0003BA5\u0007;Bqaa\u0018r\u0001\u0004\u0019\t'A\u0003qe>\u00048\u000f\r\u0003\u0004d\r5\u0004\u0003CA,\u0007K\nYd!\u001b\n\t\r\u001d\u0014\u0011\f\u0002\u0004\u001b\u0006\u0004\b\u0003BB6\u0007[b\u0001\u0001\u0002\u0007\u0004p\ru\u0013\u0011!A\u0001\u0006\u0003\u0019\tHA\u0002`II\nBaa\u001d\u0004zA!\u0011\u0011AB;\u0013\u0011\u00199(a\u0001\u0003\u000f9{G\u000f[5oOB!\u0011\u0011AB>\u0013\u0011\u0019i(a\u0001\u0003\u0007\u0005s\u00170A\u0006sK\u0006$'+Z2pe\u0012\u001cH\u0003BBB\u0007\u0013\u0003b!a\u0016\u0004\u0006\u0006}\u0016\u0002BBD\u00033\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\b\u0003'\u0013\b\u0019AAK\u0003\u0015\u0001\u0018M]:f)1\tYda$\u0004\u0014\u000e]51TBP\u0011\u001d\u0019\tj\u001da\u0001\u0003K\u000bq!\u001a8bE2,G\rC\u0004\u0004\u0016N\u0004\r!a\u000f\u0002\t1Lg.\u001a\u0005\b\u00073\u001b\b\u0019AB\u0010\u0003)\u0019H/\u0019:u\u0013:$W\r\u001f\u0005\b\u0007;\u001b\b\u0019AA\u001e\u0003-!W-\\1sG\u0006$\u0018n\u001c8\t\u000f\r\u00056\u000f1\u0001\u0002<\u0005yA-Z7be\u000e\fG/[8o\u001d\u0006lW-\u0001\u0007ta2LG\u000fS3bI\u0016\u00148\u000f\u0006\u0003\u0004(\u000e=\u0006CBA\u0001\u0003\u0007\u001bI\u000b\u0005\u0005\u0002\u0002\r-\u00161HAA\u0013\u0011\u0019i+a\u0001\u0003\rQ+\b\u000f\\33\u0011\u001d\u0019\t\f\u001ea\u0001\u0003w\tq\u0001[3bI\u0016\u00148\u000f")
public final class ConsoleProducer {
    public static Properties producerProps(ProducerConfig producerConfig) {
        return ConsoleProducer$.MODULE$.producerProps(producerConfig);
    }

    public static Properties getReaderProps(ProducerConfig producerConfig) {
        return ConsoleProducer$.MODULE$.getReaderProps(producerConfig);
    }

    public static void main(String[] stringArray) {
        ConsoleProducer$.MODULE$.main(stringArray);
    }

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        ConsoleProducer$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        ConsoleProducer$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        ConsoleProducer$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        ConsoleProducer$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        ConsoleProducer$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        ConsoleProducer$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        ConsoleProducer$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        ConsoleProducer$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        ConsoleProducer$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        ConsoleProducer$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return ConsoleProducer$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return ConsoleProducer$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        ConsoleProducer$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        ConsoleProducer$.MODULE$.trace(function0);
    }

    public static class LineMessageReader
    implements RecordReader {
        private String topic;
        private boolean parseKey = false;
        private String keySeparator = "\t";
        private boolean parseHeaders = false;
        private String headersDelimiter = "\t";
        private String headersSeparator = ",";
        private String headersKeySeparator = ":";
        private boolean ignoreError = false;
        private int lineNumber = 0;
        private boolean printPrompt = System.console() != null;
        private Pattern headersSeparatorPattern;
        private String nullMarker;

        public void close() {
            super.close();
        }

        public String topic() {
            return this.topic;
        }

        public void topic_$eq(String x$1) {
            this.topic = x$1;
        }

        public boolean parseKey() {
            return this.parseKey;
        }

        public void parseKey_$eq(boolean x$1) {
            this.parseKey = x$1;
        }

        public String keySeparator() {
            return this.keySeparator;
        }

        public void keySeparator_$eq(String x$1) {
            this.keySeparator = x$1;
        }

        public boolean parseHeaders() {
            return this.parseHeaders;
        }

        public void parseHeaders_$eq(boolean x$1) {
            this.parseHeaders = x$1;
        }

        public String headersDelimiter() {
            return this.headersDelimiter;
        }

        public void headersDelimiter_$eq(String x$1) {
            this.headersDelimiter = x$1;
        }

        public String headersSeparator() {
            return this.headersSeparator;
        }

        public void headersSeparator_$eq(String x$1) {
            this.headersSeparator = x$1;
        }

        public String headersKeySeparator() {
            return this.headersKeySeparator;
        }

        public void headersKeySeparator_$eq(String x$1) {
            this.headersKeySeparator = x$1;
        }

        public boolean ignoreError() {
            return this.ignoreError;
        }

        public void ignoreError_$eq(boolean x$1) {
            this.ignoreError = x$1;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public void lineNumber_$eq(int x$1) {
            this.lineNumber = x$1;
        }

        public boolean printPrompt() {
            return this.printPrompt;
        }

        public void printPrompt_$eq(boolean x$1) {
            this.printPrompt = x$1;
        }

        public Pattern headersSeparatorPattern() {
            return this.headersSeparatorPattern;
        }

        public void headersSeparatorPattern_$eq(Pattern x$1) {
            this.headersSeparatorPattern = x$1;
        }

        public String nullMarker() {
            return this.nullMarker;
        }

        public void nullMarker_$eq(String x$1) {
            this.nullMarker = x$1;
        }

        public void configure(Map<String, ?> props) {
            block21: {
                block20: {
                    String string;
                    String string2;
                    block19: {
                        this.topic_$eq(props.get("topic").toString());
                        if (props.containsKey("parse.key")) {
                            this.parseKey_$eq(props.get("parse.key").toString().trim().equalsIgnoreCase("true"));
                        }
                        if (props.containsKey("key.separator")) {
                            this.keySeparator_$eq(props.get("key.separator").toString());
                        }
                        if (props.containsKey("parse.headers")) {
                            this.parseHeaders_$eq(props.get("parse.headers").toString().trim().equalsIgnoreCase("true"));
                        }
                        if (props.containsKey("headers.delimiter")) {
                            this.headersDelimiter_$eq(props.get("headers.delimiter").toString());
                        }
                        if (props.containsKey("headers.separator")) {
                            this.headersSeparator_$eq(props.get("headers.separator").toString());
                        }
                        this.headersSeparatorPattern_$eq(Pattern.compile(this.headersSeparator()));
                        if (props.containsKey("headers.key.separator")) {
                            this.headersKeySeparator_$eq(props.get("headers.key.separator").toString());
                        }
                        if (props.containsKey("ignore.error")) {
                            this.ignoreError_$eq(props.get("ignore.error").toString().trim().equalsIgnoreCase("true"));
                        }
                        String string3 = this.headersDelimiter();
                        String string4 = this.headersSeparator();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            throw new KafkaException("headers.delimiter and headers.separator may not be equal");
                        }
                        String string5 = this.headersDelimiter();
                        String string6 = this.headersKeySeparator();
                        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                            throw new KafkaException("headers.delimiter and headers.key.separator may not be equal");
                        }
                        String string7 = this.headersSeparator();
                        String string8 = this.headersKeySeparator();
                        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                            throw new KafkaException("headers.separator and headers.key.separator may not be equal");
                        }
                        if (props.containsKey("null.marker")) {
                            this.nullMarker_$eq(props.get("null.marker").toString());
                        }
                        String string9 = this.nullMarker();
                        String string10 = this.keySeparator();
                        if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                            throw new KafkaException("null.marker and key.separator may not be equal");
                        }
                        String string11 = this.nullMarker();
                        String string12 = this.headersSeparator();
                        if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                            throw new KafkaException("null.marker and headers.separator may not be equal");
                        }
                        String string13 = this.nullMarker();
                        String string14 = this.headersDelimiter();
                        if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                            throw new KafkaException("null.marker and headers.delimiter may not be equal");
                        }
                        string2 = this.nullMarker();
                        string = this.headersKeySeparator();
                        if (string2 != null) break block19;
                        if (string != null) {
                            return;
                        }
                        break block20;
                    }
                    if (!string2.equals(string)) break block21;
                }
                throw new KafkaException("null.marker and headers.key.separator may not be equal");
            }
        }

        public Iterator<ProducerRecord<byte[], byte[]>> readRecords(InputStream inputStream) {
            return new Iterator<ProducerRecord<byte[], byte[]>>(this, inputStream){
                private final BufferedReader reader;
                private ProducerRecord<byte[], byte[]> current;
                private final /* synthetic */ LineMessageReader $outer;

                public void remove() {
                    Iterator.super.remove();
                }

                public void forEachRemaining(Consumer<? super ProducerRecord<byte[], byte[]>> x$1) {
                    Iterator.super.forEachRemaining(x$1);
                }

                public boolean hasNext() {
                    ProducerRecord<byte[], byte[]> producerRecord;
                    String line;
                    if (this.current != null) {
                        return true;
                    }
                    this.$outer.lineNumber_$eq(this.$outer.lineNumber() + 1);
                    if (this.$outer.printPrompt()) {
                        Predef$.MODULE$.print((Object)">");
                    }
                    if ((line = this.reader.readLine()) == null) {
                        producerRecord = null;
                    } else {
                        String headers = this.$outer.kafka$tools$ConsoleProducer$LineMessageReader$$parse(this.$outer.parseHeaders(), line, 0, this.$outer.headersDelimiter(), "headers delimiter");
                        int headerOffset = headers == null ? 0 : headers.length() + this.$outer.headersDelimiter().length();
                        String key = this.$outer.kafka$tools$ConsoleProducer$LineMessageReader$$parse(this.$outer.parseKey(), line, headerOffset, this.$outer.keySeparator(), "key separator");
                        int keyOffset = key == null ? 0 : key.length() + this.$outer.keySeparator().length();
                        String value = line.substring(headerOffset + keyOffset);
                        ProducerRecord<byte[], byte[]> record = new ProducerRecord(this.$outer.topic(), key != null && !key.equals(this.$outer.nullMarker()) ? key.getBytes(StandardCharsets.UTF_8) : null, value != null && !value.equals(this.$outer.nullMarker()) ? value.getBytes(StandardCharsets.UTF_8) : null);
                        if (headers != null && !headers.equals(this.$outer.nullMarker())) {
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$tools$ConsoleProducer$LineMessageReader$$splitHeaders(headers))).foreach(arg_0 -> LineMessageReader$$anon$3.$anonfun$hasNext$1((ProducerRecord)record, arg_0));
                        }
                        producerRecord = this.current = record;
                    }
                    return this.current != null;
                }

                public ProducerRecord<byte[], byte[]> next() {
                    ProducerRecord<byte[], byte[]> producerRecord;
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("no more record");
                    }
                    try {
                        producerRecord = this.current;
                    }
                    finally {
                        this.current = null;
                    }
                    return producerRecord;
                }

                public static final /* synthetic */ Headers $anonfun$hasNext$1(ProducerRecord record$1, Tuple2 header) {
                    return record$1.headers().add((String)header._1(), (byte[])header._2());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.reader = new BufferedReader(new InputStreamReader(inputStream$1, StandardCharsets.UTF_8));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$hasNext$1(org.apache.kafka.clients.producer.ProducerRecord scala.Tuple2 )}, serializedLambda);
                }
            };
        }

        public String kafka$tools$ConsoleProducer$LineMessageReader$$parse(boolean enabled, String line, int startIndex, String demarcation, String demarcationName) {
            int n = line.indexOf(demarcation, startIndex);
            if (!enabled) {
                return null;
            }
            if (-1 == n) {
                if (this.ignoreError()) {
                    return null;
                }
                throw new KafkaException(new StringBuilder(29).append("No ").append(demarcationName).append(" found on line number ").append(this.lineNumber()).append(": '").append(line).append("'").toString());
            }
            return line.substring(startIndex, n);
        }

        public Tuple2<String, byte[]>[] kafka$tools$ConsoleProducer$LineMessageReader$$splitHeaders(String headers) {
            return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.headersSeparatorPattern().split(headers))).map((Function1 & Serializable & scala.Serializable)pair -> {
                String string;
                String string2;
                boolean bl = this.ignoreError();
                int n = pair.indexOf(this.headersKeySeparator());
                if (-1 == n && !bl) {
                    throw new KafkaException(new StringBuilder(56).append("No header key separator found in pair '").append((String)pair).append("' on line number ").append(this.lineNumber()).toString());
                }
                if (-1 == n && bl) {
                    return new Tuple2(pair, null);
                }
                String string3 = string2 = pair.substring(0, n);
                String string4 = this.nullMarker();
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    throw new KafkaException(new StringBuilder(75).append("Header keys should not be equal to the null marker '").append(this.nullMarker()).append("' as they can't be null").toString());
                }
                String string5 = string = pair.substring(n + this.headersKeySeparator().length());
                String string6 = this.nullMarker();
                byte[] headerValue = !(string5 != null ? !string5.equals(string6) : string6 != null) ? null : string.getBytes(StandardCharsets.UTF_8);
                return new Tuple2((Object)string2, (Object)headerValue);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        }
    }

    public static class ProducerConfig
    extends CommandDefaultOptions {
        private final ArgumentAcceptingOptionSpec<String> topicOpt;
        private final ArgumentAcceptingOptionSpec<String> brokerListOpt;
        private final ArgumentAcceptingOptionSpec<String> bootstrapServerOpt;
        private final OptionSpecBuilder syncOpt;
        private final ArgumentAcceptingOptionSpec<String> compressionCodecOpt;
        private final ArgumentAcceptingOptionSpec<Integer> batchSizeOpt;
        private final ArgumentAcceptingOptionSpec<Integer> messageSendMaxRetriesOpt;
        private final ArgumentAcceptingOptionSpec<Long> retryBackoffMsOpt;
        private final ArgumentAcceptingOptionSpec<Long> sendTimeoutOpt;
        private final ArgumentAcceptingOptionSpec<String> requestRequiredAcksOpt;
        private final ArgumentAcceptingOptionSpec<Integer> requestTimeoutMsOpt;
        private final ArgumentAcceptingOptionSpec<Long> metadataExpiryMsOpt;
        private final ArgumentAcceptingOptionSpec<Long> maxBlockMsOpt;
        private final ArgumentAcceptingOptionSpec<Long> maxMemoryBytesOpt;
        private final ArgumentAcceptingOptionSpec<Integer> maxPartitionMemoryBytesOpt;
        private final ArgumentAcceptingOptionSpec<String> messageReaderOpt;
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt;
        private final ArgumentAcceptingOptionSpec<String> propertyOpt;
        private final ArgumentAcceptingOptionSpec<String> readerConfigOpt;
        private final ArgumentAcceptingOptionSpec<String> producerPropertyOpt;
        private final ArgumentAcceptingOptionSpec<String> producerConfigOpt;
        private final String topic;
        private final String bootstrapServer;
        private final String brokerList;
        private final String brokerHostsAndPorts;
        private final boolean sync;
        private final String compressionCodecOptionValue;
        private final String compressionCodec;
        private final String readerClass;
        private final Properties cmdLineProps;
        private final Properties extraProducerProps;

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> brokerListOpt() {
            return this.brokerListOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServerOpt() {
            return this.bootstrapServerOpt;
        }

        public OptionSpecBuilder syncOpt() {
            return this.syncOpt;
        }

        public ArgumentAcceptingOptionSpec<String> compressionCodecOpt() {
            return this.compressionCodecOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> batchSizeOpt() {
            return this.batchSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> messageSendMaxRetriesOpt() {
            return this.messageSendMaxRetriesOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> retryBackoffMsOpt() {
            return this.retryBackoffMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> sendTimeoutOpt() {
            return this.sendTimeoutOpt;
        }

        public ArgumentAcceptingOptionSpec<String> requestRequiredAcksOpt() {
            return this.requestRequiredAcksOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> requestTimeoutMsOpt() {
            return this.requestTimeoutMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> metadataExpiryMsOpt() {
            return this.metadataExpiryMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> maxBlockMsOpt() {
            return this.maxBlockMsOpt;
        }

        public ArgumentAcceptingOptionSpec<Long> maxMemoryBytesOpt() {
            return this.maxMemoryBytesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxPartitionMemoryBytesOpt() {
            return this.maxPartitionMemoryBytesOpt;
        }

        public ArgumentAcceptingOptionSpec<String> messageReaderOpt() {
            return this.messageReaderOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<String> propertyOpt() {
            return this.propertyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> readerConfigOpt() {
            return this.readerConfigOpt;
        }

        public ArgumentAcceptingOptionSpec<String> producerPropertyOpt() {
            return this.producerPropertyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> producerConfigOpt() {
            return this.producerConfigOpt;
        }

        public String topic() {
            return this.topic;
        }

        public String bootstrapServer() {
            return this.bootstrapServer;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public String brokerHostsAndPorts() {
            return this.brokerHostsAndPorts;
        }

        public boolean sync() {
            return this.sync;
        }

        public String compressionCodecOptionValue() {
            return this.compressionCodecOptionValue;
        }

        public String compressionCodec() {
            return this.compressionCodec;
        }

        public String readerClass() {
            return this.readerClass;
        }

        public Properties cmdLineProps() {
            return this.cmdLineProps;
        }

        public Properties extraProducerProps() {
            return this.extraProducerProps;
        }

        public OptionSet tryParse(OptionParser parser, String[] args) {
            try {
                return parser.parse(args);
            }
            catch (OptionException e) {
                throw ToolsUtils$.MODULE$.printUsageAndExit(parser, e.getMessage());
            }
        }

        public ProducerConfig(String[] args) {
            super(args);
            this.topicOpt = this.parser.accepts("topic", "REQUIRED: The topic id to produce messages to.").withRequiredArg().describedAs("topic").ofType(String.class);
            this.brokerListOpt = this.parser.accepts("broker-list", "DEPRECATED, use --bootstrap-server instead; ignored if --bootstrap-server is specified.  The broker list string in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("broker-list").ofType(String.class);
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED unless --broker-list(deprecated) is specified. The server(s) to connect to. The broker list string in the form HOST1:PORT1,HOST2:PORT2.").requiredUnless("broker-list", new String[0]).withRequiredArg().describedAs("server to connect to").ofType(String.class);
            this.syncOpt = this.parser.accepts("sync", "If set message send requests to the brokers are synchronously, one at a time as they arrive.");
            this.compressionCodecOpt = this.parser.accepts("compression-codec", "The compression codec: either 'none', 'gzip', 'snappy', 'lz4', or 'zstd'.If specified without value, then it defaults to 'gzip'").withOptionalArg().describedAs("compression-codec").ofType(String.class);
            this.batchSizeOpt = this.parser.accepts("batch-size", "Number of messages to send in a single batch if they are not being sent synchronously. please note that this option will be replaced if max-partition-memory-bytes is also set").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(16384), (Object[])new Integer[0]);
            this.messageSendMaxRetriesOpt = this.parser.accepts("message-send-max-retries", "Brokers can fail receiving the message for multiple reasons, and being unavailable transiently is just one of them. This property specifies the number of retries before the producer give up and drop this message. This is the option to control `retries` in producer configs.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3), (Object[])new Integer[0]);
            this.retryBackoffMsOpt = this.parser.accepts("retry-backoff-ms", "Before each retry, the producer refreshes the metadata of relevant topics. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata. This is the option to control `retry.backoff.ms` in producer configs.").withRequiredArg().ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(100L), (Object[])new Long[0]);
            this.sendTimeoutOpt = this.parser.accepts("timeout", "If set and the producer is running in asynchronous mode, this gives the maximum amount of time a message will queue awaiting sufficient batch size. The value is given in ms. This is the option to control `linger.ms` in producer configs.").withRequiredArg().describedAs("timeout_ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(1000L), (Object[])new Long[0]);
            this.requestRequiredAcksOpt = this.parser.accepts("request-required-acks", "The required `acks` of the producer requests").withRequiredArg().describedAs("request required acks").ofType(String.class).defaultsTo((Object)"-1", (Object[])new String[0]);
            this.requestTimeoutMsOpt = this.parser.accepts("request-timeout-ms", "The ack timeout of the producer requests. Value must be non-negative and non-zero.").withRequiredArg().describedAs("request timeout ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1500), (Object[])new Integer[0]);
            this.metadataExpiryMsOpt = this.parser.accepts("metadata-expiry-ms", "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any leadership changes. This is the option to control `metadata.max.age.ms` in producer configs.").withRequiredArg().describedAs("metadata expiration interval").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(300000L), (Object[])new Long[0]);
            this.maxBlockMsOpt = this.parser.accepts("max-block-ms", "The max time that the producer will block for during a send request.").withRequiredArg().describedAs("max block on send").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(60000L), (Object[])new Long[0]);
            this.maxMemoryBytesOpt = this.parser.accepts("max-memory-bytes", "The total memory used by the producer to buffer records waiting to be sent to the server. This is the option to control `buffer.memory` in producer configs.").withRequiredArg().describedAs("total memory in bytes").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(0x2000000L), (Object[])new Long[0]);
            this.maxPartitionMemoryBytesOpt = this.parser.accepts("max-partition-memory-bytes", "The buffer size allocated for a partition. When records are received which are smaller than this size the producer will attempt to optimistically group them together until this size is reached. This is the option to control `batch.size` in producer configs.").withRequiredArg().describedAs("memory in bytes per partition").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(16384), (Object[])new Integer[0]);
            this.messageReaderOpt = this.parser.accepts("line-reader", "The class name of the class to use for reading lines from standard in. By default each line is read as a separate message.").withRequiredArg().describedAs("reader_class").ofType(String.class).defaultsTo((Object)LineMessageReader.class.getName(), (Object[])new String[0]);
            this.socketBufferSizeOpt = this.parser.accepts("socket-buffer-size", "The size of the tcp RECV size. This is the option to control `send.buffer.bytes` in producer configs.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(102400), (Object[])new Integer[0]);
            this.propertyOpt = this.parser.accepts("property", new StringOps(Predef$.MODULE$.augmentString("A mechanism to pass user-defined properties in the form key=value to the message reader. This allows custom configuration for a user-defined message reader.\n        |Default properties include:\n        | parse.key=false\n        | parse.headers=false\n        | ignore.error=false\n        | key.separator=\\t\n        | headers.delimiter=\\t\n        | headers.separator=,\n        | headers.key.separator=:\n        | null.marker=   When set, any fields (key, value and headers) equal to this will be replaced by null\n        |Default parsing pattern when:\n        | parse.headers=true and parse.key=true:\n        |  \"h1:v1,h2:v2...\\tkey\\tvalue\"\n        | parse.key=true:\n        |  \"key\\tvalue\"\n        | parse.headers=true:\n        |  \"h1:v1,h2:v2...\\tvalue\"\n      ")).stripMargin()).withRequiredArg().describedAs("prop").ofType(String.class);
            this.readerConfigOpt = this.parser.accepts("reader-config", new StringBuilder(92).append("Config properties file for the message reader. Note that ").append(this.propertyOpt()).append(" takes precedence over this config.").toString()).withRequiredArg().describedAs("config file").ofType(String.class);
            this.producerPropertyOpt = this.parser.accepts("producer-property", "A mechanism to pass user-defined properties in the form key=value to the producer. ").withRequiredArg().describedAs("producer_prop").ofType(String.class);
            this.producerConfigOpt = this.parser.accepts("producer.config", new StringBuilder(78).append("Producer config properties file. Note that ").append(this.producerPropertyOpt()).append(" takes precedence over this config.").toString()).withRequiredArg().describedAs("config file").ofType(String.class);
            this.options = this.tryParse(this.parser, args);
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to read data from standard input and publish it to Kafka.");
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.topicOpt()});
            this.topic = (String)this.options.valueOf(this.topicOpt());
            this.bootstrapServer = (String)this.options.valueOf(this.bootstrapServerOpt());
            this.brokerList = (String)this.options.valueOf(this.brokerListOpt());
            this.brokerHostsAndPorts = (String)this.options.valueOf(this.options.has(this.bootstrapServerOpt()) ? this.bootstrapServerOpt() : this.brokerListOpt());
            ToolsUtils$.MODULE$.validatePortOrDie(this.parser, this.brokerHostsAndPorts());
            this.sync = this.options.has((OptionSpec)this.syncOpt());
            this.compressionCodecOptionValue = (String)this.options.valueOf(this.compressionCodecOpt());
            this.compressionCodec = this.options.has(this.compressionCodecOpt()) ? (this.compressionCodecOptionValue() == null || this.compressionCodecOptionValue().isEmpty() ? CompressionType.GZIP.name : this.compressionCodecOptionValue()) : CompressionType.NONE.name;
            this.readerClass = (String)this.options.valueOf(this.messageReaderOpt());
            this.cmdLineProps = CommandLineUtils.parseKeyValueArgs((List)this.options.valuesOf(this.propertyOpt()));
            this.extraProducerProps = CommandLineUtils.parseKeyValueArgs((List)this.options.valuesOf(this.producerPropertyOpt()));
        }
    }
}

