/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.cdx;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Base64;
import java.util.BitSet;
import java.util.Formatter;
import java.util.HashMap;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.URIs;
import org.netpreserve.jwarc.cdx.JsonException;
import org.netpreserve.jwarc.cdx.JsonTokenizer;

public class CdxRequestEncoder {
    static final int QUERY_STRING_LIMIT = 4096;
    private static final int BUFFER_SIZE = 65536;
    private static final BitSet percentPlusUnreserved = new BitSet();

    public static String encode(HttpRequest httpRequest) throws IOException {
        if (httpRequest.method().equals("GET")) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        out.append("__wb_method=");
        out.append(httpRequest.method());
        int maxLength = out.length() + 1 + 4096;
        MediaType baseContentType = httpRequest.contentType().base();
        BufferedInputStream stream = new BufferedInputStream(httpRequest.body().stream(), 65536);
        if (baseContentType.equals(MediaType.WWW_FORM_URLENCODED)) {
            CdxRequestEncoder.encodeFormBody(stream, out);
        } else if (baseContentType.equals(MediaType.JSON)) {
            CdxRequestEncoder.encodeJsonBody(stream, out, maxLength, false);
        } else if (baseContentType.equals(MediaType.PLAIN_TEXT)) {
            CdxRequestEncoder.encodeJsonBody(stream, out, maxLength, true);
        } else {
            CdxRequestEncoder.encodeBinaryBody(stream, out);
        }
        return out.substring(0, Math.min(out.length(), maxLength));
    }

    static void encodeBinaryBody(InputStream stream, StringBuilder out) throws IOException {
        byte[] body = IOUtils.readNBytes(stream, 4096);
        out.append("&__wb_post_data=");
        out.append(Base64.getEncoder().encodeToString(body));
    }

    private static void encodeFormBody(InputStream stream, StringBuilder out) throws IOException {
        int limit = 12288;
        stream.mark(limit);
        try {
            byte[] body = IOUtils.readNBytes(stream, limit);
            String decodedBody = String.valueOf(StandardCharsets.UTF_8.newDecoder().decode(ByteBuffer.wrap(body)));
            out.append('&');
            CdxRequestEncoder.percentEncodeNonPercent(URIs.percentPlusDecode(decodedBody), out);
        }
        catch (MalformedInputException e) {
            stream.reset();
            CdxRequestEncoder.encodeBinaryBody(stream, out);
        }
    }

    private static void percentEncodeNonPercent(String s, StringBuilder out) {
        for (byte rawByte : s.getBytes(StandardCharsets.UTF_8)) {
            int b = rawByte & 0xFF;
            if (b == 35 || b <= 32 || b >= 127) {
                out.append('%').append(String.format("%02X", b));
                continue;
            }
            out.append((char)b);
        }
    }

    private static void encodeJsonBody(InputStream stream, StringBuilder output, int maxLength, boolean binaryFallback) throws IOException {
        block20: {
            stream.mark(65536);
            JsonTokenizer tokenizer = new JsonTokenizer(new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)), 4096, 4096);
            HashMap<String, Long> nameCounts = new HashMap<String, Long>();
            ArrayDeque<String> nameStack = new ArrayDeque<String>();
            String name = null;
            try {
                block18: while (tokenizer.nextToken() != null && output.length() < maxLength) {
                    switch (tokenizer.currentToken()) {
                        case FIELD_NAME: {
                            name = tokenizer.stringValue();
                            continue block18;
                        }
                        case NULL: 
                        case FALSE: 
                        case TRUE: 
                        case NUMBER_INT: 
                        case NUMBER_FLOAT: 
                        case STRING: {
                            String encodedValue;
                            if (name == null) continue block18;
                            long serial = nameCounts.compute(name, (key, value) -> value == null ? 1L : value + 1L);
                            String key2 = name;
                            if (serial > 1L) {
                                key2 = key2 + "." + serial + "_";
                            }
                            output.append('&');
                            output.append(CdxRequestEncoder.percentPlusEncode(key2));
                            output.append('=');
                            switch (tokenizer.currentToken()) {
                                case NULL: {
                                    encodedValue = "None";
                                    break;
                                }
                                case FALSE: {
                                    encodedValue = "False";
                                    break;
                                }
                                case TRUE: {
                                    encodedValue = "True";
                                    break;
                                }
                                case NUMBER_INT: {
                                    encodedValue = String.valueOf(Long.parseLong(tokenizer.stringValue()));
                                    break;
                                }
                                case NUMBER_FLOAT: {
                                    encodedValue = String.valueOf(Double.parseDouble(tokenizer.stringValue()));
                                    break;
                                }
                                default: {
                                    encodedValue = CdxRequestEncoder.percentPlusEncode(tokenizer.stringValue());
                                }
                            }
                            output.append(encodedValue);
                            continue block18;
                        }
                        case START_OBJECT: {
                            if (name == null) continue block18;
                            nameStack.push(name);
                            continue block18;
                        }
                        case END_OBJECT: {
                            name = nameStack.isEmpty() ? null : (String)nameStack.pop();
                            continue block18;
                        }
                        case START_ARRAY: 
                        case END_ARRAY: {
                            continue block18;
                        }
                    }
                    throw new IllegalStateException("Unexpected: " + (Object)((Object)tokenizer.currentToken()));
                }
            }
            catch (NumberFormatException | JsonException e) {
                if (!binaryFallback) break block20;
                try {
                    stream.reset();
                    CdxRequestEncoder.encodeBinaryBody(stream, output);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static String percentPlusEncode(String string) {
        byte[] bytes;
        StringBuilder output = new StringBuilder();
        Formatter formatter = new Formatter(output);
        for (byte rawByte : bytes = string.getBytes(StandardCharsets.UTF_8)) {
            int b = rawByte & 0xFF;
            if (percentPlusUnreserved.get(b)) {
                output.append((char)b);
                continue;
            }
            if (b == 32) {
                output.append('+');
                continue;
            }
            output.append('%');
            formatter.format("%02X", b);
        }
        return output.toString();
    }

    static {
        "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~".chars().forEach(percentPlusUnreserved::set);
    }
}

