/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.check;

import org.tukaani.xz.check.Check;

public class CRC64
extends Check {
    private static final long[][] TABLE = new long[4][256];
    private long crc = -1L;

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n + n2;
        int n5 = n4 - 3;
        for (n3 = n; n3 < n5; n3 += 4) {
            int n6 = (int)this.crc;
            this.crc = TABLE[3][n6 & 0xFF ^ byArray[n3] & 0xFF] ^ TABLE[2][n6 >>> 8 & 0xFF ^ byArray[n3 + 1] & 0xFF] ^ this.crc >>> 32 ^ TABLE[1][n6 >>> 16 & 0xFF ^ byArray[n3 + 2] & 0xFF] ^ TABLE[0][n6 >>> 24 & 0xFF ^ byArray[n3 + 3] & 0xFF];
        }
        while (n3 < n4) {
            this.crc = TABLE[0][byArray[n3++] & 0xFF ^ (int)this.crc & 0xFF] ^ this.crc >>> 8;
        }
    }

    @Override
    public byte[] finish() {
        long l = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        byte[] byArray = new byte[8];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(l >> i * 8);
        }
        return byArray;
    }

    static {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 256; ++j) {
                long l = i == 0 ? (long)j : TABLE[i - 1][j];
                for (int k = 0; k < 8; ++k) {
                    if ((l & 1L) == 1L) {
                        l = l >>> 1 ^ 0xC96C5795D7870F42L;
                        continue;
                    }
                    l >>>= 1;
                }
                CRC64.TABLE[i][j] = l;
            }
        }
    }
}

