/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.Values;

import com.shapesecurity.salvation2.Constants;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;

public class RFC7230Token {
    @Nonnull
    public final String value;

    private RFC7230Token(@Nonnull String value) {
        this.value = value;
    }

    public static Optional<RFC7230Token> parseRFC7230Token(String value) {
        Matcher matcher = Constants.rfc7230TokenPattern.matcher(value);
        if (matcher.find()) {
            return Optional.of(new RFC7230Token(value));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RFC7230Token)) {
            return false;
        }
        RFC7230Token that = (RFC7230Token)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }
}

