# formFieldMap

@@@ div { .group-scala }

## Signature

@@signature [FormFieldDirectives.scala](/http/src/main/scala/org/apache/pekko/http/scaladsl/server/directives/FormFieldDirectives.scala) { #formFieldMap }

@@@

## Description

Extracts all HTTP form fields at once as a @scala[`Map[String, String]`]@java[`Map<String, String>`] mapping form field names to form field values. Data posted from [HTML Forms](https://www.w3.org/TR/html401/interact/forms.html#h-17.13.4) is either of type `application/x-www-form-urlencoded` or of type `multipart/form-data`.

If form data contain a field value several times, the map will contain the last one.

@scala[See @ref[formFields](formFields.md) for an in-depth description.]

## Warning

Use of this directive can result in performance degradation or even in `OutOfMemoryError` s.
See @scala[@ref[formFieldSeq](formFieldSeq.md)]@java[@ref[formFieldList](formFieldSeq.md)] for details.

## Example

Scala
:  @@snip [FormFieldDirectivesExamplesSpec.scala](/docs/src/test/scala/docs/http/scaladsl/server/directives/FormFieldDirectivesExamplesSpec.scala) { #formFieldMap }

Java
:  @@snip [FormFieldDirectivesExamplesTest.java](/docs/src/test/java/docs/http/javadsl/server/directives/FormFieldDirectivesExamplesTest.java) { #formFieldMap }
