/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.org.roaringbitmap;

import org.apache.pig.org.roaringbitmap.ShortIterator;
import org.apache.pig.org.roaringbitmap.Util;

final class ReverseBitmapContainerShortIterator
implements ShortIterator {
    long word;
    int position;
    long[] bitmap;

    ReverseBitmapContainerShortIterator() {
    }

    ReverseBitmapContainerShortIterator(long[] bitmap) {
        this.wrap(bitmap);
    }

    @Override
    public ShortIterator clone() {
        try {
            return (ShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.position >= 0;
    }

    @Override
    public short next() {
        int shift = Long.numberOfLeadingZeros(this.word) + 1;
        short answer = (short)((this.position + 1) * 64 - shift);
        this.word &= 1L << 64 - shift ^ 0xFFFFFFFFFFFFFFFFL;
        while (this.word == 0L) {
            --this.position;
            if (this.position < 0) break;
            this.word = this.bitmap[this.position];
        }
        return answer;
    }

    @Override
    public int nextAsInt() {
        return Util.toIntUnsigned(this.next());
    }

    @Override
    public void remove() {
        throw new RuntimeException("unsupported operation: remove");
    }

    void wrap(long[] b) {
        this.bitmap = b;
        this.position = this.bitmap.length - 1;
        while (this.position >= 0 && (this.word = this.bitmap[this.position]) == 0L) {
            --this.position;
        }
    }
}

