/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Stitch
extends EvalFunc<DataBag> {
    public DataBag exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        ArrayList<DataBag> bags = new ArrayList<DataBag>(input.size());
        for (int i = 0; i < input.size(); ++i) {
            Object o = input.get(i);
            try {
                bags.add((DataBag)o);
                continue;
            }
            catch (ClassCastException cce) {
                int errCode = 2107;
                String msg = "Stitch expected bags as input but argument " + i + " is a " + DataType.findTypeName((Object)o);
                throw new ExecException(msg, errCode, 2);
            }
        }
        if (bags.size() == 1) {
            return (DataBag)bags.get(0);
        }
        DataBag output = BagFactory.getInstance().newDefaultBag();
        ArrayList<Iterator> iters = new ArrayList<Iterator>(bags.size());
        for (DataBag bag : bags) {
            iters.add(bag.iterator());
        }
        while (((Iterator)iters.get(0)).hasNext()) {
            Tuple outTuple = TupleFactory.getInstance().newTuple();
            for (Iterator iter : iters) {
                if (!iter.hasNext()) continue;
                Tuple t = (Tuple)iter.next();
                List fields = t.getAll();
                for (Object field : fields) {
                    outTuple.append(field);
                }
            }
            output.add(outTuple);
        }
        return output;
    }

    public Schema outputSchema(Schema inputSch) {
        List fields = inputSch.getFields();
        try {
            Schema bagSchema = null;
            for (Schema.FieldSchema field : fields) {
                if (field.type != 120) {
                    throw new RuntimeException("Only bags should be passed to Stitch, schema indicates a " + DataType.findTypeName((byte)field.type) + " being passed");
                }
                if (bagSchema == null && field.schema != null) {
                    if (field.schema.getField((int)0).type == 110) {
                        field = field.schema.getField(0);
                    }
                    bagSchema = new Schema(field.schema);
                    continue;
                }
                if (field.schema == null) continue;
                if (field.schema.getField((int)0).type == 110) {
                    field = field.schema.getField(0);
                }
                for (Schema.FieldSchema fs : field.schema.getFields()) {
                    bagSchema.add(fs);
                }
            }
            Schema.FieldSchema outFS = new Schema.FieldSchema("stitched", bagSchema, 120);
            return new Schema(outFS);
        }
        catch (FrontendException fe) {
            throw new RuntimeException("Unable to create nested schema", fe);
        }
    }
}

