/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.IndexableLoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTextInputFormat;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTextOutputFormat;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataReaderWriter;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.StorageUtil;

public class IndexedStorage
extends PigStorage
implements IndexableLoadFunc {
    protected IndexedStorageInputFormat.IndexedStorageRecordReader[] readers = null;
    protected int currentReaderIndexStart = 0;
    protected byte fieldDelimiter = (byte)9;
    protected final int[] offsetsToIndexKeys;
    protected Comparator<IndexedStorageInputFormat.IndexedStorageRecordReader> readerComparator = new IndexedStorageInputFormat.IndexedStorageRecordReader.IndexedStorageRecordReaderComparator();

    public IndexedStorage(String delimiter, String offsetsToIndexKeys) {
        super(delimiter);
        this.fieldDelimiter = StorageUtil.parseFieldDel((String)delimiter);
        String[] stroffsetsToIndexKeys = offsetsToIndexKeys.split(",");
        this.offsetsToIndexKeys = new int[stroffsetsToIndexKeys.length];
        for (int i = 0; i < stroffsetsToIndexKeys.length; ++i) {
            this.offsetsToIndexKeys[i] = Integer.parseInt(stroffsetsToIndexKeys[i]);
        }
    }

    public OutputFormat getOutputFormat() {
        return new IndexedStorageOutputFormat(this.fieldDelimiter, this.offsetsToIndexKeys);
    }

    private void sortReader(int startIndex) {
        for (int idx = startIndex; idx < this.readers.length - 1; ++idx) {
            IndexedStorageInputFormat.IndexedStorageRecordReader reader1 = this.readers[idx];
            IndexedStorageInputFormat.IndexedStorageRecordReader reader2 = this.readers[idx + 1];
            if (this.readerComparator.compare(reader1, reader2) <= 0) {
                return;
            }
            this.readers[idx] = reader2;
            this.readers[idx + 1] = reader1;
        }
    }

    public InputFormat getInputFormat() {
        return new IndexedStorageInputFormat();
    }

    public Tuple getNext() throws IOException {
        if (this.readers == null) {
            return super.getNext();
        }
        while (this.currentReaderIndexStart < this.readers.length) {
            IndexedStorageInputFormat.IndexedStorageRecordReader r = this.readers[this.currentReaderIndexStart];
            this.prepareToRead(r, null);
            Tuple tuple = super.getNext();
            if (tuple == null) {
                ++this.currentReaderIndexStart;
                r.close();
                continue;
            }
            if (r.indexManager.lastIndexKeyTuple == null && r.indexManager.ReadIndex() == null) {
                throw new IOException("Missing Index for Tuple: " + tuple);
            }
            r.indexManager.numberOfTuples--;
            if (r.indexManager.numberOfTuples == 0L) {
                if (r.indexManager.ReadIndex() == null) {
                    r.close();
                    ++this.currentReaderIndexStart;
                } else {
                    this.sortReader(this.currentReaderIndexStart);
                }
            }
            return tuple;
        }
        return null;
    }

    public void initialize(Configuration conf) throws IOException {
        try {
            InputFormat inputFormat = this.getInputFormat();
            TaskAttemptID id = HadoopShims.getNewTaskAttemptID();
            if (System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
                conf.set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
            }
            List fileSplits = inputFormat.getSplits(HadoopShims.createJobContext((Configuration)conf, null));
            this.readers = new IndexedStorageInputFormat.IndexedStorageRecordReader[fileSplits.size()];
            int idx = 0;
            for (FileSplit fileSplit : fileSplits) {
                TaskAttemptContext context = HadoopShims.createTaskAttemptContext((Configuration)conf, (TaskAttemptID)id);
                IndexedStorageInputFormat.IndexedStorageRecordReader r = (IndexedStorageInputFormat.IndexedStorageRecordReader)inputFormat.createRecordReader((InputSplit)fileSplit, context);
                r.initialize((InputSplit)fileSplit, context);
                this.readers[idx] = r;
                ++idx;
            }
            Arrays.sort(this.readers, this.readerComparator);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void seekNear(Tuple keys) throws IOException {
        int idx;
        int lastIndexModified = -1;
        for (idx = this.currentReaderIndexStart; idx < this.readers.length; ++idx) {
            IndexedStorageInputFormat.IndexedStorageRecordReader r = this.readers[idx];
            if (keys.compareTo((Object)r.indexManager.maxIndexKeyTuple) <= 0 && keys.compareTo((Object)r.indexManager.minIndexKeyTuple) >= 0) {
                r.seekNear(keys);
                lastIndexModified = idx;
                continue;
            }
            if (keys.compareTo((Object)r.indexManager.maxIndexKeyTuple) <= 0) break;
            ++this.currentReaderIndexStart;
        }
        if (lastIndexModified - this.currentReaderIndexStart >= 0) {
            Arrays.sort(this.readers, this.currentReaderIndexStart, lastIndexModified + 1, this.readerComparator);
            for (idx = lastIndexModified; idx >= this.currentReaderIndexStart; --idx) {
                this.sortReader(idx);
            }
        }
    }

    public void close() throws IOException {
        for (IndexedStorageInputFormat.IndexedStorageRecordReader reader : this.readers) {
            reader.close();
        }
    }

    public static class IndexedStorageInputFormat
    extends PigTextInputFormat {
        public RecordReader<LongWritable, Text> createRecordReader(InputSplit split, TaskAttemptContext context) {
            IndexManager im = null;
            try {
                FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
                Path indexFile = IndexManager.getIndexFileName(((FileSplit)split).getPath());
                im = new IndexManager(fs.getFileStatus(indexFile));
                im.openIndexFile(fs);
                im.ReadIndexHeader();
                im.ReadIndexFooter();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return new IndexedStorageRecordReader(im);
        }

        public boolean isSplitable(JobContext context, Path filename) {
            return false;
        }

        public static class IndexedStorageRecordReader
        extends RecordReader<LongWritable, Text> {
            private long start;
            private long pos;
            private long end;
            private IndexedStorageLineReader in;
            private int maxLineLength;
            private LongWritable key = null;
            private Text value = null;
            private IndexManager indexManager = null;

            public String toString() {
                return this.indexManager.minIndexKeyTuple + "|" + this.indexManager.lastIndexKeyTuple + "|" + this.indexManager.maxIndexKeyTuple;
            }

            public IndexedStorageRecordReader(IndexManager im) {
                this.indexManager = im;
            }

            public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
                FileSplit split = (FileSplit)genericSplit;
                Configuration job = context.getConfiguration();
                this.maxLineLength = job.getInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
                this.start = split.getStart();
                this.end = this.start + split.getLength();
                Path file = split.getPath();
                FileSystem fs = file.getFileSystem(job);
                FSDataInputStream fileIn = fs.open(split.getPath());
                boolean skipFirstLine = false;
                if (this.start != 0L) {
                    skipFirstLine = true;
                    --this.start;
                    fileIn.seek(this.start);
                }
                this.in = new IndexedStorageLineReader((InputStream)fileIn, job);
                if (skipFirstLine) {
                    this.start += (long)this.in.readLine(new Text(), 0, (int)Math.min(Integer.MAX_VALUE, this.end - this.start));
                }
                this.pos = this.start;
            }

            public void seek(long offset) throws IOException {
                this.in.seek(offset);
                this.pos = offset;
            }

            public boolean seekNear(Tuple keys) throws IOException {
                boolean ret = false;
                Tuple indexTuple = this.indexManager.ScanIndex(keys);
                if (indexTuple != null) {
                    long offset = this.indexManager.getOffset(indexTuple);
                    this.in.seek(offset);
                    if (keys.compareTo((Object)this.indexManager.getIndexKeyTuple(indexTuple)) == 0) {
                        ret = true;
                    }
                }
                return ret;
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (this.key == null) {
                    this.key = new LongWritable();
                }
                this.key.set(this.pos);
                if (this.value == null) {
                    this.value = new Text();
                }
                int newSize = 0;
                while (this.pos < this.end && (newSize = this.in.readLine(this.value, this.maxLineLength, Math.max((int)Math.min(Integer.MAX_VALUE, this.end - this.pos), this.maxLineLength))) != 0) {
                    this.pos += (long)newSize;
                    if (newSize >= this.maxLineLength) continue;
                }
                if (newSize == 0) {
                    this.key = null;
                    this.value = null;
                    return false;
                }
                return true;
            }

            public LongWritable getCurrentKey() throws IOException, InterruptedException {
                return this.key;
            }

            public Text getCurrentValue() throws IOException, InterruptedException {
                return this.value;
            }

            public float getProgress() throws IOException, InterruptedException {
                if (this.start == this.end) {
                    return 0.0f;
                }
                return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
            }

            public void close() throws IOException {
                if (this.in != null) {
                    this.in.close();
                }
            }

            public static class IndexedStorageLineReader {
                private static final int DEFAULT_BUFFER_SIZE = 65536;
                private int bufferSize = 65536;
                private InputStream in;
                private byte[] buffer;
                private int bufferLength = 0;
                private int bufferPosn = 0;
                private long bufferOffset = 0L;
                private static final byte CR = 13;
                private static final byte LF = 10;

                public IndexedStorageLineReader(InputStream in) {
                    this(in, 65536);
                }

                public IndexedStorageLineReader(InputStream in, int bufferSize) {
                    if (!(in instanceof Seekable) || !(in instanceof PositionedReadable)) {
                        throw new IllegalArgumentException("In is not an instance of Seekable or PositionedReadable");
                    }
                    this.in = in;
                    this.bufferSize = bufferSize;
                    this.buffer = new byte[this.bufferSize];
                }

                public IndexedStorageLineReader(InputStream in, Configuration conf) throws IOException {
                    this(in, conf.getInt("io.file.buffer.size", 65536));
                }

                public void close() throws IOException {
                    this.in.close();
                }

                public int readLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
                    str.clear();
                    int txtLength = 0;
                    int newlineLength = 0;
                    boolean prevCharCR = false;
                    long bytesConsumed = 0L;
                    do {
                        int startPosn = this.bufferPosn;
                        if (this.bufferPosn >= this.bufferLength) {
                            this.bufferPosn = 0;
                            startPosn = 0;
                            if (prevCharCR) {
                                ++bytesConsumed;
                            }
                            this.bufferOffset = ((Seekable)this.in).getPos();
                            this.bufferLength = this.in.read(this.buffer);
                            if (this.bufferLength <= 0) break;
                        }
                        while (this.bufferPosn < this.bufferLength) {
                            if (this.buffer[this.bufferPosn] == 10) {
                                newlineLength = prevCharCR ? 2 : 1;
                                ++this.bufferPosn;
                                break;
                            }
                            if (prevCharCR) {
                                newlineLength = 1;
                                break;
                            }
                            prevCharCR = this.buffer[this.bufferPosn] == 13;
                            ++this.bufferPosn;
                        }
                        int readLength = this.bufferPosn - startPosn;
                        if (prevCharCR && newlineLength == 0) {
                            --readLength;
                        }
                        bytesConsumed += (long)readLength;
                        int appendLength = readLength - newlineLength;
                        if (appendLength > maxLineLength - txtLength) {
                            appendLength = maxLineLength - txtLength;
                        }
                        if (appendLength <= 0) continue;
                        str.append(this.buffer, startPosn, appendLength);
                        txtLength += appendLength;
                    } while (newlineLength == 0 && bytesConsumed < (long)maxBytesToConsume);
                    if (bytesConsumed > Integer.MAX_VALUE) {
                        throw new IOException("Too many bytes before newline: " + bytesConsumed);
                    }
                    return (int)bytesConsumed;
                }

                public int readLine(Text str, int maxLineLength) throws IOException {
                    return this.readLine(str, maxLineLength, Integer.MAX_VALUE);
                }

                public int readLine(Text str) throws IOException {
                    return this.readLine(str, Integer.MAX_VALUE, Integer.MAX_VALUE);
                }

                public void seek(long offset) throws IOException {
                    if (offset >= this.bufferOffset && offset < this.bufferOffset + (long)this.bufferLength) {
                        this.bufferPosn = (int)(offset - this.bufferOffset);
                    } else {
                        this.bufferPosn = this.bufferLength;
                        ((Seekable)this.in).seek(offset);
                    }
                }
            }

            public static class IndexedStorageRecordReaderComparator
            implements Comparator<IndexedStorageRecordReader> {
                @Override
                public int compare(IndexedStorageRecordReader o1, IndexedStorageRecordReader o2) {
                    Tuple t1 = o1.indexManager.lastIndexKeyTuple == null ? o1.indexManager.minIndexKeyTuple : o1.indexManager.lastIndexKeyTuple;
                    Tuple t2 = o2.indexManager.lastIndexKeyTuple == null ? o2.indexManager.minIndexKeyTuple : o2.indexManager.lastIndexKeyTuple;
                    return t1.compareTo((Object)t2);
                }
            }
        }
    }

    public static class IndexManager {
        private int[] offsetsToIndexKeys = null;
        private long offsetToFooter = -1L;
        FSDataOutputStream indexOut;
        FSDataInputStream indexIn;
        private TupleFactory tupleFactory = TupleFactory.getInstance();
        private Tuple indexTuple = this.tupleFactory.newTuple(3);
        private Tuple minIndexKeyTuple = null;
        private Tuple maxIndexKeyTuple = null;
        private Tuple lastIndexKeyTuple = null;
        private long numberOfTuples = 0L;
        private FileStatus indexFile;

        public IndexManager(FileStatus ifile) {
            this.indexFile = ifile;
            this.offsetToFooter = -1L;
        }

        public IndexManager(int[] offsetsToIndexKeys) {
            this.offsetsToIndexKeys = offsetsToIndexKeys;
            this.offsetToFooter = -1L;
        }

        private static Path getIndexFileName(Path file) {
            return new Path(file.getParent(), "." + file.getName() + ".index");
        }

        public void createIndexFile(FileSystem fs, Path file) throws IOException {
            this.indexOut = fs.create(IndexManager.getIndexFileName(file), false);
        }

        public void openIndexFile(FileSystem fs) throws IOException {
            this.indexIn = fs.open(this.indexFile.getPath());
        }

        public void Close() throws IOException {
            this.indexOut.close();
        }

        private void BuildIndex(Tuple t, long offset) throws IOException {
            Tuple indexKeyTuple = this.tupleFactory.newTuple(this.offsetsToIndexKeys.length);
            for (int i = 0; i < this.offsetsToIndexKeys.length; ++i) {
                indexKeyTuple.set(i, t.get(this.offsetsToIndexKeys[i]));
            }
            if (indexKeyTuple.compareTo((Object)this.lastIndexKeyTuple) == 0) {
                ++this.numberOfTuples;
            } else {
                if (this.lastIndexKeyTuple != null) {
                    this.WriteIndex();
                }
                this.lastIndexKeyTuple = indexKeyTuple;
                this.minIndexKeyTuple = this.minIndexKeyTuple == null || indexKeyTuple.compareTo((Object)this.minIndexKeyTuple) < 0 ? indexKeyTuple : this.minIndexKeyTuple;
                this.maxIndexKeyTuple = this.maxIndexKeyTuple == null || indexKeyTuple.compareTo((Object)this.maxIndexKeyTuple) > 0 ? indexKeyTuple : this.maxIndexKeyTuple;
                this.indexTuple = this.tupleFactory.newTuple(3);
                this.indexTuple.set(0, (Object)indexKeyTuple);
                this.numberOfTuples = 1L;
                this.indexTuple.set(2, (Object)offset);
            }
        }

        public void WriteIndexHeader() throws IOException {
            this.indexOut.writeInt(this.offsetsToIndexKeys.length);
            for (int i = 0; i < this.offsetsToIndexKeys.length; ++i) {
                this.indexOut.writeInt(this.offsetsToIndexKeys[i]);
            }
        }

        public void ReadIndexHeader() throws IOException {
            int nkeys = this.indexIn.readInt();
            this.offsetsToIndexKeys = new int[nkeys];
            for (int i = 0; i < nkeys; ++i) {
                this.offsetsToIndexKeys[i] = this.indexIn.readInt();
            }
        }

        public void WriterIndexFooter() throws IOException {
            this.WriteIndex();
            this.offsetToFooter = this.indexOut.getPos();
            DataReaderWriter.writeDatum((DataOutput)this.indexOut, (Object)this.minIndexKeyTuple);
            DataReaderWriter.writeDatum((DataOutput)this.indexOut, (Object)this.maxIndexKeyTuple);
            this.indexOut.writeLong(this.offsetToFooter);
        }

        public void ReadIndexFooter() throws IOException {
            long currentOffset = this.indexIn.getPos();
            this.SeekToIndexFooter();
            this.minIndexKeyTuple = (Tuple)DataReaderWriter.readDatum((DataInput)this.indexIn);
            this.maxIndexKeyTuple = (Tuple)DataReaderWriter.readDatum((DataInput)this.indexIn);
            this.indexIn.seek(currentOffset);
        }

        public void SeekToIndexFooter() throws IOException {
            if (this.offsetToFooter < 0L) {
                this.indexIn.seek(this.indexFile.getLen() - 8L);
                this.offsetToFooter = this.indexIn.readLong();
            }
            this.indexIn.seek(this.offsetToFooter);
        }

        public void WriteIndex() throws IOException {
            this.indexTuple.set(1, (Object)this.numberOfTuples);
            DataReaderWriter.writeDatum((DataOutput)this.indexOut, (Object)this.indexTuple);
        }

        public Tuple getIndexKeyTuple(Tuple indexTuple) throws IOException {
            if (indexTuple.size() == 3) {
                return (Tuple)indexTuple.get(0);
            }
            throw new IOException("Invalid index record with size " + indexTuple.size());
        }

        public long getIndexKeyTupleCount(Tuple indexTuple) throws IOException {
            if (indexTuple.size() == 3) {
                return (Long)indexTuple.get(1);
            }
            throw new IOException("Invalid index record with size " + indexTuple.size());
        }

        public long getOffset(Tuple indexTuple) throws IOException {
            if (indexTuple.size() == 3) {
                return (Long)indexTuple.get(2);
            }
            throw new IOException("Invalid index record with size " + indexTuple.size());
        }

        public Tuple ReadIndex() throws IOException {
            if (this.indexIn.getPos() < this.offsetToFooter) {
                this.indexTuple = (Tuple)DataReaderWriter.readDatum((DataInput)this.indexIn);
                if (this.indexTuple != null) {
                    this.lastIndexKeyTuple = this.getIndexKeyTuple(this.indexTuple);
                    this.numberOfTuples = this.getIndexKeyTupleCount(this.indexTuple);
                }
                return this.indexTuple;
            }
            return null;
        }

        public Tuple ScanIndex(Tuple keys) throws IOException {
            if (this.lastIndexKeyTuple != null && keys.compareTo((Object)this.lastIndexKeyTuple) <= 0) {
                return this.indexTuple;
            }
            while ((this.indexTuple = this.ReadIndex()) != null && keys.compareTo((Object)this.lastIndexKeyTuple) > 0) {
            }
            return this.indexTuple;
        }
    }

    public static class IndexedStorageOutputFormat
    extends PigTextOutputFormat {
        private final byte fieldDelimiter;
        protected final int[] offsetsToIndexKeys;

        public IndexedStorageOutputFormat(byte delimiter, int[] offsetsToIndexKeys) {
            super(delimiter);
            this.fieldDelimiter = delimiter;
            this.offsetsToIndexKeys = offsetsToIndexKeys;
        }

        public RecordWriter<WritableComparable, Tuple> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            Configuration conf = context.getConfiguration();
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path file = this.getDefaultWorkFile(context, "");
            FSDataOutputStream fileOut = fs.create(file, false);
            IndexManager indexManager = new IndexManager(this.offsetsToIndexKeys);
            indexManager.createIndexFile(fs, file);
            return new IndexedStorageRecordWriter(fileOut, this.fieldDelimiter, indexManager);
        }

        public static class IndexedStorageRecordWriter
        extends PigTextOutputFormat.PigLineRecordWriter {
            private FSDataOutputStream fileOut;
            private IndexManager indexManager = null;

            public IndexedStorageRecordWriter(FSDataOutputStream fileOut, byte fieldDel, IndexManager indexManager) throws IOException {
                super((DataOutputStream)fileOut, fieldDel);
                this.fileOut = fileOut;
                this.indexManager = indexManager;
                this.indexManager.WriteIndexHeader();
            }

            public void write(WritableComparable key, Tuple value) throws IOException {
                long offset = this.fileOut.getPos();
                super.write(key, value);
                this.indexManager.BuildIndex(value, offset);
            }

            public void close(TaskAttemptContext context) throws IOException {
                this.indexManager.WriterIndexFooter();
                this.indexManager.Close();
                super.close(context);
            }
        }
    }
}

