/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// EphemeralKeyType is the corresponding interface of EphemeralKeyType
type EphemeralKeyType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetPublicKey returns PublicKey (property field)
	GetPublicKey() PascalByteString
	// GetSignature returns Signature (property field)
	GetSignature() PascalByteString
	// IsEphemeralKeyType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsEphemeralKeyType()
	// CreateBuilder creates a EphemeralKeyTypeBuilder
	CreateEphemeralKeyTypeBuilder() EphemeralKeyTypeBuilder
}

// _EphemeralKeyType is the data-structure of this message
type _EphemeralKeyType struct {
	ExtensionObjectDefinitionContract
	PublicKey PascalByteString
	Signature PascalByteString
}

var _ EphemeralKeyType = (*_EphemeralKeyType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_EphemeralKeyType)(nil)

// NewEphemeralKeyType factory function for _EphemeralKeyType
func NewEphemeralKeyType(publicKey PascalByteString, signature PascalByteString) *_EphemeralKeyType {
	if publicKey == nil {
		panic("publicKey of type PascalByteString for EphemeralKeyType must not be nil")
	}
	if signature == nil {
		panic("signature of type PascalByteString for EphemeralKeyType must not be nil")
	}
	_result := &_EphemeralKeyType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		PublicKey:                         publicKey,
		Signature:                         signature,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// EphemeralKeyTypeBuilder is a builder for EphemeralKeyType
type EphemeralKeyTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(publicKey PascalByteString, signature PascalByteString) EphemeralKeyTypeBuilder
	// WithPublicKey adds PublicKey (property field)
	WithPublicKey(PascalByteString) EphemeralKeyTypeBuilder
	// WithPublicKeyBuilder adds PublicKey (property field) which is build by the builder
	WithPublicKeyBuilder(func(PascalByteStringBuilder) PascalByteStringBuilder) EphemeralKeyTypeBuilder
	// WithSignature adds Signature (property field)
	WithSignature(PascalByteString) EphemeralKeyTypeBuilder
	// WithSignatureBuilder adds Signature (property field) which is build by the builder
	WithSignatureBuilder(func(PascalByteStringBuilder) PascalByteStringBuilder) EphemeralKeyTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the EphemeralKeyType or returns an error if something is wrong
	Build() (EphemeralKeyType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() EphemeralKeyType
}

// NewEphemeralKeyTypeBuilder() creates a EphemeralKeyTypeBuilder
func NewEphemeralKeyTypeBuilder() EphemeralKeyTypeBuilder {
	return &_EphemeralKeyTypeBuilder{_EphemeralKeyType: new(_EphemeralKeyType)}
}

type _EphemeralKeyTypeBuilder struct {
	*_EphemeralKeyType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (EphemeralKeyTypeBuilder) = (*_EphemeralKeyTypeBuilder)(nil)

func (b *_EphemeralKeyTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._EphemeralKeyType
}

func (b *_EphemeralKeyTypeBuilder) WithMandatoryFields(publicKey PascalByteString, signature PascalByteString) EphemeralKeyTypeBuilder {
	return b.WithPublicKey(publicKey).WithSignature(signature)
}

func (b *_EphemeralKeyTypeBuilder) WithPublicKey(publicKey PascalByteString) EphemeralKeyTypeBuilder {
	b.PublicKey = publicKey
	return b
}

func (b *_EphemeralKeyTypeBuilder) WithPublicKeyBuilder(builderSupplier func(PascalByteStringBuilder) PascalByteStringBuilder) EphemeralKeyTypeBuilder {
	builder := builderSupplier(b.PublicKey.CreatePascalByteStringBuilder())
	var err error
	b.PublicKey, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalByteStringBuilder failed"))
	}
	return b
}

func (b *_EphemeralKeyTypeBuilder) WithSignature(signature PascalByteString) EphemeralKeyTypeBuilder {
	b.Signature = signature
	return b
}

func (b *_EphemeralKeyTypeBuilder) WithSignatureBuilder(builderSupplier func(PascalByteStringBuilder) PascalByteStringBuilder) EphemeralKeyTypeBuilder {
	builder := builderSupplier(b.Signature.CreatePascalByteStringBuilder())
	var err error
	b.Signature, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalByteStringBuilder failed"))
	}
	return b
}

func (b *_EphemeralKeyTypeBuilder) Build() (EphemeralKeyType, error) {
	if b.PublicKey == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'publicKey' not set"))
	}
	if b.Signature == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'signature' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._EphemeralKeyType.deepCopy(), nil
}

func (b *_EphemeralKeyTypeBuilder) MustBuild() EphemeralKeyType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_EphemeralKeyTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_EphemeralKeyTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_EphemeralKeyTypeBuilder) DeepCopy() any {
	_copy := b.CreateEphemeralKeyTypeBuilder().(*_EphemeralKeyTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateEphemeralKeyTypeBuilder creates a EphemeralKeyTypeBuilder
func (b *_EphemeralKeyType) CreateEphemeralKeyTypeBuilder() EphemeralKeyTypeBuilder {
	if b == nil {
		return NewEphemeralKeyTypeBuilder()
	}
	return &_EphemeralKeyTypeBuilder{_EphemeralKeyType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_EphemeralKeyType) GetExtensionId() int32 {
	return int32(17550)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_EphemeralKeyType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_EphemeralKeyType) GetPublicKey() PascalByteString {
	return m.PublicKey
}

func (m *_EphemeralKeyType) GetSignature() PascalByteString {
	return m.Signature
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastEphemeralKeyType(structType any) EphemeralKeyType {
	if casted, ok := structType.(EphemeralKeyType); ok {
		return casted
	}
	if casted, ok := structType.(*EphemeralKeyType); ok {
		return *casted
	}
	return nil
}

func (m *_EphemeralKeyType) GetTypeName() string {
	return "EphemeralKeyType"
}

func (m *_EphemeralKeyType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (publicKey)
	lengthInBits += m.PublicKey.GetLengthInBits(ctx)

	// Simple field (signature)
	lengthInBits += m.Signature.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_EphemeralKeyType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_EphemeralKeyType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__ephemeralKeyType EphemeralKeyType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("EphemeralKeyType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for EphemeralKeyType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	publicKey, err := ReadSimpleField[PascalByteString](ctx, "publicKey", ReadComplex[PascalByteString](PascalByteStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'publicKey' field"))
	}
	m.PublicKey = publicKey

	signature, err := ReadSimpleField[PascalByteString](ctx, "signature", ReadComplex[PascalByteString](PascalByteStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'signature' field"))
	}
	m.Signature = signature

	if closeErr := readBuffer.CloseContext("EphemeralKeyType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for EphemeralKeyType")
	}

	return m, nil
}

func (m *_EphemeralKeyType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_EphemeralKeyType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("EphemeralKeyType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for EphemeralKeyType")
		}

		if err := WriteSimpleField[PascalByteString](ctx, "publicKey", m.GetPublicKey(), WriteComplex[PascalByteString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'publicKey' field")
		}

		if err := WriteSimpleField[PascalByteString](ctx, "signature", m.GetSignature(), WriteComplex[PascalByteString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'signature' field")
		}

		if popErr := writeBuffer.PopContext("EphemeralKeyType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for EphemeralKeyType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_EphemeralKeyType) IsEphemeralKeyType() {}

func (m *_EphemeralKeyType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_EphemeralKeyType) deepCopy() *_EphemeralKeyType {
	if m == nil {
		return nil
	}
	_EphemeralKeyTypeCopy := &_EphemeralKeyType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalByteString](m.PublicKey),
		utils.DeepCopy[PascalByteString](m.Signature),
	}
	_EphemeralKeyTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _EphemeralKeyTypeCopy
}

func (m *_EphemeralKeyType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
