/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LogRecordMask is an enum
type LogRecordMask uint32

type ILogRecordMask interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	LogRecordMask_logRecordMaskNone           LogRecordMask = 0
	LogRecordMask_logRecordMaskEventType      LogRecordMask = 1
	LogRecordMask_logRecordMaskSourceNode     LogRecordMask = 2
	LogRecordMask_logRecordMaskSourceName     LogRecordMask = 4
	LogRecordMask_logRecordMaskTraceContext   LogRecordMask = 8
	LogRecordMask_logRecordMaskAdditionalData LogRecordMask = 16
)

var LogRecordMaskValues []LogRecordMask

func init() {
	_ = errors.New
	LogRecordMaskValues = []LogRecordMask{
		LogRecordMask_logRecordMaskNone,
		LogRecordMask_logRecordMaskEventType,
		LogRecordMask_logRecordMaskSourceNode,
		LogRecordMask_logRecordMaskSourceName,
		LogRecordMask_logRecordMaskTraceContext,
		LogRecordMask_logRecordMaskAdditionalData,
	}
}

func LogRecordMaskByValue(value uint32) (enum LogRecordMask, ok bool) {
	switch value {
	case 0:
		return LogRecordMask_logRecordMaskNone, true
	case 1:
		return LogRecordMask_logRecordMaskEventType, true
	case 16:
		return LogRecordMask_logRecordMaskAdditionalData, true
	case 2:
		return LogRecordMask_logRecordMaskSourceNode, true
	case 4:
		return LogRecordMask_logRecordMaskSourceName, true
	case 8:
		return LogRecordMask_logRecordMaskTraceContext, true
	}
	return 0, false
}

func LogRecordMaskByName(value string) (enum LogRecordMask, ok bool) {
	switch value {
	case "logRecordMaskNone":
		return LogRecordMask_logRecordMaskNone, true
	case "logRecordMaskEventType":
		return LogRecordMask_logRecordMaskEventType, true
	case "logRecordMaskAdditionalData":
		return LogRecordMask_logRecordMaskAdditionalData, true
	case "logRecordMaskSourceNode":
		return LogRecordMask_logRecordMaskSourceNode, true
	case "logRecordMaskSourceName":
		return LogRecordMask_logRecordMaskSourceName, true
	case "logRecordMaskTraceContext":
		return LogRecordMask_logRecordMaskTraceContext, true
	}
	return 0, false
}

func LogRecordMaskKnows(value uint32) bool {
	for _, typeValue := range LogRecordMaskValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastLogRecordMask(structType any) LogRecordMask {
	castFunc := func(typ any) LogRecordMask {
		if sLogRecordMask, ok := typ.(LogRecordMask); ok {
			return sLogRecordMask
		}
		return 0
	}
	return castFunc(structType)
}

func (m LogRecordMask) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m LogRecordMask) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func LogRecordMaskParse(ctx context.Context, theBytes []byte) (LogRecordMask, error) {
	return LogRecordMaskParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func LogRecordMaskParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (LogRecordMask, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("LogRecordMask", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading LogRecordMask")
	}
	if enum, ok := LogRecordMaskByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for LogRecordMask")
		return LogRecordMask(val), nil
	} else {
		return enum, nil
	}
}

func (e LogRecordMask) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e LogRecordMask) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint32("LogRecordMask", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e LogRecordMask) GetValue() uint32 {
	return uint32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e LogRecordMask) PLC4XEnumName() string {
	switch e {
	case LogRecordMask_logRecordMaskNone:
		return "logRecordMaskNone"
	case LogRecordMask_logRecordMaskEventType:
		return "logRecordMaskEventType"
	case LogRecordMask_logRecordMaskAdditionalData:
		return "logRecordMaskAdditionalData"
	case LogRecordMask_logRecordMaskSourceNode:
		return "logRecordMaskSourceNode"
	case LogRecordMask_logRecordMaskSourceName:
		return "logRecordMaskSourceName"
	case LogRecordMask_logRecordMaskTraceContext:
		return "logRecordMaskTraceContext"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e LogRecordMask) String() string {
	return e.PLC4XEnumName()
}
