/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableTag is an enum
type OpcuaNodeIdServicesVariableTag int32

type IOpcuaNodeIdServicesVariableTag interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableTag_TagVariables_FindAlias_InputArguments  OpcuaNodeIdServicesVariableTag = 23486
	OpcuaNodeIdServicesVariableTag_TagVariables_FindAlias_OutputArguments OpcuaNodeIdServicesVariableTag = 23487
	OpcuaNodeIdServicesVariableTag_TagVariables_LastChange                OpcuaNodeIdServicesVariableTag = 32854
)

var OpcuaNodeIdServicesVariableTagValues []OpcuaNodeIdServicesVariableTag

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableTagValues = []OpcuaNodeIdServicesVariableTag{
		OpcuaNodeIdServicesVariableTag_TagVariables_FindAlias_InputArguments,
		OpcuaNodeIdServicesVariableTag_TagVariables_FindAlias_OutputArguments,
		OpcuaNodeIdServicesVariableTag_TagVariables_LastChange,
	}
}

func OpcuaNodeIdServicesVariableTagByValue(value int32) (enum OpcuaNodeIdServicesVariableTag, ok bool) {
	switch value {
	case 23486:
		return OpcuaNodeIdServicesVariableTag_TagVariables_FindAlias_InputArguments, true
	case 23487:
		return OpcuaNodeIdServicesVariableTag_TagVariables_FindAlias_OutputArguments, true
	case 32854:
		return OpcuaNodeIdServicesVariableTag_TagVariables_LastChange, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTagByName(value string) (enum OpcuaNodeIdServicesVariableTag, ok bool) {
	switch value {
	case "TagVariables_FindAlias_InputArguments":
		return OpcuaNodeIdServicesVariableTag_TagVariables_FindAlias_InputArguments, true
	case "TagVariables_FindAlias_OutputArguments":
		return OpcuaNodeIdServicesVariableTag_TagVariables_FindAlias_OutputArguments, true
	case "TagVariables_LastChange":
		return OpcuaNodeIdServicesVariableTag_TagVariables_LastChange, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTagKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableTagValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableTag(structType any) OpcuaNodeIdServicesVariableTag {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableTag {
		if sOpcuaNodeIdServicesVariableTag, ok := typ.(OpcuaNodeIdServicesVariableTag); ok {
			return sOpcuaNodeIdServicesVariableTag
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableTag) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableTag) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableTagParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableTag, error) {
	return OpcuaNodeIdServicesVariableTagParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableTagParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableTag, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableTag", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableTag")
	}
	if enum, ok := OpcuaNodeIdServicesVariableTagByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableTag")
		return OpcuaNodeIdServicesVariableTag(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableTag) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableTag) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableTag", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableTag) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableTag) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableTag_TagVariables_FindAlias_InputArguments:
		return "TagVariables_FindAlias_InputArguments"
	case OpcuaNodeIdServicesVariableTag_TagVariables_FindAlias_OutputArguments:
		return "TagVariables_FindAlias_OutputArguments"
	case OpcuaNodeIdServicesVariableTag_TagVariables_LastChange:
		return "TagVariables_LastChange"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableTag) String() string {
	return e.PLC4XEnumName()
}
