/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ServerEndpointDataType is the corresponding interface of ServerEndpointDataType
type ServerEndpointDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetName returns Name (property field)
	GetName() PascalString
	// GetRecordProperties returns RecordProperties (property field)
	GetRecordProperties() []KeyValuePair
	// GetDiscoveryUrls returns DiscoveryUrls (property field)
	GetDiscoveryUrls() []PascalString
	// GetNetworkName returns NetworkName (property field)
	GetNetworkName() PascalString
	// GetPort returns Port (property field)
	GetPort() uint16
	// GetEndpointUrls returns EndpointUrls (property field)
	GetEndpointUrls() []PascalString
	// GetSecuritySettingNames returns SecuritySettingNames (property field)
	GetSecuritySettingNames() []PascalString
	// GetTransportProfileUri returns TransportProfileUri (property field)
	GetTransportProfileUri() PascalString
	// GetUserTokenSettingNames returns UserTokenSettingNames (property field)
	GetUserTokenSettingNames() []PascalString
	// GetReverseConnectUrls returns ReverseConnectUrls (property field)
	GetReverseConnectUrls() []PascalString
	// IsServerEndpointDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsServerEndpointDataType()
	// CreateBuilder creates a ServerEndpointDataTypeBuilder
	CreateServerEndpointDataTypeBuilder() ServerEndpointDataTypeBuilder
}

// _ServerEndpointDataType is the data-structure of this message
type _ServerEndpointDataType struct {
	ExtensionObjectDefinitionContract
	Name                  PascalString
	RecordProperties      []KeyValuePair
	DiscoveryUrls         []PascalString
	NetworkName           PascalString
	Port                  uint16
	EndpointUrls          []PascalString
	SecuritySettingNames  []PascalString
	TransportProfileUri   PascalString
	UserTokenSettingNames []PascalString
	ReverseConnectUrls    []PascalString
}

var _ ServerEndpointDataType = (*_ServerEndpointDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_ServerEndpointDataType)(nil)

// NewServerEndpointDataType factory function for _ServerEndpointDataType
func NewServerEndpointDataType(name PascalString, recordProperties []KeyValuePair, discoveryUrls []PascalString, networkName PascalString, port uint16, endpointUrls []PascalString, securitySettingNames []PascalString, transportProfileUri PascalString, userTokenSettingNames []PascalString, reverseConnectUrls []PascalString) *_ServerEndpointDataType {
	if name == nil {
		panic("name of type PascalString for ServerEndpointDataType must not be nil")
	}
	if networkName == nil {
		panic("networkName of type PascalString for ServerEndpointDataType must not be nil")
	}
	if transportProfileUri == nil {
		panic("transportProfileUri of type PascalString for ServerEndpointDataType must not be nil")
	}
	_result := &_ServerEndpointDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Name:                              name,
		RecordProperties:                  recordProperties,
		DiscoveryUrls:                     discoveryUrls,
		NetworkName:                       networkName,
		Port:                              port,
		EndpointUrls:                      endpointUrls,
		SecuritySettingNames:              securitySettingNames,
		TransportProfileUri:               transportProfileUri,
		UserTokenSettingNames:             userTokenSettingNames,
		ReverseConnectUrls:                reverseConnectUrls,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ServerEndpointDataTypeBuilder is a builder for ServerEndpointDataType
type ServerEndpointDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(name PascalString, recordProperties []KeyValuePair, discoveryUrls []PascalString, networkName PascalString, port uint16, endpointUrls []PascalString, securitySettingNames []PascalString, transportProfileUri PascalString, userTokenSettingNames []PascalString, reverseConnectUrls []PascalString) ServerEndpointDataTypeBuilder
	// WithName adds Name (property field)
	WithName(PascalString) ServerEndpointDataTypeBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) ServerEndpointDataTypeBuilder
	// WithRecordProperties adds RecordProperties (property field)
	WithRecordProperties(...KeyValuePair) ServerEndpointDataTypeBuilder
	// WithDiscoveryUrls adds DiscoveryUrls (property field)
	WithDiscoveryUrls(...PascalString) ServerEndpointDataTypeBuilder
	// WithNetworkName adds NetworkName (property field)
	WithNetworkName(PascalString) ServerEndpointDataTypeBuilder
	// WithNetworkNameBuilder adds NetworkName (property field) which is build by the builder
	WithNetworkNameBuilder(func(PascalStringBuilder) PascalStringBuilder) ServerEndpointDataTypeBuilder
	// WithPort adds Port (property field)
	WithPort(uint16) ServerEndpointDataTypeBuilder
	// WithEndpointUrls adds EndpointUrls (property field)
	WithEndpointUrls(...PascalString) ServerEndpointDataTypeBuilder
	// WithSecuritySettingNames adds SecuritySettingNames (property field)
	WithSecuritySettingNames(...PascalString) ServerEndpointDataTypeBuilder
	// WithTransportProfileUri adds TransportProfileUri (property field)
	WithTransportProfileUri(PascalString) ServerEndpointDataTypeBuilder
	// WithTransportProfileUriBuilder adds TransportProfileUri (property field) which is build by the builder
	WithTransportProfileUriBuilder(func(PascalStringBuilder) PascalStringBuilder) ServerEndpointDataTypeBuilder
	// WithUserTokenSettingNames adds UserTokenSettingNames (property field)
	WithUserTokenSettingNames(...PascalString) ServerEndpointDataTypeBuilder
	// WithReverseConnectUrls adds ReverseConnectUrls (property field)
	WithReverseConnectUrls(...PascalString) ServerEndpointDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the ServerEndpointDataType or returns an error if something is wrong
	Build() (ServerEndpointDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ServerEndpointDataType
}

// NewServerEndpointDataTypeBuilder() creates a ServerEndpointDataTypeBuilder
func NewServerEndpointDataTypeBuilder() ServerEndpointDataTypeBuilder {
	return &_ServerEndpointDataTypeBuilder{_ServerEndpointDataType: new(_ServerEndpointDataType)}
}

type _ServerEndpointDataTypeBuilder struct {
	*_ServerEndpointDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (ServerEndpointDataTypeBuilder) = (*_ServerEndpointDataTypeBuilder)(nil)

func (b *_ServerEndpointDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._ServerEndpointDataType
}

func (b *_ServerEndpointDataTypeBuilder) WithMandatoryFields(name PascalString, recordProperties []KeyValuePair, discoveryUrls []PascalString, networkName PascalString, port uint16, endpointUrls []PascalString, securitySettingNames []PascalString, transportProfileUri PascalString, userTokenSettingNames []PascalString, reverseConnectUrls []PascalString) ServerEndpointDataTypeBuilder {
	return b.WithName(name).WithRecordProperties(recordProperties...).WithDiscoveryUrls(discoveryUrls...).WithNetworkName(networkName).WithPort(port).WithEndpointUrls(endpointUrls...).WithSecuritySettingNames(securitySettingNames...).WithTransportProfileUri(transportProfileUri).WithUserTokenSettingNames(userTokenSettingNames...).WithReverseConnectUrls(reverseConnectUrls...)
}

func (b *_ServerEndpointDataTypeBuilder) WithName(name PascalString) ServerEndpointDataTypeBuilder {
	b.Name = name
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ServerEndpointDataTypeBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithRecordProperties(recordProperties ...KeyValuePair) ServerEndpointDataTypeBuilder {
	b.RecordProperties = recordProperties
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithDiscoveryUrls(discoveryUrls ...PascalString) ServerEndpointDataTypeBuilder {
	b.DiscoveryUrls = discoveryUrls
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithNetworkName(networkName PascalString) ServerEndpointDataTypeBuilder {
	b.NetworkName = networkName
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithNetworkNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ServerEndpointDataTypeBuilder {
	builder := builderSupplier(b.NetworkName.CreatePascalStringBuilder())
	var err error
	b.NetworkName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithPort(port uint16) ServerEndpointDataTypeBuilder {
	b.Port = port
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithEndpointUrls(endpointUrls ...PascalString) ServerEndpointDataTypeBuilder {
	b.EndpointUrls = endpointUrls
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithSecuritySettingNames(securitySettingNames ...PascalString) ServerEndpointDataTypeBuilder {
	b.SecuritySettingNames = securitySettingNames
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithTransportProfileUri(transportProfileUri PascalString) ServerEndpointDataTypeBuilder {
	b.TransportProfileUri = transportProfileUri
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithTransportProfileUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) ServerEndpointDataTypeBuilder {
	builder := builderSupplier(b.TransportProfileUri.CreatePascalStringBuilder())
	var err error
	b.TransportProfileUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithUserTokenSettingNames(userTokenSettingNames ...PascalString) ServerEndpointDataTypeBuilder {
	b.UserTokenSettingNames = userTokenSettingNames
	return b
}

func (b *_ServerEndpointDataTypeBuilder) WithReverseConnectUrls(reverseConnectUrls ...PascalString) ServerEndpointDataTypeBuilder {
	b.ReverseConnectUrls = reverseConnectUrls
	return b
}

func (b *_ServerEndpointDataTypeBuilder) Build() (ServerEndpointDataType, error) {
	if b.Name == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'name' not set"))
	}
	if b.NetworkName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'networkName' not set"))
	}
	if b.TransportProfileUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'transportProfileUri' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ServerEndpointDataType.deepCopy(), nil
}

func (b *_ServerEndpointDataTypeBuilder) MustBuild() ServerEndpointDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ServerEndpointDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_ServerEndpointDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_ServerEndpointDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateServerEndpointDataTypeBuilder().(*_ServerEndpointDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateServerEndpointDataTypeBuilder creates a ServerEndpointDataTypeBuilder
func (b *_ServerEndpointDataType) CreateServerEndpointDataTypeBuilder() ServerEndpointDataTypeBuilder {
	if b == nil {
		return NewServerEndpointDataTypeBuilder()
	}
	return &_ServerEndpointDataTypeBuilder{_ServerEndpointDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ServerEndpointDataType) GetExtensionId() int32 {
	return int32(15560)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ServerEndpointDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ServerEndpointDataType) GetName() PascalString {
	return m.Name
}

func (m *_ServerEndpointDataType) GetRecordProperties() []KeyValuePair {
	return m.RecordProperties
}

func (m *_ServerEndpointDataType) GetDiscoveryUrls() []PascalString {
	return m.DiscoveryUrls
}

func (m *_ServerEndpointDataType) GetNetworkName() PascalString {
	return m.NetworkName
}

func (m *_ServerEndpointDataType) GetPort() uint16 {
	return m.Port
}

func (m *_ServerEndpointDataType) GetEndpointUrls() []PascalString {
	return m.EndpointUrls
}

func (m *_ServerEndpointDataType) GetSecuritySettingNames() []PascalString {
	return m.SecuritySettingNames
}

func (m *_ServerEndpointDataType) GetTransportProfileUri() PascalString {
	return m.TransportProfileUri
}

func (m *_ServerEndpointDataType) GetUserTokenSettingNames() []PascalString {
	return m.UserTokenSettingNames
}

func (m *_ServerEndpointDataType) GetReverseConnectUrls() []PascalString {
	return m.ReverseConnectUrls
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastServerEndpointDataType(structType any) ServerEndpointDataType {
	if casted, ok := structType.(ServerEndpointDataType); ok {
		return casted
	}
	if casted, ok := structType.(*ServerEndpointDataType); ok {
		return *casted
	}
	return nil
}

func (m *_ServerEndpointDataType) GetTypeName() string {
	return "ServerEndpointDataType"
}

func (m *_ServerEndpointDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Implicit Field (noOfRecordProperties)
	lengthInBits += 32

	// Array field
	if len(m.RecordProperties) > 0 {
		for _curItem, element := range m.RecordProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.RecordProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfDiscoveryUrls)
	lengthInBits += 32

	// Array field
	if len(m.DiscoveryUrls) > 0 {
		for _curItem, element := range m.DiscoveryUrls {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DiscoveryUrls), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (networkName)
	lengthInBits += m.NetworkName.GetLengthInBits(ctx)

	// Simple field (port)
	lengthInBits += 16

	// Implicit Field (noOfEndpointUrls)
	lengthInBits += 32

	// Array field
	if len(m.EndpointUrls) > 0 {
		for _curItem, element := range m.EndpointUrls {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.EndpointUrls), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfSecuritySettingNames)
	lengthInBits += 32

	// Array field
	if len(m.SecuritySettingNames) > 0 {
		for _curItem, element := range m.SecuritySettingNames {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.SecuritySettingNames), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (transportProfileUri)
	lengthInBits += m.TransportProfileUri.GetLengthInBits(ctx)

	// Implicit Field (noOfUserTokenSettingNames)
	lengthInBits += 32

	// Array field
	if len(m.UserTokenSettingNames) > 0 {
		for _curItem, element := range m.UserTokenSettingNames {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.UserTokenSettingNames), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Implicit Field (noOfReverseConnectUrls)
	lengthInBits += 32

	// Array field
	if len(m.ReverseConnectUrls) > 0 {
		for _curItem, element := range m.ReverseConnectUrls {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.ReverseConnectUrls), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_ServerEndpointDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ServerEndpointDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__serverEndpointDataType ServerEndpointDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ServerEndpointDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ServerEndpointDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	noOfRecordProperties, err := ReadImplicitField[int32](ctx, "noOfRecordProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfRecordProperties' field"))
	}
	_ = noOfRecordProperties

	recordProperties, err := ReadCountArrayField[KeyValuePair](ctx, "recordProperties", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfRecordProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'recordProperties' field"))
	}
	m.RecordProperties = recordProperties

	noOfDiscoveryUrls, err := ReadImplicitField[int32](ctx, "noOfDiscoveryUrls", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfDiscoveryUrls' field"))
	}
	_ = noOfDiscoveryUrls

	discoveryUrls, err := ReadCountArrayField[PascalString](ctx, "discoveryUrls", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfDiscoveryUrls))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'discoveryUrls' field"))
	}
	m.DiscoveryUrls = discoveryUrls

	networkName, err := ReadSimpleField[PascalString](ctx, "networkName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'networkName' field"))
	}
	m.NetworkName = networkName

	port, err := ReadSimpleField(ctx, "port", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'port' field"))
	}
	m.Port = port

	noOfEndpointUrls, err := ReadImplicitField[int32](ctx, "noOfEndpointUrls", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfEndpointUrls' field"))
	}
	_ = noOfEndpointUrls

	endpointUrls, err := ReadCountArrayField[PascalString](ctx, "endpointUrls", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfEndpointUrls))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'endpointUrls' field"))
	}
	m.EndpointUrls = endpointUrls

	noOfSecuritySettingNames, err := ReadImplicitField[int32](ctx, "noOfSecuritySettingNames", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfSecuritySettingNames' field"))
	}
	_ = noOfSecuritySettingNames

	securitySettingNames, err := ReadCountArrayField[PascalString](ctx, "securitySettingNames", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfSecuritySettingNames))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securitySettingNames' field"))
	}
	m.SecuritySettingNames = securitySettingNames

	transportProfileUri, err := ReadSimpleField[PascalString](ctx, "transportProfileUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'transportProfileUri' field"))
	}
	m.TransportProfileUri = transportProfileUri

	noOfUserTokenSettingNames, err := ReadImplicitField[int32](ctx, "noOfUserTokenSettingNames", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfUserTokenSettingNames' field"))
	}
	_ = noOfUserTokenSettingNames

	userTokenSettingNames, err := ReadCountArrayField[PascalString](ctx, "userTokenSettingNames", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfUserTokenSettingNames))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userTokenSettingNames' field"))
	}
	m.UserTokenSettingNames = userTokenSettingNames

	noOfReverseConnectUrls, err := ReadImplicitField[int32](ctx, "noOfReverseConnectUrls", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfReverseConnectUrls' field"))
	}
	_ = noOfReverseConnectUrls

	reverseConnectUrls, err := ReadCountArrayField[PascalString](ctx, "reverseConnectUrls", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer), uint64(noOfReverseConnectUrls))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'reverseConnectUrls' field"))
	}
	m.ReverseConnectUrls = reverseConnectUrls

	if closeErr := readBuffer.CloseContext("ServerEndpointDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ServerEndpointDataType")
	}

	return m, nil
}

func (m *_ServerEndpointDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ServerEndpointDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ServerEndpointDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ServerEndpointDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}
		noOfRecordProperties := int32(utils.InlineIf(bool((m.GetRecordProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetRecordProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfRecordProperties", noOfRecordProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfRecordProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "recordProperties", m.GetRecordProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'recordProperties' field")
		}
		noOfDiscoveryUrls := int32(utils.InlineIf(bool((m.GetDiscoveryUrls()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetDiscoveryUrls()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfDiscoveryUrls", noOfDiscoveryUrls, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfDiscoveryUrls' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "discoveryUrls", m.GetDiscoveryUrls(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'discoveryUrls' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "networkName", m.GetNetworkName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'networkName' field")
		}

		if err := WriteSimpleField[uint16](ctx, "port", m.GetPort(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'port' field")
		}
		noOfEndpointUrls := int32(utils.InlineIf(bool((m.GetEndpointUrls()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetEndpointUrls()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfEndpointUrls", noOfEndpointUrls, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfEndpointUrls' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "endpointUrls", m.GetEndpointUrls(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'endpointUrls' field")
		}
		noOfSecuritySettingNames := int32(utils.InlineIf(bool((m.GetSecuritySettingNames()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetSecuritySettingNames()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfSecuritySettingNames", noOfSecuritySettingNames, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfSecuritySettingNames' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "securitySettingNames", m.GetSecuritySettingNames(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'securitySettingNames' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "transportProfileUri", m.GetTransportProfileUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'transportProfileUri' field")
		}
		noOfUserTokenSettingNames := int32(utils.InlineIf(bool((m.GetUserTokenSettingNames()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetUserTokenSettingNames()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfUserTokenSettingNames", noOfUserTokenSettingNames, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfUserTokenSettingNames' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "userTokenSettingNames", m.GetUserTokenSettingNames(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'userTokenSettingNames' field")
		}
		noOfReverseConnectUrls := int32(utils.InlineIf(bool((m.GetReverseConnectUrls()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetReverseConnectUrls()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfReverseConnectUrls", noOfReverseConnectUrls, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfReverseConnectUrls' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "reverseConnectUrls", m.GetReverseConnectUrls(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'reverseConnectUrls' field")
		}

		if popErr := writeBuffer.PopContext("ServerEndpointDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ServerEndpointDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ServerEndpointDataType) IsServerEndpointDataType() {}

func (m *_ServerEndpointDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ServerEndpointDataType) deepCopy() *_ServerEndpointDataType {
	if m == nil {
		return nil
	}
	_ServerEndpointDataTypeCopy := &_ServerEndpointDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Name),
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.RecordProperties),
		utils.DeepCopySlice[PascalString, PascalString](m.DiscoveryUrls),
		utils.DeepCopy[PascalString](m.NetworkName),
		m.Port,
		utils.DeepCopySlice[PascalString, PascalString](m.EndpointUrls),
		utils.DeepCopySlice[PascalString, PascalString](m.SecuritySettingNames),
		utils.DeepCopy[PascalString](m.TransportProfileUri),
		utils.DeepCopySlice[PascalString, PascalString](m.UserTokenSettingNames),
		utils.DeepCopySlice[PascalString, PascalString](m.ReverseConnectUrls),
	}
	_ServerEndpointDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _ServerEndpointDataTypeCopy
}

func (m *_ServerEndpointDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
