/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.container;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.util.ArrayList;
import java.util.List;
import jdk.jfr.consumer.RecordedEvent;

public final class ContainerConfigurationHandler
implements RecordedEventHandler {
    private static final String METRIC_NAME = "process.runtime.jvm.cpu.limit";
    private static final String EVENT_NAME = "jdk.ContainerConfiguration";
    private static final String EFFECTIVE_CPU_COUNT = "effectiveCpuCount";
    private final List<AutoCloseable> observables = new ArrayList<AutoCloseable>();
    private volatile long value = 0L;

    public ContainerConfigurationHandler(Meter meter) {
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder(METRIC_NAME).setUnit("1").buildWithCallback(codm -> codm.record(this.value)));
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.CPU_COUNT_METRICS;
    }

    @Override
    public void accept(RecordedEvent ev) {
        if (ev.hasField(EFFECTIVE_CPU_COUNT)) {
            this.value = ev.getLong(EFFECTIVE_CPU_COUNT);
        }
    }

    @Override
    public void close() {
        RecordedEventHandler.closeObservables(this.observables);
    }
}

