/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.util.concurrent.RateLimiter;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.Recorder;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.testclient.PerfClientUtils;
import org.apache.pulsar.testclient.PerformanceBaseArguments;
import org.apache.pulsar.testclient.utils.PaddingDecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="transaction", description={"Test pulsar transaction performance."})
public class PerformanceTransaction
extends PerformanceBaseArguments {
    private static final LongAdder totalNumEndTxnOpFailed = new LongAdder();
    private static final LongAdder totalNumEndTxnOpSuccess = new LongAdder();
    private static final LongAdder numTxnOpSuccess = new LongAdder();
    private static final LongAdder totalNumTxnOpenTxnFail = new LongAdder();
    private static final LongAdder totalNumTxnOpenTxnSuccess = new LongAdder();
    private static final LongAdder numMessagesAckFailed = new LongAdder();
    private static final LongAdder numMessagesAckSuccess = new LongAdder();
    private static final LongAdder numMessagesSendFailed = new LongAdder();
    private static final LongAdder numMessagesSendSuccess = new LongAdder();
    private static final Recorder messageAckRecorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    private static final Recorder messageAckCumulativeRecorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    private static final Recorder messageSendRecorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    private static final Recorder messageSendRCumulativeRecorder = new Recorder(TimeUnit.SECONDS.toMicros(120000L), 5);
    @CommandLine.Option(names={"--topics-c"}, description={"All topics that need ack for a transaction"}, required=true)
    public List<String> consumerTopic = Collections.singletonList("test-consume");
    @CommandLine.Option(names={"--topics-p"}, description={"All topics that need produce for a transaction"}, required=true)
    public List<String> producerTopic = Collections.singletonList("test-produce");
    @CommandLine.Option(names={"-threads", "--num-test-threads"}, description={"Number of test threads.This thread is for a new transaction to ack messages from consumer topics and produce message to producer topics, and then commit or abort this transaction. Increasing the number of threads increases the parallelism of the performance test, thereby increasing the intensity of the stress test."})
    public int numTestThreads = 1;
    @CommandLine.Option(names={"-au", "--admin-url"}, description={"Pulsar Admin URL"}, descriptionKey="webServiceUrl")
    public String adminURL;
    @CommandLine.Option(names={"-np", "--partitions"}, description={"Create partitioned topics with a given number of partitions, 0 meansnot trying to create a topic"})
    public Integer partitions = null;
    @CommandLine.Option(names={"-time", "--test-duration"}, description={"Test duration (in second). 0 means keeping publishing"})
    public long testTime = 0L;
    @CommandLine.Option(names={"-ss", "--subscriptions"}, description={"A list of subscriptions to consume (for example, sub1,sub2)"})
    public List<String> subscriptions = Collections.singletonList("sub");
    @CommandLine.Option(names={"-ns", "--num-subscriptions"}, description={"Number of subscriptions (per topic)"})
    public int numSubscriptions = 1;
    @CommandLine.Option(names={"-sp", "--subscription-position"}, description={"Subscription position"})
    private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Earliest;
    @CommandLine.Option(names={"-st", "--subscription-type"}, description={"Subscription type"})
    public SubscriptionType subscriptionType = SubscriptionType.Shared;
    @CommandLine.Option(names={"-rs", "--replicated"}, description={"Whether the subscription status should be replicated"})
    private boolean replicatedSubscription = false;
    @CommandLine.Option(names={"-q", "--receiver-queue-size"}, description={"Size of the receiver queue"})
    public int receiverQueueSize = 1000;
    @CommandLine.Option(names={"-tto", "--txn-timeout"}, description={"Set the time value of transaction timeout, and the time unit is second. (After --txn-enable setting to true, --txn-timeout takes effect)"})
    public long transactionTimeout = 5L;
    @CommandLine.Option(names={"-ntxn", "--number-txn"}, description={"Set the number of transaction. 0 means keeping open.If transaction disabled, it means the number of tasks. The task or transaction produces or consumes a specified number of messages."})
    public long numTransactions = 0L;
    @CommandLine.Option(names={"-nmp", "--numMessage-perTransaction-produce"}, description={"Set the number of messages produced in  a transaction.If transaction disabled, it means the number of messages produced in a task."})
    public int numMessagesProducedPerTransaction = 1;
    @CommandLine.Option(names={"-nmc", "--numMessage-perTransaction-consume"}, description={"Set the number of messages consumed in a transaction.If transaction disabled, it means the number of messages consumed in a task."})
    public int numMessagesReceivedPerTransaction = 1;
    @CommandLine.Option(names={"--txn-disable"}, description={"Disable transaction"})
    public boolean isDisableTransaction = false;
    @CommandLine.Option(names={"-abort"}, description={"Abort the transaction. (After --txn-disEnable setting to false, -abort takes effect)"})
    public boolean isAbortTransaction = false;
    @CommandLine.Option(names={"-txnRate"}, description={"Set the rate of opened transaction or task. 0 means no limit"})
    public int openTxnRate = 0;
    static final DecimalFormat DEC = new PaddingDecimalFormat("0.000", 7);
    static final DecimalFormat INTFORMAT = new PaddingDecimalFormat("0", 7);
    static final DecimalFormat TOTALFORMAT = new DecimalFormat("0.000");
    private static final Logger log = LoggerFactory.getLogger(PerformanceTransaction.class);

    public PerformanceTransaction() {
        super("transaction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        super.parseCLI();
        PerfClientUtils.printJVMInformation(log);
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting Pulsar perf transaction with config: {}", (Object)w.writeValueAsString((Object)this));
        byte[] payloadBytes = new byte[1024];
        Random random = new Random(0L);
        for (int i = 0; i < payloadBytes.length; ++i) {
            payloadBytes[i] = (byte)(random.nextInt(26) + 65);
        }
        if (this.partitions != null) {
            PulsarAdminBuilder adminBuilder = PerfClientUtils.createAdminBuilderFromArguments(this, this.adminURL);
            try (PulsarAdmin adminClient = adminBuilder.build();){
                for (String topic : this.producerTopic) {
                    log.info("Creating  produce partitioned topic {} with {} partitions", (Object)topic, (Object)this.partitions);
                    try {
                        adminClient.topics().createPartitionedTopic(topic, this.partitions.intValue());
                    }
                    catch (PulsarAdminException.ConflictException alreadyExists) {
                        if (log.isDebugEnabled()) {
                            log.debug("Topic {} already exists: {}", (Object)topic, (Object)alreadyExists);
                        }
                        PartitionedTopicMetadata partitionedTopicMetadata = adminClient.topics().getPartitionedTopicMetadata(topic);
                        if (partitionedTopicMetadata.partitions == this.partitions) continue;
                        log.error("Topic {} already exists but it has a wrong number of partitions: {}, expecting {}", new Object[]{topic, partitionedTopicMetadata.partitions, this.partitions});
                        PerfClientUtils.exit(1);
                    }
                }
            }
        }
        ClientBuilder clientBuilder = PerfClientUtils.createClientBuilderFromArguments(this).enableTransaction(!this.isDisableTransaction);
        PulsarClient client = clientBuilder.build();
        try {
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(this.numTestThreads, this.numTestThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            long startTime = System.nanoTime();
            long testEndTime = startTime + (long)((double)this.testTime * 1.0E9);
            Thread shutdownHookThread = PerfClientUtils.addShutdownHook(() -> {
                if (!this.isDisableTransaction) {
                    PerformanceTransaction.printTxnAggregatedThroughput(startTime);
                } else {
                    PerformanceTransaction.printAggregatedThroughput(startTime);
                }
                PerformanceTransaction.printAggregatedStats();
            });
            AtomicBoolean executing = new AtomicBoolean(true);
            RateLimiter rateLimiter = this.openTxnRate > 0 ? RateLimiter.create((double)this.openTxnRate) : null;
            for (int i = 0; i < this.numTestThreads; ++i) {
                executorService.submit(() -> {
                    List<Producer<byte[]>> producers = null;
                    List<List<Consumer<byte[]>>> consumers = null;
                    AtomicReference<Object> atomicReference = null;
                    try {
                        producers = this.buildProducers(client);
                        consumers = this.buildConsumer(client);
                        atomicReference = !this.isDisableTransaction ? new AtomicReference<Transaction>((Transaction)client.newTransaction().withTransactionTimeout(this.transactionTimeout, TimeUnit.SECONDS).build().get()) : new AtomicReference<Object>(null);
                    }
                    catch (Exception e) {
                        if (PerfClientUtils.hasInterruptedException(e)) {
                            Thread.currentThread().interrupt();
                        } else {
                            log.error("Failed to build Producer/Consumer with exception : ", (Throwable)e);
                        }
                        executorService.shutdownNow();
                        PerfClientUtils.exit(1);
                    }
                    block6: while (!Thread.currentThread().isInterrupted()) {
                        if (this.numTransactions > 0L && totalNumTxnOpenTxnFail.sum() + totalNumTxnOpenTxnSuccess.sum() >= this.numTransactions) {
                            if (totalNumEndTxnOpFailed.sum() + totalNumEndTxnOpSuccess.sum() < this.numTransactions) continue;
                            log.info("------------------- DONE -----------------------");
                            executing.compareAndSet(true, false);
                            executorService.shutdownNow();
                            PerfClientUtils.exit(0);
                            break;
                        }
                        if (this.testTime > 0L && System.nanoTime() > testEndTime) {
                            log.info("------------------- DONE -----------------------");
                            executing.compareAndSet(true, false);
                            executorService.shutdownNow();
                            PerfClientUtils.exit(0);
                            break;
                        }
                        Transaction transaction = atomicReference.get();
                        for (List<Consumer<byte[]>> list : consumers) {
                            for (Consumer<byte[]> consumer : list) {
                                for (int j = 0; j < this.numMessagesReceivedPerTransaction; ++j) {
                                    Message message = null;
                                    try {
                                        message = consumer.receive();
                                    }
                                    catch (PulsarClientException e) {
                                        log.error("Receive message failed", (Throwable)e);
                                        executorService.shutdownNow();
                                        PerfClientUtils.exit(1);
                                    }
                                    long receiveTime = System.nanoTime();
                                    if (!this.isDisableTransaction) {
                                        ((CompletableFuture)consumer.acknowledgeAsync(message.getMessageId(), transaction).thenRun(() -> {
                                            long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - receiveTime);
                                            messageAckRecorder.recordValue(latencyMicros);
                                            messageAckCumulativeRecorder.recordValue(latencyMicros);
                                            numMessagesAckSuccess.increment();
                                        })).exceptionally(exception -> {
                                            if (PerfClientUtils.hasInterruptedException(exception)) {
                                                Thread.currentThread().interrupt();
                                                return null;
                                            }
                                            log.error("Ack message failed with transaction {} throw exception", (Object)transaction, exception);
                                            numMessagesAckFailed.increment();
                                            return null;
                                        });
                                        continue;
                                    }
                                    ((CompletableFuture)consumer.acknowledgeAsync(message).thenRun(() -> {
                                        long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - receiveTime);
                                        messageAckRecorder.recordValue(latencyMicros);
                                        messageAckCumulativeRecorder.recordValue(latencyMicros);
                                        numMessagesAckSuccess.increment();
                                    })).exceptionally(exception -> {
                                        if (PerfClientUtils.hasInterruptedException(exception)) {
                                            Thread.currentThread().interrupt();
                                            return null;
                                        }
                                        log.error("Ack message failed with transaction {} throw exception", (Object)transaction, exception);
                                        numMessagesAckFailed.increment();
                                        return null;
                                    });
                                }
                            }
                        }
                        for (Producer producer : producers) {
                            for (int j = 0; j < this.numMessagesProducedPerTransaction; ++j) {
                                long sendTime = System.nanoTime();
                                if (!this.isDisableTransaction) {
                                    ((CompletableFuture)producer.newMessage(transaction).value((Object)payloadBytes).sendAsync().thenRun(() -> {
                                        long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - sendTime);
                                        messageSendRecorder.recordValue(latencyMicros);
                                        messageSendRCumulativeRecorder.recordValue(latencyMicros);
                                        numMessagesSendSuccess.increment();
                                    })).exceptionally(exception -> {
                                        if (PerfClientUtils.hasInterruptedException(exception)) {
                                            Thread.currentThread().interrupt();
                                            return null;
                                        }
                                        if (exception.getCause() instanceof PulsarClientException.AlreadyClosedException) {
                                            return null;
                                        }
                                        log.error("Send transaction message failed with exception : ", exception);
                                        numMessagesSendFailed.increment();
                                        return null;
                                    });
                                    continue;
                                }
                                ((CompletableFuture)producer.newMessage().value((Object)payloadBytes).sendAsync().thenRun(() -> {
                                    long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - sendTime);
                                    messageSendRecorder.recordValue(latencyMicros);
                                    messageSendRCumulativeRecorder.recordValue(latencyMicros);
                                    numMessagesSendSuccess.increment();
                                })).exceptionally(exception -> {
                                    if (PerfClientUtils.hasInterruptedException(exception)) {
                                        Thread.currentThread().interrupt();
                                        return null;
                                    }
                                    if (exception.getCause() instanceof PulsarClientException.AlreadyClosedException) {
                                        return null;
                                    }
                                    log.error("Send message failed with exception : ", exception);
                                    numMessagesSendFailed.increment();
                                    return null;
                                });
                            }
                        }
                        if (rateLimiter != null) {
                            rateLimiter.tryAcquire();
                        }
                        if (!this.isDisableTransaction) {
                            if (!this.isAbortTransaction) {
                                ((CompletableFuture)transaction.commit().thenRun(() -> {
                                    numTxnOpSuccess.increment();
                                    totalNumEndTxnOpSuccess.increment();
                                })).exceptionally(exception -> {
                                    if (PerfClientUtils.hasInterruptedException(exception)) {
                                        Thread.currentThread().interrupt();
                                        return null;
                                    }
                                    log.error("Commit transaction {} failed with exception", (Object)transaction.getTxnID().toString(), exception);
                                    totalNumEndTxnOpFailed.increment();
                                    return null;
                                });
                            } else {
                                ((CompletableFuture)transaction.abort().thenRun(() -> {
                                    numTxnOpSuccess.increment();
                                    totalNumEndTxnOpSuccess.increment();
                                })).exceptionally(exception -> {
                                    if (PerfClientUtils.hasInterruptedException(exception)) {
                                        Thread.currentThread().interrupt();
                                        return null;
                                    }
                                    log.error("Commit transaction {} failed with exception", (Object)transaction.getTxnID().toString(), exception);
                                    totalNumEndTxnOpFailed.increment();
                                    return null;
                                });
                            }
                            while (!Thread.currentThread().isInterrupted()) {
                                try {
                                    Transaction newTransaction = (Transaction)client.newTransaction().withTransactionTimeout(this.transactionTimeout, TimeUnit.SECONDS).build().get();
                                    atomicReference.compareAndSet(transaction, newTransaction);
                                    totalNumTxnOpenTxnSuccess.increment();
                                    continue block6;
                                }
                                catch (Exception throwable) {
                                    if (PerfClientUtils.hasInterruptedException(throwable)) {
                                        Thread.currentThread().interrupt();
                                        continue;
                                    }
                                    log.error("Failed to new transaction with exception: ", (Throwable)throwable);
                                    totalNumTxnOpenTxnFail.increment();
                                }
                            }
                            continue;
                        }
                        totalNumTxnOpenTxnSuccess.increment();
                        totalNumEndTxnOpSuccess.increment();
                        numTxnOpSuccess.increment();
                    }
                });
            }
            long oldTime = System.nanoTime();
            Histogram reportSendHistogram = null;
            Histogram reportAckHistogram = null;
            String statsFileName = "perf-transaction-" + System.currentTimeMillis() + ".hgrm";
            log.info("Dumping latency stats to {}", (Object)statsFileName);
            PrintStream histogramLog = new PrintStream(new FileOutputStream(statsFileName), false);
            HistogramLogWriter histogramLogWriter = new HistogramLogWriter(histogramLog);
            histogramLogWriter.outputLogFormatVersion();
            histogramLogWriter.outputLegend();
            while (!Thread.currentThread().isInterrupted() && executing.get()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                long now = System.nanoTime();
                double elapsed = (double)(now - oldTime) / 1.0E9;
                long total = totalNumEndTxnOpFailed.sum() + totalNumTxnOpenTxnSuccess.sum();
                double rate = (double)numTxnOpSuccess.sumThenReset() / elapsed;
                reportSendHistogram = messageSendRecorder.getIntervalHistogram(reportSendHistogram);
                reportAckHistogram = messageAckRecorder.getIntervalHistogram(reportAckHistogram);
                String txnOrTaskLog = !this.isDisableTransaction ? "Throughput transaction: {} transaction executes --- {} transaction/s" : "Throughput task: {} task executes --- {} task/s";
                log.info(txnOrTaskLog + "  --- send Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {} --- ack Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{INTFORMAT.format(total), DEC.format(rate), DEC.format(reportSendHistogram.getMean() / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(99.99) / 1000.0), DEC.format((double)reportSendHistogram.getMaxValue() / 1000.0), DEC.format(reportAckHistogram.getMean() / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(99.99) / 1000.0), DEC.format((double)reportAckHistogram.getMaxValue() / 1000.0)});
                histogramLogWriter.outputIntervalHistogram((EncodableHistogram)reportSendHistogram);
                histogramLogWriter.outputIntervalHistogram((EncodableHistogram)reportAckHistogram);
                reportSendHistogram.reset();
                reportAckHistogram.reset();
                oldTime = now;
            }
            PerfClientUtils.removeAndRunShutdownHook(shutdownHookThread);
        }
        finally {
            PerfClientUtils.closeClient(client);
        }
    }

    private static void printTxnAggregatedThroughput(long start) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        long numTransactionEndFailed = totalNumEndTxnOpFailed.sum();
        long numTransactionEndSuccess = totalNumEndTxnOpSuccess.sum();
        long total = numTransactionEndFailed + numTransactionEndSuccess;
        double rate = (double)total / elapsed;
        long numMessageAckFailed = numMessagesAckFailed.sum();
        long numMessageAckSuccess = numMessagesAckSuccess.sum();
        long numMessageSendFailed = numMessagesSendFailed.sum();
        long numMessageSendSuccess = numMessagesSendSuccess.sum();
        long numTransactionOpenFailed = totalNumTxnOpenTxnFail.sum();
        long numTransactionOpenSuccess = totalNumTxnOpenTxnSuccess.sum();
        log.info("Aggregated throughput stats --- {} transaction executed --- {} transaction/s  --- {} transaction open successfully --- {} transaction open failed --- {} transaction end successfully --- {} transaction end failed --- {} message ack failed --- {} message send failed --- {} message ack success --- {} message send success ", new Object[]{total, DEC.format(rate), numTransactionOpenSuccess, numTransactionOpenFailed, numTransactionEndSuccess, numTransactionEndFailed, numMessageAckFailed, numMessageSendFailed, numMessageAckSuccess, numMessageSendSuccess});
    }

    private static void printAggregatedThroughput(long start) {
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        long total = totalNumEndTxnOpFailed.sum() + totalNumEndTxnOpSuccess.sum();
        double rate = (double)total / elapsed;
        long numMessageAckFailed = numMessagesAckFailed.sum();
        long numMessageAckSuccess = numMessagesAckSuccess.sum();
        long numMessageSendFailed = numMessagesSendFailed.sum();
        long numMessageSendSuccess = numMessagesSendSuccess.sum();
        log.info("Aggregated throughput stats --- {} task executed --- {} task/s --- {} message ack failed --- {} message send failed --- {} message ack success --- {} message send success", new Object[]{total, TOTALFORMAT.format(rate), numMessageAckFailed, numMessageSendFailed, numMessageAckSuccess, numMessageSendSuccess});
    }

    private static void printAggregatedStats() {
        Histogram reportAckHistogram = messageAckCumulativeRecorder.getIntervalHistogram();
        Histogram reportSendHistogram = messageSendRCumulativeRecorder.getIntervalHistogram();
        log.info("Messages ack aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{DEC.format(reportAckHistogram.getMean() / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(99.99) / 1000.0), DEC.format((double)reportAckHistogram.getValueAtPercentile(99.999) / 1000.0), DEC.format((double)reportAckHistogram.getMaxValue() / 1000.0)});
        log.info("Messages send aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{DEC.format(reportSendHistogram.getMean() / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(50.0) / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(95.0) / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(99.0) / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(99.9) / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(99.99) / 1000.0), DEC.format((double)reportSendHistogram.getValueAtPercentile(99.999) / 1000.0), DEC.format((double)reportSendHistogram.getMaxValue() / 1000.0)});
    }

    private List<List<Consumer<byte[]>>> buildConsumer(PulsarClient client) throws ExecutionException, InterruptedException {
        ConsumerBuilder consumerBuilder = client.newConsumer(Schema.BYTES).subscriptionType(this.subscriptionType).receiverQueueSize(this.receiverQueueSize).subscriptionInitialPosition(this.subscriptionInitialPosition).replicateSubscriptionState(this.replicatedSubscription);
        Iterator<String> consumerTopicsIterator = this.consumerTopic.iterator();
        ArrayList<List<Consumer<byte[]>>> consumers = new ArrayList<List<Consumer<byte[]>>>(this.consumerTopic.size());
        while (consumerTopicsIterator.hasNext()) {
            String topic = consumerTopicsIterator.next();
            ArrayList<Consumer> subscriptions = new ArrayList<Consumer>(this.numSubscriptions);
            ArrayList<CompletableFuture> subscriptionFutures = new ArrayList<CompletableFuture>(this.numSubscriptions);
            log.info("Create subscriptions for topic {}", (Object)topic);
            for (int j = 0; j < this.numSubscriptions; ++j) {
                String string = this.subscriptions.get(j);
                subscriptionFutures.add(consumerBuilder.clone().topic(new String[]{topic}).subscriptionName(string).subscribeAsync());
            }
            for (Future future : subscriptionFutures) {
                subscriptions.add((Consumer)future.get());
            }
            consumers.add(subscriptions);
        }
        return consumers;
    }

    private List<Producer<byte[]>> buildProducers(PulsarClient client) throws ExecutionException, InterruptedException {
        ProducerBuilder producerBuilder = client.newProducer(Schema.BYTES).sendTimeout(0, TimeUnit.SECONDS);
        ArrayList<CompletableFuture> producerFutures = new ArrayList<CompletableFuture>();
        for (String topic : this.producerTopic) {
            log.info("Create producer for topic {}", (Object)topic);
            producerFutures.add(producerBuilder.clone().topic(topic).createAsync());
        }
        ArrayList<Producer<byte[]>> producers = new ArrayList<Producer<byte[]>>(producerFutures.size());
        for (Future future : producerFutures) {
            producers.add((Producer<byte[]>)((Producer)future.get()));
        }
        return producers;
    }
}

