/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.broker.transaction.pendingack.proto.LightProtoCodec;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckMetadata;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckOp;
import org.apache.pulsar.common.api.proto.CommandAck;

public final class PendingAckMetadataEntry {
    private PendingAckOp pendingAckOp;
    private static final int _PENDING_ACK_OP_FIELD_NUMBER = 1;
    private static final int _PENDING_ACK_OP_TAG = 8;
    private static final int _PENDING_ACK_OP_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _PENDING_ACK_OP_MASK = 1;
    private CommandAck.AckType ackType;
    private static final int _ACK_TYPE_FIELD_NUMBER = 2;
    private static final int _ACK_TYPE_TAG = 16;
    private static final int _ACK_TYPE_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _ACK_TYPE_MASK = 2;
    private long txnidLeastBits;
    private static final int _TXNID_LEAST_BITS_FIELD_NUMBER = 3;
    private static final int _TXNID_LEAST_BITS_TAG = 24;
    private static final int _TXNID_LEAST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _TXNID_LEAST_BITS_MASK = 4;
    private long txnidMostBits;
    private static final int _TXNID_MOST_BITS_FIELD_NUMBER = 4;
    private static final int _TXNID_MOST_BITS_TAG = 32;
    private static final int _TXNID_MOST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _TXNID_MOST_BITS_MASK = 8;
    private List<PendingAckMetadata> pendingAckMetadatas = null;
    private int _pendingAckMetadatasCount = 0;
    private static final int _PENDING_ACK_METADATA_FIELD_NUMBER = 5;
    private static final int _PENDING_ACK_METADATA_TAG = 42;
    private static final int _PENDING_ACK_METADATA_TAG_SIZE = LightProtoCodec.computeVarIntSize(42);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 0;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasPendingAckOp() {
        return (this._bitField0 & 1) != 0;
    }

    public PendingAckOp getPendingAckOp() {
        if (!this.hasPendingAckOp()) {
            throw new IllegalStateException("Field 'pending_ack_op' is not set");
        }
        return this.pendingAckOp;
    }

    public PendingAckMetadataEntry setPendingAckOp(PendingAckOp pendingAckOp) {
        this.pendingAckOp = pendingAckOp;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public PendingAckMetadataEntry clearPendingAckOp() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasAckType() {
        return (this._bitField0 & 2) != 0;
    }

    public CommandAck.AckType getAckType() {
        if (!this.hasAckType()) {
            throw new IllegalStateException("Field 'ack_type' is not set");
        }
        return this.ackType;
    }

    public PendingAckMetadataEntry setAckType(CommandAck.AckType ackType) {
        this.ackType = ackType;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public PendingAckMetadataEntry clearAckType() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public boolean hasTxnidLeastBits() {
        return (this._bitField0 & 4) != 0;
    }

    public long getTxnidLeastBits() {
        if (!this.hasTxnidLeastBits()) {
            throw new IllegalStateException("Field 'txnid_least_bits' is not set");
        }
        return this.txnidLeastBits;
    }

    public PendingAckMetadataEntry setTxnidLeastBits(long txnidLeastBits) {
        this.txnidLeastBits = txnidLeastBits;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public PendingAckMetadataEntry clearTxnidLeastBits() {
        this._bitField0 &= 0xFFFFFFFB;
        return this;
    }

    public boolean hasTxnidMostBits() {
        return (this._bitField0 & 8) != 0;
    }

    public long getTxnidMostBits() {
        if (!this.hasTxnidMostBits()) {
            throw new IllegalStateException("Field 'txnid_most_bits' is not set");
        }
        return this.txnidMostBits;
    }

    public PendingAckMetadataEntry setTxnidMostBits(long txnidMostBits) {
        this.txnidMostBits = txnidMostBits;
        this._bitField0 |= 8;
        this._cachedSize = -1;
        return this;
    }

    public PendingAckMetadataEntry clearTxnidMostBits() {
        this._bitField0 &= 0xFFFFFFF7;
        return this;
    }

    public int getPendingAckMetadatasCount() {
        return this._pendingAckMetadatasCount;
    }

    public PendingAckMetadata getPendingAckMetadataAt(int idx) {
        if (idx < 0 || idx >= this._pendingAckMetadatasCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._pendingAckMetadatasCount + ") for field 'pending_ack_metadata'");
        }
        return this.pendingAckMetadatas.get(idx);
    }

    public List<PendingAckMetadata> getPendingAckMetadatasList() {
        if (this._pendingAckMetadatasCount == 0) {
            return Collections.emptyList();
        }
        return this.pendingAckMetadatas.subList(0, this._pendingAckMetadatasCount);
    }

    public PendingAckMetadata addPendingAckMetadata() {
        if (this.pendingAckMetadatas == null) {
            this.pendingAckMetadatas = new ArrayList<PendingAckMetadata>();
        }
        if (this.pendingAckMetadatas.size() == this._pendingAckMetadatasCount) {
            this.pendingAckMetadatas.add(new PendingAckMetadata());
        }
        this._cachedSize = -1;
        return this.pendingAckMetadatas.get(this._pendingAckMetadatasCount++);
    }

    public PendingAckMetadataEntry addAllPendingAckMetadatas(Iterable<PendingAckMetadata> pendingAckMetadatas) {
        for (PendingAckMetadata _o : pendingAckMetadatas) {
            this.addPendingAckMetadata().copyFrom(_o);
        }
        return this;
    }

    public PendingAckMetadataEntry clearPendingAckMetadata() {
        for (int i = 0; i < this._pendingAckMetadatasCount; ++i) {
            this.pendingAckMetadatas.get(i).clear();
        }
        this._pendingAckMetadatasCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        int _writeIdx = _b.writerIndex();
        if (this.hasPendingAckOp()) {
            LightProtoCodec.writeVarInt(_b, 8);
            LightProtoCodec.writeVarInt(_b, this.pendingAckOp.getValue());
        }
        if (this.hasAckType()) {
            LightProtoCodec.writeVarInt(_b, 16);
            LightProtoCodec.writeVarInt(_b, this.ackType.getValue());
        }
        if (this.hasTxnidLeastBits()) {
            LightProtoCodec.writeVarInt(_b, 24);
            LightProtoCodec.writeVarInt64(_b, this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            LightProtoCodec.writeVarInt(_b, 32);
            LightProtoCodec.writeVarInt64(_b, this.txnidMostBits);
        }
        for (int i = 0; i < this._pendingAckMetadatasCount; ++i) {
            PendingAckMetadata _item = this.pendingAckMetadatas.get(i);
            LightProtoCodec.writeVarInt(_b, 42);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        if (this.hasPendingAckOp()) {
            _size += _PENDING_ACK_OP_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.pendingAckOp.getValue());
        }
        if (this.hasAckType()) {
            _size += _ACK_TYPE_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.ackType.getValue());
        }
        if (this.hasTxnidLeastBits()) {
            _size += _TXNID_LEAST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            _size += _TXNID_MOST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidMostBits);
        }
        for (int i = 0; i < this._pendingAckMetadatasCount; ++i) {
            PendingAckMetadata _item = this.pendingAckMetadatas.get(i);
            _size += _PENDING_ACK_METADATA_TAG_SIZE;
            int MsgsizePendingAckMetadata = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizePendingAckMetadata) + MsgsizePendingAckMetadata;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block7: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    PendingAckOp _pendingAckOp = PendingAckOp.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_pendingAckOp == null) continue block7;
                    this._bitField0 |= 1;
                    this.pendingAckOp = _pendingAckOp;
                    continue block7;
                }
                case 16: {
                    CommandAck.AckType _ackType = CommandAck.AckType.valueOf((int)LightProtoCodec.readVarInt(_buffer));
                    if (_ackType == null) continue block7;
                    this._bitField0 |= 2;
                    this.ackType = _ackType;
                    continue block7;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.txnidLeastBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block7;
                }
                case 32: {
                    this._bitField0 |= 8;
                    this.txnidMostBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block7;
                }
                case 42: {
                    int _pendingAckMetadataSize = LightProtoCodec.readVarInt(_buffer);
                    this.addPendingAckMetadata().parseFrom(_buffer, _pendingAckMetadataSize);
                    continue block7;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this._parsedBuffer = _buffer;
    }

    public PendingAckMetadataEntry clear() {
        for (int i = 0; i < this._pendingAckMetadatasCount; ++i) {
            this.pendingAckMetadatas.get(i).clear();
        }
        this._pendingAckMetadatasCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public PendingAckMetadataEntry copyFrom(PendingAckMetadataEntry _other) {
        this._cachedSize = -1;
        if (_other.hasPendingAckOp()) {
            this.setPendingAckOp(_other.pendingAckOp);
        }
        if (_other.hasAckType()) {
            this.setAckType(_other.ackType);
        }
        if (_other.hasTxnidLeastBits()) {
            this.setTxnidLeastBits(_other.txnidLeastBits);
        }
        if (_other.hasTxnidMostBits()) {
            this.setTxnidMostBits(_other.txnidMostBits);
        }
        for (int i = 0; i < _other.getPendingAckMetadatasCount(); ++i) {
            this.addPendingAckMetadata().copyFrom(_other.getPendingAckMetadataAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a);
        this.parseFrom(b, b.readableBytes());
    }
}

