/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.metrics;

import org.apache.pulsar.client.impl.MemoryLimitController;
import org.apache.pulsar.client.impl.metrics.InstrumentProvider;
import org.apache.pulsar.client.impl.metrics.ObservableUpDownCounter;
import org.apache.pulsar.client.impl.metrics.Unit;

public class MemoryBufferStats
implements AutoCloseable {
    public static final String BUFFER_USAGE_COUNTER = "pulsar.client.memory.buffer.usage";
    private final ObservableUpDownCounter bufferUsageCounter;
    public static final String BUFFER_LIMIT_COUNTER = "pulsar.client.memory.buffer.limit";
    private final ObservableUpDownCounter bufferLimitCounter;

    public MemoryBufferStats(InstrumentProvider instrumentProvider, MemoryLimitController memoryLimitController) {
        this.bufferUsageCounter = instrumentProvider.newObservableUpDownCounter(BUFFER_USAGE_COUNTER, Unit.Bytes, "Current memory buffer usage by the client", null, null, measurement -> {
            if (memoryLimitController.isMemoryLimited()) {
                measurement.record(memoryLimitController.currentUsage());
            }
        });
        this.bufferLimitCounter = instrumentProvider.newObservableUpDownCounter(BUFFER_LIMIT_COUNTER, Unit.Bytes, "Memory buffer limit configured for the client", null, null, measurement -> {
            if (memoryLimitController.isMemoryLimited()) {
                measurement.record(memoryLimitController.memoryLimit());
            }
        });
    }

    @Override
    public void close() {
        this.bufferUsageCounter.close();
        this.bufferLimitCounter.close();
    }
}

